/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class BufferBuilder
implements AutoCloseable {
    private final Buffer buffer;
    private final MemorySegment memorySegment;
    private int maxCapacity;
    private final SettablePositionMarker positionMarker = new SettablePositionMarker();
    private boolean bufferConsumerCreated = false;

    public BufferBuilder(MemorySegment memorySegment, BufferRecycler recycler) {
        this.memorySegment = (MemorySegment)Preconditions.checkNotNull((Object)memorySegment);
        this.buffer = new NetworkBuffer(memorySegment, recycler);
        this.maxCapacity = this.buffer.getMaxCapacity();
    }

    public BufferConsumer createBufferConsumer() {
        return this.createBufferConsumer(this.positionMarker.cachedPosition);
    }

    public BufferConsumer createBufferConsumerFromBeginning() {
        return this.createBufferConsumer(0);
    }

    private BufferConsumer createBufferConsumer(int currentReaderPosition) {
        Preconditions.checkState((!this.bufferConsumerCreated ? 1 : 0) != 0, (Object)"Two BufferConsumer shouldn't exist for one BufferBuilder");
        this.bufferConsumerCreated = true;
        return new BufferConsumer(this.buffer.retainBuffer(), this.positionMarker, currentReaderPosition);
    }

    public Buffer.DataType getDataType() {
        return this.buffer.getDataType();
    }

    public void setDataType(Buffer.DataType dataType) {
        this.buffer.setDataType(dataType);
    }

    public int appendAndCommit(ByteBuffer source) {
        int writtenBytes = this.append(source);
        this.commit();
        return writtenBytes;
    }

    public int append(ByteBuffer source) {
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0);
        int needed = source.remaining();
        int available = this.getMaxCapacity() - this.positionMarker.getCached();
        int toCopy = Math.min(needed, available);
        this.memorySegment.put(this.positionMarker.getCached(), source, toCopy);
        this.positionMarker.move(toCopy);
        return toCopy;
    }

    public void commit() {
        this.positionMarker.commit();
    }

    public int finish() {
        int writtenBytes = this.positionMarker.markFinished();
        this.commit();
        return writtenBytes;
    }

    public boolean isFinished() {
        return this.positionMarker.isFinished();
    }

    public boolean isFull() {
        Preconditions.checkState((this.positionMarker.getCached() <= this.getMaxCapacity() ? 1 : 0) != 0);
        return this.positionMarker.getCached() == this.getMaxCapacity();
    }

    public int getWritableBytes() {
        Preconditions.checkState((this.positionMarker.getCached() <= this.getMaxCapacity() ? 1 : 0) != 0);
        return this.getMaxCapacity() - this.positionMarker.getCached();
    }

    public int getCommittedBytes() {
        return this.positionMarker.getCached();
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void trim(int newSize) {
        this.maxCapacity = Math.min(Math.max(newSize, this.positionMarker.getCached()), this.buffer.getMaxCapacity());
    }

    @Override
    public void close() {
        this.buffer.recycleBuffer();
    }

    static class SettablePositionMarker
    implements PositionMarker {
        private volatile int position = 0;
        private int cachedPosition = 0;

        SettablePositionMarker() {
        }

        @Override
        public int get() {
            return this.position;
        }

        public boolean isFinished() {
            return PositionMarker.isFinished(this.cachedPosition);
        }

        public int getCached() {
            return PositionMarker.getAbsolute(this.cachedPosition);
        }

        public int markFinished() {
            int currentPosition = this.getCached();
            int newValue = -currentPosition;
            if (newValue == 0) {
                newValue = Integer.MIN_VALUE;
            }
            this.set(newValue);
            return currentPosition;
        }

        public void move(int offset) {
            this.set(this.cachedPosition + offset);
        }

        public void set(int value) {
            this.cachedPosition = value;
        }

        public void commit() {
            this.position = this.cachedPosition;
        }
    }

    @ThreadSafe
    static interface PositionMarker {
        public static final int FINISHED_EMPTY = Integer.MIN_VALUE;

        public int get();

        public static boolean isFinished(int position) {
            return position < 0;
        }

        public static int getAbsolute(int position) {
            if (position == Integer.MIN_VALUE) {
                return 0;
            }
            return Math.abs(position);
        }
    }
}

