/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.util.Preconditions;

class DefaultLeaderElection
implements LeaderElection {
    private final ParentService parentService;
    private final String componentId;

    DefaultLeaderElection(ParentService parentService, String componentId) {
        this.parentService = parentService;
        this.componentId = componentId;
    }

    @Override
    public void startLeaderElection(LeaderContender contender) throws Exception {
        Preconditions.checkNotNull((Object)contender);
        this.parentService.register(this.componentId, contender);
    }

    @Override
    public void confirmLeadership(UUID leaderSessionID, String leaderAddress) {
        this.parentService.confirmLeadership(this.componentId, leaderSessionID, leaderAddress);
    }

    @Override
    public boolean hasLeadership(UUID leaderSessionId) {
        return this.parentService.hasLeadership(this.componentId, leaderSessionId);
    }

    @Override
    public void close() throws Exception {
        this.parentService.remove(this.componentId);
    }

    static abstract class ParentService {
        ParentService() {
        }

        abstract void register(String var1, LeaderContender var2) throws Exception;

        abstract void remove(String var1) throws Exception;

        abstract void confirmLeadership(String var1, UUID var2, String var3);

        abstract boolean hasLeadership(String var1, UUID var2);
    }
}

