/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.List;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.throwable.ThrowableAnnotation;
import org.apache.flink.runtime.throwable.ThrowableType;

@ThrowableAnnotation(value=ThrowableType.NonRecoverableError)
public class ClusterDatasetCorruptedException
extends JobException {
    private final List<IntermediateDataSetID> corruptedClusterDatasetIds;

    public ClusterDatasetCorruptedException(Throwable cause, List<IntermediateDataSetID> corruptedClusterDatasetIds) {
        super(String.format("Corrupted cluster dataset IDs: %s", corruptedClusterDatasetIds), cause);
        this.corruptedClusterDatasetIds = corruptedClusterDatasetIds;
    }

    public List<IntermediateDataSetID> getCorruptedClusterDatasetIds() {
        return this.corruptedClusterDatasetIds;
    }
}

