/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.BackendBuildingException;
import org.apache.flink.runtime.state.DefaultOperatorStateBackend;
import org.apache.flink.runtime.state.DefaultOperatorStateBackendSnapshotStrategy;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStateRestoreOperation;
import org.apache.flink.runtime.state.SnapshotExecutionType;
import org.apache.flink.runtime.state.SnapshotStrategyRunner;
import org.apache.flink.runtime.state.StateBackendBuilder;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.util.IOUtils;

public class DefaultOperatorStateBackendBuilder
implements StateBackendBuilder<DefaultOperatorStateBackend, BackendBuildingException> {
    @VisibleForTesting
    protected final ClassLoader userClassloader;
    @VisibleForTesting
    protected final ExecutionConfig executionConfig;
    @VisibleForTesting
    protected final boolean asynchronousSnapshots;
    @VisibleForTesting
    protected final Collection<OperatorStateHandle> restoreStateHandles;
    @VisibleForTesting
    protected final CloseableRegistry cancelStreamRegistry;

    public DefaultOperatorStateBackendBuilder(ClassLoader userClassloader, ExecutionConfig executionConfig, boolean asynchronousSnapshots, Collection<OperatorStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) {
        this.userClassloader = userClassloader;
        this.executionConfig = executionConfig;
        this.asynchronousSnapshots = asynchronousSnapshots;
        this.restoreStateHandles = stateHandles;
        this.cancelStreamRegistry = cancelStreamRegistry;
    }

    @Override
    public DefaultOperatorStateBackend build() throws BackendBuildingException {
        HashMap registeredOperatorStates = new HashMap();
        HashMap registeredBroadcastStates = new HashMap();
        CloseableRegistry cancelStreamRegistryForBackend = new CloseableRegistry();
        StreamCompressionDecorator compressionDecorator = AbstractStateBackend.getCompressionDecorator(this.executionConfig);
        DefaultOperatorStateBackendSnapshotStrategy snapshotStrategy = new DefaultOperatorStateBackendSnapshotStrategy(this.userClassloader, registeredOperatorStates, registeredBroadcastStates, compressionDecorator);
        OperatorStateRestoreOperation restoreOperation = new OperatorStateRestoreOperation(this.cancelStreamRegistry, this.userClassloader, registeredOperatorStates, registeredBroadcastStates, this.restoreStateHandles);
        try {
            restoreOperation.restore();
        }
        catch (Exception e) {
            IOUtils.closeQuietly((AutoCloseable)cancelStreamRegistryForBackend);
            throw new BackendBuildingException("Failed when trying to restore operator state backend", e);
        }
        return new DefaultOperatorStateBackend(this.executionConfig, cancelStreamRegistryForBackend, registeredOperatorStates, registeredBroadcastStates, new HashMap(), new HashMap(), new SnapshotStrategyRunner<OperatorStateHandle, DefaultOperatorStateBackendSnapshotStrategy.DefaultOperatorStateBackendSnapshotResources>("DefaultOperatorStateBackend snapshot", snapshotStrategy, cancelStreamRegistryForBackend, this.asynchronousSnapshots ? SnapshotExecutionType.ASYNCHRONOUS : SnapshotExecutionType.SYNCHRONOUS));
    }
}

