/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.sort.AlphanumericComparer;
import net.sf.saxon.sort.LowercaseFirstComparer;
import net.sf.saxon.sort.UppercaseFirstComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public abstract class JavaCollationFactory {
    private JavaCollationFactory() {
    }

    public static Comparator makeCollation(Configuration configuration, Properties properties) throws XPathException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        Comparator comparator = null;
        String string6 = properties.getProperty("class");
        if (string6 != null) {
            object = configuration.getInstance(string6, null);
            if (object instanceof Comparator) {
                comparator = (Comparator)object;
            } else {
                throw new DynamicError("Requested collation class " + string6 + " is not a Comparator");
            }
        }
        if ((object = properties.getProperty("rules")) != null && comparator == null) {
            try {
                comparator = new RuleBasedCollator((String)object);
            }
            catch (ParseException parseException) {
                throw new DynamicError("Invalid collation rules: " + parseException.getMessage());
            }
        }
        if (comparator == null) {
            string5 = properties.getProperty("lang");
            comparator = string5 != null ? Collator.getInstance(JavaCollationFactory.getLocale(string5)) : Collator.getInstance();
        }
        if ((string5 = properties.getProperty("strength")) != null) {
            if (string5.equals("primary") && comparator instanceof Collator) {
                ((Collator)comparator).setStrength(0);
            } else if (string5.equals("secondary")) {
                ((Collator)comparator).setStrength(1);
            } else if (string5.equals("tertiary")) {
                ((Collator)comparator).setStrength(2);
            } else if (string5.equals("identical")) {
                ((Collator)comparator).setStrength(3);
            } else {
                throw new DynamicError("strength must be primary, secondary, tertiary, or identical");
            }
        }
        if ((string4 = properties.getProperty("ignore-width")) != null) {
            if (string4.equals("yes") && string5 == null && comparator instanceof Collator) {
                ((Collator)comparator).setStrength(2);
            } else if (!string4.equals("no")) {
                throw new DynamicError("ignore-width must be yes or no");
            }
        }
        if ((string4 = properties.getProperty("ignore-case")) != null && string5 == null && comparator instanceof Collator) {
            if (string4.equals("yes")) {
                ((Collator)comparator).setStrength(1);
            } else if (!string4.equals("no")) {
                throw new DynamicError("ignore-case must be yes or no");
            }
        }
        if ((string4 = properties.getProperty("ignore-modifiers")) != null) {
            if (string4.equals("yes") && string5 == null && comparator instanceof Collator) {
                ((Collator)comparator).setStrength(0);
            } else if (!string4.equals("no")) {
                throw new DynamicError("ignore-modifiers must be yes or no");
            }
        }
        if ((string3 = properties.getProperty("decomposition")) != null && comparator instanceof Collator) {
            if (string3.equals("none")) {
                ((Collator)comparator).setDecomposition(0);
            } else if (string3.equals("standard")) {
                ((Collator)comparator).setDecomposition(1);
            } else if (string3.equals("full")) {
                ((Collator)comparator).setDecomposition(2);
            } else {
                throw new DynamicError("decomposition must be non, standard, or full");
            }
        }
        if ((string2 = properties.getProperty("case-order")) != null && !"#default".equals(string2)) {
            if (comparator instanceof Collator) {
                ((Collator)comparator).setStrength(1);
            }
            if (string2.equals("lower-first")) {
                comparator = new LowercaseFirstComparer(comparator);
            } else if (string2.equals("upper-first")) {
                comparator = new UppercaseFirstComparer(comparator);
            } else {
                throw new DynamicError("case-order must be lower-first, upper-first, or #default");
            }
        }
        if ((string = properties.getProperty("alphanumeric")) != null && !"no".equals(string)) {
            if (string.equals("yes")) {
                comparator = new AlphanumericComparer(comparator);
            } else {
                throw new DynamicError("alphanumeric must be yes or no");
            }
        }
        return comparator;
    }

    private static Locale getLocale(String string) {
        String string2;
        String string3;
        int n = string.indexOf("-");
        if (n < 1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(1, n);
            string2 = string.substring(n + 1);
        }
        return new Locale(string3, string2);
    }
}

