/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.auth;

import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class StaticUserAuthenticator
implements UserAuthenticator,
Comparable<StaticUserAuthenticator> {
    private static final Log LOG = LogFactory.getLog(StaticUserAuthenticator.class);
    private final String userName;
    private final String password;
    private final String domain;

    public StaticUserAuthenticator(String domain, String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.domain = domain;
    }

    private int compareStringOrNull(String thisString, String otherString) {
        if (thisString != null) {
            if (otherString == null) {
                return 1;
            }
            return thisString.compareTo(otherString);
        }
        if (otherString != null) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(StaticUserAuthenticator other) {
        int result = this.compareStringOrNull(this.domain, other.domain);
        result = result == 0 ? this.compareStringOrNull(this.userName, other.userName) : result;
        return result == 0 ? this.compareStringOrNull(this.password, other.password) : result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticUserAuthenticator other = (StaticUserAuthenticator)obj;
        return Objects.equals(this.domain, other.domain) && Objects.equals(this.userName, other.userName) && Objects.equals(this.password, other.password);
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 37 * result + (this.password == null ? 0 : this.password.hashCode());
        return 37 * result + (this.userName == null ? 0 : this.userName.hashCode());
    }

    @Override
    public UserAuthenticationData requestAuthentication(UserAuthenticationData.Type[] types) {
        UserAuthenticationData data = new UserAuthenticationData();
        for (UserAuthenticationData.Type type : types) {
            if (type == UserAuthenticationData.DOMAIN) {
                data.setData(UserAuthenticationData.DOMAIN, UserAuthenticatorUtils.toChar(this.domain));
                continue;
            }
            if (type == UserAuthenticationData.USERNAME) {
                data.setData(UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(this.userName));
                continue;
            }
            if (type == UserAuthenticationData.PASSWORD) {
                data.setData(UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(this.password));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(StaticUserAuthenticator.class.getSimpleName() + " does not support authentication data type '" + type + "'; authentication request for this type ignored."));
        }
        return data;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.domain != null) {
            buffer.append(this.domain).append('\\');
        }
        if (this.userName != null) {
            buffer.append(this.userName);
        } else {
            buffer.append("(null)");
        }
        if (this.password != null) {
            buffer.append(":***");
        }
        return buffer.toString();
    }
}

