/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.filter.IOCase;

public class SuffixFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IOCase caseSensitivity;
    private final List<String> suffixes;

    public SuffixFileFilter(IOCase caseSensitivity, List<String> suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException("The list of suffixes must not be null");
        }
        this.suffixes = new ArrayList<String>(suffixes);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public SuffixFileFilter(IOCase caseSensitivity, String ... suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException("The array of suffixes must not be null");
        }
        this.suffixes = new ArrayList<String>(Arrays.asList(suffixes));
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public SuffixFileFilter(List<String> suffixes) {
        this(IOCase.SENSITIVE, suffixes);
    }

    public SuffixFileFilter(String ... suffixes) {
        this(IOCase.SENSITIVE, suffixes);
    }

    @Override
    public boolean accept(FileSelectInfo fileSelectInfo) {
        String name = fileSelectInfo.getFile().getName().getBaseName();
        return this.suffixes.stream().anyMatch(suffix -> this.caseSensitivity.checkEndsWith(name, (String)suffix));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.suffixes != null) {
            buffer.append(String.join((CharSequence)",", this.suffixes));
        }
        buffer.append(")");
        return buffer.toString();
    }
}

