/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.compressed;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileSystem;

public abstract class CompressedFileFileObject<FS extends CompressedFileFileSystem>
extends AbstractFileObject<FS> {
    public static final int SIZE_UNDEFINED = -1;
    private final FileObject container;
    private final String[] children;

    protected CompressedFileFileObject(AbstractFileName fileName, FileObject container, FS fileSystem) {
        super(fileName, fileSystem);
        this.container = container;
        String baseName = container.getName().getBaseName();
        int pos = baseName.lastIndexOf(46);
        if (pos > 0) {
            baseName = baseName.substring(0, pos);
        }
        this.children = new String[]{baseName};
    }

    @Override
    public void createFile() throws FileSystemException {
        this.container.createFile();
        this.injectType(FileType.FILE);
    }

    @Override
    protected long doGetContentSize() {
        return -1L;
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.container.getContent().getLastModifiedTime();
    }

    @Override
    protected FileType doGetType() throws FileSystemException {
        if (this.getName().getPath().endsWith("/")) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected String[] doListChildren() {
        return this.children;
    }

    protected FileObject getContainer() {
        return this.container;
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        return this.getFileSystem().hasCapability(Capability.WRITE_CONTENT);
    }
}

