/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.lang.ref.WeakReference;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;

public class WeakRefFileListener
implements FileListener {
    private final FileSystem fs;
    private final FileName name;
    private final WeakReference<FileListener> listener;

    public static void installListener(FileObject file, FileListener listener) {
        file.getFileSystem().addListener(file, new WeakRefFileListener(file, listener));
    }

    protected WeakRefFileListener(FileObject file, FileListener listener) {
        this.fs = file.getFileSystem();
        this.name = file.getName();
        this.listener = new WeakReference<FileListener>(listener);
    }

    @Override
    public void fileChanged(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener != null) {
            listener.fileChanged(event);
        }
    }

    @Override
    public void fileCreated(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener != null) {
            listener.fileCreated(event);
        }
    }

    @Override
    public void fileDeleted(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener != null) {
            listener.fileDeleted(event);
        }
    }

    protected FileListener getListener() throws Exception {
        FileListener listener = (FileListener)this.listener.get();
        if (listener == null) {
            try (FileObject fileObject = this.fs.resolveFile(this.name);){
                fileObject.getFileSystem().removeListener(fileObject, this);
            }
        }
        return listener;
    }
}

