/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.aliasmap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class InMemoryAliasMap
implements InMemoryAliasMapProtocol,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryAliasMap.class);
    private final DB levelDb;
    private Configuration conf;
    private String blockPoolID;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @VisibleForTesting
    static String createPathErrorMessage(String directory) {
        return "Configured directory '" + directory + "' doesn't exist";
    }

    @Nonnull
    public static InMemoryAliasMap init(Configuration conf, String blockPoolID) throws IOException {
        Options options = new Options();
        options.createIfMissing(true);
        String directory = conf.get("dfs.provided.aliasmap.inmemory.leveldb.dir");
        LOG.info("Attempting to load InMemoryAliasMap from \"{}\"", (Object)directory);
        File levelDBpath = blockPoolID != null ? new File(directory, blockPoolID) : new File(directory);
        if (!levelDBpath.exists()) {
            String error = InMemoryAliasMap.createPathErrorMessage(directory);
            throw new IOException(error);
        }
        DB levelDb = JniDBFactory.factory.open(levelDBpath, options);
        InMemoryAliasMap aliasMap = new InMemoryAliasMap(levelDb, blockPoolID);
        aliasMap.setConf(conf);
        return aliasMap;
    }

    @VisibleForTesting
    InMemoryAliasMap(DB levelDb, String blockPoolID) {
        this.levelDb = levelDb;
        this.blockPoolID = blockPoolID;
    }

    @Override
    public InMemoryAliasMapProtocol.IterationResult list(Optional<Block> marker) throws IOException {
        try (DBIterator iterator = this.levelDb.iterator();){
            Integer batchSize = this.conf.getInt("dfs.provided.aliasmap.inmemory.batch-size", 500);
            if (marker.isPresent()) {
                iterator.seek(InMemoryAliasMap.toProtoBufBytes(marker.get()));
            } else {
                iterator.seekToFirst();
            }
            ArrayList batch = Lists.newArrayListWithExpectedSize((int)batchSize);
            for (int i = 0; iterator.hasNext() && i < batchSize; ++i) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Block block = InMemoryAliasMap.fromBlockBytes((byte[])entry.getKey());
                ProvidedStorageLocation providedStorageLocation = InMemoryAliasMap.fromProvidedStorageLocationBytes((byte[])entry.getValue());
                batch.add(new FileRegion(block, providedStorageLocation));
            }
            if (iterator.hasNext()) {
                Block nextMarker = InMemoryAliasMap.fromBlockBytes((byte[])((Map.Entry)iterator.next()).getKey());
                InMemoryAliasMapProtocol.IterationResult iterationResult = new InMemoryAliasMapProtocol.IterationResult(batch, Optional.of(nextMarker));
                return iterationResult;
            }
            InMemoryAliasMapProtocol.IterationResult iterationResult = new InMemoryAliasMapProtocol.IterationResult(batch, Optional.empty());
            return iterationResult;
        }
    }

    @Override
    @Nonnull
    public Optional<ProvidedStorageLocation> read(@Nonnull Block block) throws IOException {
        byte[] extendedBlockDbFormat = InMemoryAliasMap.toProtoBufBytes(block);
        byte[] providedStorageLocationDbFormat = this.levelDb.get(extendedBlockDbFormat);
        if (providedStorageLocationDbFormat == null) {
            return Optional.empty();
        }
        ProvidedStorageLocation providedStorageLocation = InMemoryAliasMap.fromProvidedStorageLocationBytes(providedStorageLocationDbFormat);
        return Optional.of(providedStorageLocation);
    }

    @Override
    public void write(@Nonnull Block block, @Nonnull ProvidedStorageLocation providedStorageLocation) throws IOException {
        byte[] extendedBlockDbFormat = InMemoryAliasMap.toProtoBufBytes(block);
        byte[] providedStorageLocationDbFormat = InMemoryAliasMap.toProtoBufBytes(providedStorageLocation);
        this.levelDb.put(extendedBlockDbFormat, providedStorageLocationDbFormat);
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolID;
    }

    public void close() throws IOException {
        this.levelDb.close();
    }

    @Nonnull
    public static ProvidedStorageLocation fromProvidedStorageLocationBytes(@Nonnull byte[] providedStorageLocationDbFormat) throws InvalidProtocolBufferException {
        HdfsProtos.ProvidedStorageLocationProto providedStorageLocationProto = HdfsProtos.ProvidedStorageLocationProto.parseFrom((byte[])providedStorageLocationDbFormat);
        return PBHelperClient.convert((HdfsProtos.ProvidedStorageLocationProto)providedStorageLocationProto);
    }

    @Nonnull
    public static Block fromBlockBytes(@Nonnull byte[] blockDbFormat) throws InvalidProtocolBufferException {
        HdfsProtos.BlockProto blockProto = HdfsProtos.BlockProto.parseFrom((byte[])blockDbFormat);
        return PBHelperClient.convert((HdfsProtos.BlockProto)blockProto);
    }

    public static byte[] toProtoBufBytes(@Nonnull ProvidedStorageLocation providedStorageLocation) throws IOException {
        HdfsProtos.ProvidedStorageLocationProto providedStorageLocationProto = PBHelperClient.convert((ProvidedStorageLocation)providedStorageLocation);
        ByteArrayOutputStream providedStorageLocationOutputStream = new ByteArrayOutputStream();
        providedStorageLocationProto.writeTo((OutputStream)providedStorageLocationOutputStream);
        return providedStorageLocationOutputStream.toByteArray();
    }

    public static byte[] toProtoBufBytes(@Nonnull Block block) throws IOException {
        HdfsProtos.BlockProto blockProto = PBHelperClient.convert((Block)block);
        ByteArrayOutputStream blockOutputStream = new ByteArrayOutputStream();
        blockProto.writeTo((OutputStream)blockOutputStream);
        return blockOutputStream.toByteArray();
    }

    @FunctionalInterface
    public static interface CheckedFunction2<T1, T2, R> {
        public R apply(T1 var1, T2 var2) throws IOException;
    }
}

