/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsLoader;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsViewer;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class OfflineEditsXmlLoader
extends DefaultHandler
implements OfflineEditsLoader {
    private final boolean fixTxIds;
    private final OfflineEditsVisitor visitor;
    private final InputStreamReader fileReader;
    private ParseState state;
    private XMLUtils.Stanza stanza;
    private Stack<XMLUtils.Stanza> stanzaStack;
    private FSEditLogOpCodes opCode;
    private StringBuffer cbuf;
    private long nextTxId;
    private final FSEditLogOp.OpInstanceCache opCache = new FSEditLogOp.OpInstanceCache();

    public OfflineEditsXmlLoader(OfflineEditsVisitor visitor, File inputFile, OfflineEditsViewer.Flags flags) throws FileNotFoundException {
        this.visitor = visitor;
        this.fileReader = new InputStreamReader((InputStream)new FileInputStream(inputFile), Charsets.UTF_8);
        this.fixTxIds = flags.getFixTxIds();
    }

    @Override
    public void loadEdits() throws IOException {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.setDTDHandler(null);
            xr.parse(new InputSource(this.fileReader));
            this.visitor.close(null);
        }
        catch (SAXParseException e) {
            System.out.println("XML parsing error: \nLine:    " + e.getLineNumber() + "\nURI:     " + e.getSystemId() + "\nMessage: " + e.getMessage());
            this.visitor.close(e);
            throw new IOException(e.toString());
        }
        catch (SAXException e) {
            this.visitor.close(e);
            throw new IOException(e.toString());
        }
        catch (RuntimeException e) {
            this.visitor.close(e);
            throw e;
        }
        finally {
            this.fileReader.close();
        }
    }

    @Override
    public void startDocument() {
        this.state = ParseState.EXPECT_EDITS_TAG;
        this.stanza = null;
        this.stanzaStack = new Stack();
        this.opCode = null;
        this.cbuf = new StringBuffer();
        this.nextTxId = -1L;
    }

    @Override
    public void endDocument() {
        if (this.state != ParseState.EXPECT_END) {
            throw new XMLUtils.InvalidXmlException("expecting </EDITS>");
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        switch (this.state) {
            case EXPECT_EDITS_TAG: {
                if (!name.equals("EDITS")) {
                    throw new XMLUtils.InvalidXmlException("you must put <EDITS> at the top of the XML file! Got tag " + name + " instead");
                }
                this.state = ParseState.EXPECT_VERSION;
                break;
            }
            case EXPECT_VERSION: {
                if (name.equals("EDITS_VERSION")) break;
                throw new XMLUtils.InvalidXmlException("you must put <EDITS_VERSION> at the top of the XML file! Got tag " + name + " instead");
            }
            case EXPECT_RECORD: {
                if (!name.equals("RECORD")) {
                    throw new XMLUtils.InvalidXmlException("expected a <RECORD> tag");
                }
                this.state = ParseState.EXPECT_OPCODE;
                break;
            }
            case EXPECT_OPCODE: {
                if (name.equals("OPCODE")) break;
                throw new XMLUtils.InvalidXmlException("expected an <OPCODE> tag");
            }
            case EXPECT_DATA: {
                if (!name.equals("DATA")) {
                    throw new XMLUtils.InvalidXmlException("expected a <DATA> tag");
                }
                this.stanza = new XMLUtils.Stanza();
                this.state = ParseState.HANDLE_DATA;
                break;
            }
            case HANDLE_DATA: {
                XMLUtils.Stanza parent = this.stanza;
                XMLUtils.Stanza child = new XMLUtils.Stanza();
                this.stanzaStack.push(parent);
                this.stanza = child;
                parent.addChild(name, child);
                break;
            }
            case EXPECT_END: {
                throw new XMLUtils.InvalidXmlException("not expecting anything after </EDITS>");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void endElement(String uri, String name, String qName) {
        String str = XMLUtils.unmangleXmlString(this.cbuf.toString(), false).trim();
        this.cbuf = new StringBuffer();
        switch (this.state) {
            case EXPECT_EDITS_TAG: {
                throw new XMLUtils.InvalidXmlException("expected <EDITS/>");
            }
            case EXPECT_VERSION: {
                if (!name.equals("EDITS_VERSION")) {
                    throw new XMLUtils.InvalidXmlException("expected </EDITS_VERSION>");
                }
                try {
                    int version = Integer.parseInt(str);
                    this.visitor.start(version);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.state = ParseState.EXPECT_RECORD;
                return;
            }
            case EXPECT_RECORD: {
                if (name.equals("EDITS")) {
                    this.state = ParseState.EXPECT_END;
                    return;
                }
                if (name.equals("RECORD")) return;
                throw new XMLUtils.InvalidXmlException("expected </EDITS> or </RECORD>");
            }
            case EXPECT_OPCODE: {
                if (!name.equals("OPCODE")) {
                    throw new XMLUtils.InvalidXmlException("expected </OPCODE>");
                }
                this.opCode = FSEditLogOpCodes.valueOf(str);
                this.state = ParseState.EXPECT_DATA;
                return;
            }
            case EXPECT_DATA: {
                throw new XMLUtils.InvalidXmlException("expected <DATA/>");
            }
            case HANDLE_DATA: {
                this.stanza.setValue(str);
                if (!this.stanzaStack.empty()) {
                    this.stanza = this.stanzaStack.pop();
                    return;
                }
                if (!name.equals("DATA")) {
                    throw new XMLUtils.InvalidXmlException("expected </DATA>");
                }
                this.state = ParseState.EXPECT_RECORD;
                Object op = this.opCache.get(this.opCode);
                this.opCode = null;
                try {
                    ((FSEditLogOp)op).decodeXml(this.stanza);
                    this.stanza = null;
                }
                finally {
                    if (this.stanza != null) {
                        System.err.println("fromXml error decoding opcode " + (Object)((Object)this.opCode) + "\n" + this.stanza.toString());
                        this.stanza = null;
                    }
                }
                if (this.fixTxIds) {
                    if (this.nextTxId <= 0L) {
                        this.nextTxId = ((FSEditLogOp)op).getTransactionId();
                        if (this.nextTxId <= 0L) {
                            this.nextTxId = 1L;
                        }
                    }
                    ((FSEditLogOp)op).setTransactionId(this.nextTxId);
                    ++this.nextTxId;
                }
                try {
                    this.visitor.visitOp((FSEditLogOp)op);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.state = ParseState.EXPECT_RECORD;
                return;
            }
            case EXPECT_END: {
                throw new XMLUtils.InvalidXmlException("not expecting anything after </EDITS>");
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.cbuf.append(ch, start, length);
    }

    static enum ParseState {
        EXPECT_EDITS_TAG,
        EXPECT_VERSION,
        EXPECT_RECORD,
        EXPECT_OPCODE,
        EXPECT_DATA,
        HANDLE_DATA,
        EXPECT_END;

    }
}

