/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.ObjectReplicationPolicy;
import com.azure.storage.blob.models.RehydratePriority;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface BlobPropertiesInternal {
    public OffsetDateTime getCreationTime();

    public OffsetDateTime getLastModified();

    public String getETag();

    public long getBlobSize();

    public String getContentType();

    public byte[] getContentMd5();

    public String getContentEncoding();

    public String getContentDisposition();

    public String getContentLanguage();

    public String getCacheControl();

    public Long getBlobSequenceNumber();

    public BlobType getBlobType();

    public LeaseStatusType getLeaseStatus();

    public LeaseStateType getLeaseState();

    public LeaseDurationType getLeaseDuration();

    public String getCopyId();

    public CopyStatusType getCopyStatus();

    public String getCopySource();

    public String getCopyProgress();

    public OffsetDateTime getCopyCompletionTime();

    public String getCopyStatusDescription();

    public Boolean isServerEncrypted();

    public Boolean isIncrementalCopy();

    public String getCopyDestinationSnapshot();

    public AccessTier getAccessTier();

    public Boolean isAccessTierInferred();

    public ArchiveStatus getArchiveStatus();

    public String getEncryptionKeySha256();

    public String getEncryptionScope();

    public OffsetDateTime getAccessTierChangeTime();

    public Map<String, String> getMetadata();

    public Integer getCommittedBlockCount();

    public Long getTagCount();

    public String getVersionId();

    public Boolean isCurrentVersion();

    public List<ObjectReplicationPolicy> getObjectReplicationSourcePolicies();

    public String getObjectReplicationDestinationPolicyId();

    public RehydratePriority getRehydratePriority();

    public Boolean isSealed();

    public OffsetDateTime getLastAccessedTime();

    public OffsetDateTime getExpiresOn();

    public BlobImmutabilityPolicy getImmutabilityPolicy();

    public Boolean hasLegalHold();
}

