/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.options;

import com.azure.core.http.HttpAuthorization;
import com.azure.core.http.RequestConditions;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobCopySourceTagsMode;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.util.Map;

public class BlobCopyFromUrlOptions {
    private final String copySource;
    private Map<String, String> metadata;
    private Map<String, String> tags;
    private AccessTier tier;
    private RequestConditions sourceRequestConditions;
    private BlobRequestConditions destinationRequestConditions;
    private HttpAuthorization sourceAuthorization;
    private BlobImmutabilityPolicy immutabilityPolicy;
    private Boolean legalHold;
    private BlobCopySourceTagsMode copySourceTags;

    public BlobCopyFromUrlOptions(String copySource) {
        StorageImplUtils.assertNotNull((String)"copySource", (Object)copySource);
        this.copySource = copySource;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlobCopyFromUrlOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public BlobCopyFromUrlOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AccessTier getTier() {
        return this.tier;
    }

    public BlobCopyFromUrlOptions setTier(AccessTier tier) {
        this.tier = tier;
        return this;
    }

    public RequestConditions getSourceRequestConditions() {
        return this.sourceRequestConditions;
    }

    public BlobCopyFromUrlOptions setSourceRequestConditions(RequestConditions sourceRequestConditions) {
        this.sourceRequestConditions = sourceRequestConditions;
        return this;
    }

    public BlobRequestConditions getDestinationRequestConditions() {
        return this.destinationRequestConditions;
    }

    public BlobCopyFromUrlOptions setDestinationRequestConditions(BlobRequestConditions destinationRequestConditions) {
        this.destinationRequestConditions = destinationRequestConditions;
        return this;
    }

    public HttpAuthorization getSourceAuthorization() {
        return this.sourceAuthorization;
    }

    public BlobCopyFromUrlOptions setSourceAuthorization(HttpAuthorization sourceAuthorization) {
        this.sourceAuthorization = sourceAuthorization;
        return this;
    }

    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        return this.immutabilityPolicy;
    }

    public BlobCopyFromUrlOptions setImmutabilityPolicy(BlobImmutabilityPolicy immutabilityPolicy) {
        this.immutabilityPolicy = immutabilityPolicy;
        return this;
    }

    public Boolean hasLegalHold() {
        return this.legalHold;
    }

    public BlobCopyFromUrlOptions setLegalHold(Boolean legalHold) {
        this.legalHold = legalHold;
        return this;
    }

    public BlobCopySourceTagsMode getCopySourceTagsMode() {
        return this.copySourceTags;
    }

    public BlobCopyFromUrlOptions setCopySourceTagsMode(BlobCopySourceTagsMode copySourceTags) {
        this.copySourceTags = copySourceTags;
        return this;
    }
}

