/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.xml.dtdvalidator;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlParserFactoryProducer;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.workflow.actions.xml.dtdvalidator.DtdValidator;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DtdValidatorUtil {
    private static final Class<?> PKG = DtdValidator.class;
    private String xmlfilename;
    private String xsdfilename;
    private boolean interndtd;
    private String errormessage;
    private int errorscount;
    private ILogChannel log;

    public DtdValidatorUtil(ILogChannel log) {
        this.log = log;
        this.xmlfilename = null;
        this.xsdfilename = null;
        this.interndtd = false;
        this.errormessage = null;
        this.errorscount = 0;
    }

    public void setXMLFilename(String xmlfilename) {
        this.xmlfilename = xmlfilename;
    }

    public String getXMLFilename() {
        return this.xmlfilename;
    }

    public void setDTDFilename(String xsdfilename) {
        this.xsdfilename = xsdfilename;
    }

    public String getDTDFilename() {
        return this.xsdfilename;
    }

    public void setInternDTD(boolean value) {
        this.interndtd = value;
    }

    public boolean isInternDTD() {
        return this.interndtd;
    }

    private void setErrorMessage(String value) {
        this.errormessage = value;
    }

    public String getErrorMessage() {
        return this.errormessage;
    }

    public int getNrErrors() {
        return this.errorscount;
    }

    private void setNrErrors(int value) {
        this.errorscount = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        boolean isValid;
        block39: {
            isValid = false;
            FileObject xmlFileObject = null;
            FileObject dtdFileObject = null;
            try {
                if (this.xmlfilename != null && (this.getDTDFilename() != null && !this.isInternDTD() || this.isInternDTD())) {
                    xmlFileObject = HopVfs.getFileObject((String)this.getXMLFilename());
                    if (xmlFileObject.exists()) {
                        URL xmlFile = new File(HopVfs.getFilename((FileObject)xmlFileObject)).toURI().toURL();
                        StringBuffer xmlStringbuffer = new StringBuffer("");
                        try (InputStreamReader is = new InputStreamReader(xmlFile.openStream());
                             BufferedReader xmlBufferedReader = new BufferedReader(is);){
                            int lenXML;
                            char[] buffertXML = new char[1024];
                            while ((lenXML = xmlBufferedReader.read(buffertXML)) != -1) {
                                xmlStringbuffer.append(buffertXML, 0, lenXML);
                            }
                        }
                        DocumentBuilderFactory docBuilderFactory = XmlParserFactoryProducer.createSecureDocBuilderFactory();
                        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                        docBuilderFactory.setValidating(false);
                        ByteArrayInputStream ba = new ByteArrayInputStream(xmlStringbuffer.toString().getBytes(StandardCharsets.UTF_8));
                        Document xmlDocDTD = docBuilder.parse(ba);
                        if (ba != null) {
                            ba.close();
                        }
                        String encoding = xmlDocDTD.getXmlEncoding() == null ? "UTF-8" : xmlDocDTD.getXmlEncoding();
                        int xmlStartDTD = xmlStringbuffer.indexOf("<!DOCTYPE");
                        if (this.isInternDTD()) {
                            if (xmlStartDTD != -1) {
                                this.log.logBasic(BaseMessages.getString(PKG, (String)"ActionDTDValidator.ERRORDTDFound.Label", (String[])new String[]{this.getXMLFilename()}));
                            } else {
                                this.setErrorMessage(BaseMessages.getString(PKG, (String)"ActionDTDValidator.ERRORDTDNotFound.Label", (String[])new String[]{this.getXMLFilename()}));
                            }
                        } else {
                            dtdFileObject = HopVfs.getFileObject((String)this.getDTDFilename());
                            if (dtdFileObject.exists()) {
                                if (xmlStartDTD != -1) {
                                    int endDTD = xmlStringbuffer.indexOf(">", xmlStartDTD);
                                    xmlStringbuffer.replace(xmlStartDTD, endDTD + 1, "");
                                }
                                String xmlRootnodeDTD = xmlDocDTD.getDocumentElement().getNodeName();
                                String refDTD = "<?xml version='" + xmlDocDTD.getXmlVersion() + "' encoding='" + encoding + "'?>\n<!DOCTYPE " + xmlRootnodeDTD + " SYSTEM '" + HopVfs.getFilename((FileObject)dtdFileObject) + "'>\n";
                                int xmloffsetDTD = xmlStringbuffer.indexOf("<" + xmlRootnodeDTD);
                                xmlStringbuffer.replace(0, xmloffsetDTD, refDTD);
                            } else {
                                this.log.logError(BaseMessages.getString(PKG, (String)"ActionDTDValidator.ERRORDTDFileNotExists.Subject", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionDTDValidator.ERRORDTDFileNotExists.Msg", (String[])new String[]{this.getDTDFilename()})});
                            }
                        }
                        if (!(this.isInternDTD() && xmlStartDTD == -1 || !this.isInternDTD() && !dtdFileObject.exists())) {
                            MyErrorHandler error = new MyErrorHandler();
                            docBuilderFactory.setValidating(true);
                            docBuilder = docBuilderFactory.newDocumentBuilder();
                            docBuilder.setErrorHandler(error);
                            ba = new ByteArrayInputStream(xmlStringbuffer.toString().getBytes(encoding));
                            xmlDocDTD = docBuilder.parse(ba);
                            if (error.errorMessage == null) {
                                this.log.logBasic(BaseMessages.getString(PKG, (String)"ActionDTDValidator.DTDValidatorOK.Subject", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionDTDValidator.DTDValidatorOK.Label", (String[])new String[]{this.getXMLFilename()})});
                                isValid = true;
                            } else {
                                this.setNrErrors(error.nrErrors);
                                this.setErrorMessage(BaseMessages.getString(PKG, (String)"ActionDTDValidator.DTDValidatorKO", (Object[])new Object[]{this.getXMLFilename(), error.nrErrors, error.errorMessage}));
                            }
                        }
                        break block39;
                    }
                    if (!xmlFileObject.exists()) {
                        this.setErrorMessage(BaseMessages.getString(PKG, (String)"ActionDTDValidator.FileDoesNotExist.Label", (String[])new String[]{this.getXMLFilename()}));
                    }
                    break block39;
                }
                this.setErrorMessage(BaseMessages.getString(PKG, (String)"ActionDTDValidator.AllFilesNotNull.Label", (String[])new String[0]));
            }
            catch (Exception e) {
                this.setErrorMessage(BaseMessages.getString(PKG, (String)"ActionDTDValidator.ErrorDTDValidator.Label", (String[])new String[]{this.getXMLFilename(), this.getDTDFilename(), e.getMessage()}));
            }
            finally {
                try {
                    if (xmlFileObject != null) {
                        xmlFileObject.close();
                    }
                    if (dtdFileObject != null) {
                        dtdFileObject.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return isValid;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        String errorMessage = null;
        int error = -1;
        int nrErrors = 0;

        private MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.error = 0;
            this.allErrors(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.error = 1;
            this.allErrors(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.error = 2;
            this.allErrors(e);
        }

        private void allErrors(SAXParseException e) {
            ++this.nrErrors;
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            this.errorMessage = this.errorMessage + Const.CR + Const.CR + "Error Nr." + this.nrErrors + " (";
            switch (this.error) {
                case 0: {
                    this.errorMessage = this.errorMessage + "Warning";
                    break;
                }
                case 1: {
                    this.errorMessage = this.errorMessage + "Error";
                    break;
                }
                case 2: {
                    this.errorMessage = this.errorMessage + "FatalError";
                    break;
                }
            }
            this.errorMessage = this.errorMessage + ")" + Const.CR + "              Public ID: " + e.getPublicId() + Const.CR + "              System ID: " + e.getSystemId() + Const.CR + "              Line number: " + e.getLineNumber() + Const.CR + "              Column number: " + e.getColumnNumber() + Const.CR + "              Message: " + e.getMessage();
        }
    }
}

