/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.injection.bean;

import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.InjectionTypeConverter;
import org.apache.hop.core.injection.bean.BeanInjectionInfo;
import org.apache.hop.core.injection.bean.BeanLevelInfo;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;

public class BeanInjector<Meta> {
    private final BeanInjectionInfo<Meta> info;
    private final IHopMetadataProvider metadataProvider;

    public BeanInjector(BeanInjectionInfo<Meta> info, IHopMetadataProvider metadataProvider) {
        this.info = info;
        this.metadataProvider = metadataProvider;
    }

    public Object getObject(Object root, String propName) throws Exception {
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new RuntimeException("Property not found");
        }
        BeanLevelInfo beanLevelInfo = prop.path.get(1);
        return beanLevelInfo.field.get(root);
    }

    public Object getPropVal(Object root, String propName) {
        LinkedList beanInfos = Lists.newLinkedList(Optional.ofNullable(this.info.getProperties().get((Object)propName)).orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getPropVal$0(java.lang.String ), ()Ljava/lang/IllegalArgumentException;)((String)propName)).path);
        beanInfos.remove();
        return this.getPropVal(root, propName, beanInfos);
    }

    private Object getPropVal(Object obj, String propName, Queue<BeanLevelInfo> beanInfos) {
        BeanLevelInfo info = beanInfos.remove();
        if (beanInfos.isEmpty()) {
            return this.getObjFromBeanInfo(obj, info);
        }
        obj = this.getObjFromBeanInfo(obj, info);
        switch (info.dim) {
            case LIST: {
                return ((List)Objects.requireNonNull(obj)).stream().map(o -> this.getPropVal(o, propName, Lists.newLinkedList((Iterable)beanInfos))).collect(Collectors.toList());
            }
            case ARRAY: {
                return Arrays.stream((Object[])Objects.requireNonNull(obj)).map(o -> this.getPropVal(o, propName, Lists.newLinkedList((Iterable)beanInfos))).toArray(Object[]::new);
            }
            case NONE: {
                return this.getPropVal(obj, propName, beanInfos);
            }
        }
        throw new IllegalStateException("Unexpected value of BeanLevelInfo.dim " + String.valueOf((Object)info.dim));
    }

    private Object getObjFromBeanInfo(Object obj, BeanLevelInfo beanLevelInfo) {
        try {
            return beanLevelInfo.field == null ? null : beanLevelInfo.field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getProperty(Object root, String propName) throws Exception {
        ArrayList extractedIndexes = new ArrayList();
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new RuntimeException("Property not found");
        }
        Object obj = root;
        int arrIndex = 0;
        block4: for (int i = 1; i < prop.path.size(); ++i) {
            BeanLevelInfo s = prop.path.get(i);
            if ((obj = s.field.get(obj)) == null) {
                return null;
            }
            switch (s.dim) {
                case ARRAY: {
                    int indexArray = (Integer)extractedIndexes.get(arrIndex++);
                    if (Array.getLength(obj) <= indexArray) {
                        return null;
                    }
                    if ((obj = Array.get(obj, indexArray)) != null) continue block4;
                    return null;
                }
                case LIST: {
                    int indexList = (Integer)extractedIndexes.get(arrIndex++);
                    List list = (List)obj;
                    if (list.size() <= indexList) {
                        return null;
                    }
                    obj = list.get(indexList);
                    if (obj != null) continue block4;
                    return null;
                }
            }
        }
        return obj;
    }

    public boolean hasProperty(Object root, String propName) {
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        return prop != null;
    }

    public void setProperty(Object root, String propName, List<RowMetaAndData> data, String dataN) throws HopException {
        String dataValue;
        String dataName;
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new HopException("Property '" + propName + "' not found for injection to " + String.valueOf(root.getClass()));
        }
        if (data != null) {
            dataName = dataN;
            dataValue = null;
        } else {
            dataName = null;
            dataValue = dataN;
        }
        if (prop.pathArraysCount == 0) {
            try {
                this.setProperty(root, prop, 0, data != null ? data.get(0) : null, dataName, dataValue);
            }
            catch (Exception ex) {
                throw new HopException("Error inject property '" + propName + "' into " + String.valueOf(root.getClass()), (Throwable)ex);
            }
        } else if (prop.pathArraysCount == 1) {
            try {
                boolean found;
                if (data != null) {
                    for (int i = 0; i < data.size(); ++i) {
                        this.setProperty(root, prop, i, data.get(i), dataName, dataValue);
                    }
                }
                int i = 0;
                while (found = this.setProperty(root, prop, i, null, null, dataValue)) {
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new HopException("Error inject property '" + propName + "' into " + String.valueOf(root.getClass()), (Throwable)ex);
            }
        } else if (prop.pathArraysCount > 1) {
            throw new HopException("Property '" + propName + "' has more than one array in path for injection to " + String.valueOf(root.getClass()));
        }
    }

    private boolean setProperty(Object root, BeanInjectionInfo.Property prop, int index, RowMetaAndData data, String dataName, String dataValue) throws Exception {
        boolean returnValue = true;
        Object obj = root;
        for (int i = 1; i < prop.path.size(); ++i) {
            Object value;
            List<Object> existList;
            Object existArray;
            BeanLevelInfo s = prop.path.get(i);
            if (i < prop.path.size() - 1) {
                switch (s.dim) {
                    case ARRAY: {
                        Object object = existArray = data != null ? this.extendArray(s, obj, index + 1) : this.checkArray(s, obj, index);
                        if (existArray == null) {
                            return false;
                        }
                        Object next = Array.get(existArray, index);
                        if (next == null) {
                            next = this.createObject(s.leafClass, root);
                            Array.set(existArray, index, next);
                        }
                        obj = next;
                        break;
                    }
                    case LIST: {
                        List<Object> list = existList = data != null ? this.extendList(s, obj, index + 1) : this.checkList(s, obj, index);
                        if (existList == null) {
                            return false;
                        }
                        Object next = existList.get(index);
                        if (next == null) {
                            if (i + 1 < prop.path.size() && String.class.equals(prop.path.get((int)(i + 1)).leafClass) && prop.path.get((int)(i + 1)).stringList) {
                                next = data.getString(dataName, null);
                                ++i;
                            } else {
                                next = this.createObject(s.leafClass, root);
                            }
                            existList.set(index, next);
                        }
                        obj = next;
                        break;
                    }
                    case NONE: {
                        Object next;
                        if (s.field != null) {
                            next = s.field.get(obj);
                            if (next == null) {
                                next = this.createObject(s.leafClass, root);
                                s.field.set(obj, next);
                            }
                            obj = next;
                            break;
                        }
                        if (s.getter != null) {
                            next = s.getter.invoke(obj, new Object[0]);
                            if (next == null) {
                                if (s.setter == null) {
                                    throw new HopException("No setter defined for " + String.valueOf(root.getClass()));
                                }
                                next = s.leafClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                s.setter.invoke(obj, next);
                            }
                            obj = next;
                            break;
                        }
                        throw new HopException("No field or getter defined for " + String.valueOf(root.getClass()));
                    }
                }
                continue;
            }
            if (!s.convertEmpty && (data != null ? data.isEmptyValue(dataName) : dataValue == null)) {
                return true;
            }
            if (s.setter != null) {
                if (data != null) {
                    if (s.storeWithName) {
                        String name = data.getString(dataName, null);
                        IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(s.leafClass);
                        value = serializer.load(name);
                    } else if (s.stringObjectConverter != null) {
                        String string = data.getString(dataName, null);
                        value = s.stringObjectConverter.getObject(string);
                    } else {
                        value = data.getAsJavaType(dataName, s.leafClass, s.converter);
                    }
                } else {
                    value = RowMetaAndData.getStringAsJavaType((String)dataValue, s.leafClass, (InjectionTypeConverter)s.converter);
                }
                s.setter.invoke(obj, value);
                continue;
            }
            if (s.field != null) {
                value = data != null ? data.getAsJavaType(dataName, s.leafClass, s.converter) : RowMetaAndData.getStringAsJavaType((String)dataValue, s.leafClass, (InjectionTypeConverter)s.converter);
                switch (s.dim) {
                    case ARRAY: {
                        Object object = existArray = data != null ? this.extendArray(s, obj, index + 1) : this.checkArray(s, obj, index);
                        if (existArray == null) {
                            existArray = Array.newInstance(s.leafClass, index + 1);
                            s.field.set(obj, existArray);
                            returnValue = false;
                        }
                        Array.set(existArray, index, value);
                        break;
                    }
                    case LIST: {
                        List<Object> list = existList = data != null ? this.extendList(s, obj, index + 1) : this.checkList(s, obj, index);
                        if (existList == null) {
                            existList = new ArrayList<Object>();
                            existList.add(new Object());
                            s.field.set(obj, existList);
                            returnValue = false;
                        }
                        existList.set(index, value);
                        break;
                    }
                    case NONE: {
                        s.field.set(obj, value);
                    }
                }
                continue;
            }
            if (s.stringList) continue;
            throw new HopException("No field or setter defined for " + String.valueOf(s.leafClass));
        }
        return returnValue;
    }

    private Object createObject(Class<?> clazz, Object root) throws HopException {
        try {
            for (Constructor<?> c : clazz.getConstructors()) {
                if (c.getParameterTypes().length == 0) {
                    return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].isAssignableFrom(this.info.clazz)) continue;
                return c.newInstance(root);
            }
        }
        catch (Exception ex) {
            throw new HopException("Can't create object " + String.valueOf(clazz), (Throwable)ex);
        }
        throw new HopException("Constructor not found for " + String.valueOf(clazz));
    }

    private Object extendArray(BeanLevelInfo s, Object obj, int newSize) throws Exception {
        int existSize;
        Object existArray = s.field.get(obj);
        if (existArray == null) {
            existArray = Array.newInstance(s.leafClass, newSize);
            s.field.set(obj, existArray);
        }
        if ((existSize = Array.getLength(existArray)) < newSize) {
            Object newSized = Array.newInstance(s.leafClass, newSize);
            System.arraycopy(existArray, 0, newSized, 0, existSize);
            existArray = newSized;
            s.field.set(obj, existArray);
        }
        return existArray;
    }

    private Object checkArray(BeanLevelInfo s, Object obj, int index) throws Exception {
        Object existArray = s.field.get(obj);
        if (existArray == null) {
            return null;
        }
        int existSize = Array.getLength(existArray);
        return index < existSize ? existArray : null;
    }

    private List<Object> extendList(BeanLevelInfo s, Object obj, int newSize) throws Exception {
        ArrayList<Object> existList = (ArrayList<Object>)s.field.get(obj);
        if (existList == null) {
            existList = new ArrayList<Object>();
            s.field.set(obj, existList);
        }
        while (existList.size() < newSize) {
            existList.add(null);
        }
        return existList;
    }

    private List<Object> checkList(BeanLevelInfo s, Object obj, int index) throws Exception {
        List existList = (List)s.field.get(obj);
        if (existList == null) {
            return null;
        }
        if (existList.isEmpty()) {
            return this.extendList(s, obj, 1);
        }
        return index < existList.size() ? existList : null;
    }

    public void runPostInjectionProcessing(Object object) {
        Method[] methods;
        for (Method m : methods = object.getClass().getDeclaredMethods()) {
            AfterInjection annotationAfterInjection = m.getAnnotation(AfterInjection.class);
            if (annotationAfterInjection == null) continue;
            if (m.isSynthetic() || Modifier.isStatic(m.getModifiers())) {
                throw new RuntimeException("Wrong modifier for annotated method " + String.valueOf(m));
            }
            try {
                m.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not invoke after injection method " + String.valueOf(m), e);
            }
        }
    }

    private static /* synthetic */ IllegalArgumentException lambda$getPropVal$0(String propName) {
        return new IllegalArgumentException("Property not found: " + propName);
    }
}

