/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Float4
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 4;
    private static final float defaultValue = 0.0f;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return 4;
    }

    @Override
    public Object getDefaultValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public int getInstanceType() {
        return 5;
    }

    @Override
    public Class getJavaType() {
        return Float.class;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[4];
        BinaryConverter.floatToByteArray(((Float)javaValue).floatValue(), as400Value, 0);
        return as400Value;
    }

    public byte[] toBytes(float floatValue) {
        byte[] as400Value = new byte[4];
        BinaryConverter.floatToByteArray(floatValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        BinaryConverter.floatToByteArray(((Float)javaValue).floatValue(), as400Value, 0);
        return 4;
    }

    public int toBytes(float floatValue, byte[] as400Value) {
        BinaryConverter.floatToByteArray(floatValue, as400Value, 0);
        return 4;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        BinaryConverter.floatToByteArray(((Float)javaValue).floatValue(), as400Value, offset);
        return 4;
    }

    public int toBytes(float floatValue, byte[] as400Value, int offset) {
        BinaryConverter.floatToByteArray(floatValue, as400Value, offset);
        return 4;
    }

    public float toFloat(byte[] as400Value) {
        return BinaryConverter.byteArrayToFloat(as400Value, 0);
    }

    public float toFloat(byte[] as400Value, int offset) {
        return BinaryConverter.byteArrayToFloat(as400Value, offset);
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return Float.valueOf(BinaryConverter.byteArrayToFloat(as400Value, 0));
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        return Float.valueOf(BinaryConverter.byteArrayToFloat(as400Value, offset));
    }
}

