/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionEventSupport;
import com.ibm.as400.access.AS400JDBCConnectionHandle;
import com.ibm.as400.access.JDConnectionPoolKey;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.PoolItemProperties;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class AS400JDBCPooledConnection
implements PooledConnection {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private SoftReference handle_;
    private PoolItemProperties properties_;
    private AS400JDBCConnectionEventSupport eventManager_;
    private int hashCode_;
    JDConnectionPoolKey poolKey_;
    long timeWhenCreated_;
    long timeWhenPoolStatusLastModified_;
    boolean fatalConnectionErrorOccurred_;
    private boolean defaultAutoCommit_;
    private int defaultTransactionIsolation_;
    private int defaultHoldability_;
    private String defaultSchema_;
    private boolean defaultReadOnly_;

    AS400JDBCPooledConnection(Connection connection) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection_ = (AS400JDBCConnection)connection;
        this.defaultAutoCommit_ = this.connection_.getAutoCommit();
        this.defaultTransactionIsolation_ = this.connection_.getTransactionIsolation();
        this.defaultHoldability_ = this.connection_.getInternalHoldability();
        this.defaultSchema_ = this.connection_.getSchema();
        if ("*LIBL".equals(this.defaultSchema_)) {
            this.defaultSchema_ = "DEFAULT";
        }
        this.defaultReadOnly_ = this.connection_.getReadOnly();
        this.properties_ = new PoolItemProperties();
        this.eventManager_ = new AS400JDBCConnectionEventSupport();
        this.hashCode_ = this.connection_.hashCode();
        this.timeWhenCreated_ = System.currentTimeMillis();
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "A new AS400JDBCPooledConnection was created");
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.eventManager_.addConnectionEventListener(listener);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.connection_.isClosed()) {
            return;
        }
        this.connection_.close();
        this.properties_.clear();
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "close() was called on this AS400JDBCPooledConnection");
        }
    }

    public void closeAll() throws SQLException {
        JDError.throwSQLException("IM001");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            AS400JDBCPooledConnection pc = (AS400JDBCPooledConnection)obj;
            return this.connection_.equals(pc.connection_);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int hashCode() {
        return this.hashCode_;
    }

    void fireConnectionCloseEvent(ConnectionEvent event) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "fireConnectionCloseEvent(" + event + ")");
        }
        this.returned();
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "fireConnectionCloseEvent() calling eventManager_.fireCloseEvent");
        }
        this.eventManager_.fireCloseEvent(event);
    }

    void fireConnectionErrorEvent(ConnectionEvent event) {
        this.eventManager_.fireErrorEvent(event);
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "AS400JDBCPooledConnection.getConnection() was called");
        }
        return this.getConnectionHandle();
    }

    final synchronized AS400JDBCConnectionHandle getConnectionHandle() throws SQLException {
        if (this.connection_.isClosed()) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "This AS400JDBCPooledConnection is invalid because connection is closed.");
            }
            JDError.throwSQLException((Object)this, "08003");
        }
        if (this.isInUse()) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "This AS400JDBCPooledConnection is already in use.");
            }
            JDError.throwSQLException((Object)this, "08001");
        }
        this.setInUse(true);
        AS400JDBCConnectionHandle handle = new AS400JDBCConnectionHandle(this, this.connection_);
        this.handle_ = new SoftReference<AS400JDBCConnectionHandle>(handle);
        return handle;
    }

    final JDConnectionPoolKey getPoolKey() {
        return this.poolKey_;
    }

    AS400JDBCConnection getInternalConnection() {
        return this.connection_;
    }

    public long getInactivityTime() {
        return this.properties_.getInactivityTime();
    }

    public long getInUseTime() {
        return this.properties_.getInUseTime();
    }

    public long getLifeSpan() {
        return this.properties_.getLifeSpan();
    }

    public int getUseCount() {
        return this.properties_.getUseCount();
    }

    boolean isConnected() throws SQLException {
        return this.connection_.getAS400().isConnected(4);
    }

    boolean isConnectionAlive() throws SQLException {
        return this.connection_.getAS400().isConnectionAlive(4);
    }

    public boolean isInUse() {
        return this.properties_.isInUse();
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventManager_.removeConnectionEventListener(listener);
    }

    synchronized void returned() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "returned() This AS400JDBCPooledConnection is being returned.");
        }
        this.setInUse(false);
        try {
            this.connection_.clearWarnings();
            this.connection_.setAutoCommit(this.defaultAutoCommit_);
            this.connection_.setTransactionIsolation(this.defaultTransactionIsolation_);
            this.connection_.setHoldability(this.defaultHoldability_);
            try {
                this.connection_.setSchema(this.defaultSchema_);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection_.setReadOnly(this.defaultReadOnly_);
            if (this.handle_ != null) {
                AS400JDBCConnectionHandle handle = (AS400JDBCConnectionHandle)this.handle_.get();
                if (handle != null) {
                    handle.invalidate();
                }
                this.handle_ = null;
            }
        }
        catch (SQLException e) {
            JDTrace.logException(this, "Exception while resetting properties of returned connection.", e);
        }
    }

    synchronized void setInUse(boolean inUse) {
        this.properties_.setInUse(inUse);
    }

    final void setPoolKey(JDConnectionPoolKey key) {
        this.poolKey_ = key;
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "AS400JDBCPooledConnection.addStatementEventListener is called, but is N/A.");
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "AS400JDBCPooledConnection.removeStatementEventListener is called, but is N/A.");
        }
    }
}

