/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400EndJobDS;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class AS400NoThreadServer
extends AS400Server {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private AS400ImplRemote system_;
    private Hashtable replyStreams_;
    private Hashtable instanceReplyStreams_ = new Hashtable();
    private DataStream exchangeAttrReply_ = null;
    private Vector replyList_ = new Vector(5);
    private Vector discardList_ = new Vector();
    private AtomicInteger lastCorrelationId_ = new AtomicInteger();
    private final Lock lock_ = new ReentrantLock();
    private boolean closed_ = false;

    AS400NoThreadServer(AS400ImplRemote system, int service, SocketContainer socket, String jobString) throws IOException {
        this.system_ = system;
        this.service_ = service;
        this.jobString_ = jobString;
        this.socket_ = socket;
        this.connectionID_ = this.socket_.hashCode();
        this.inStream_ = socket.getInputStream();
        this.outStream_ = socket.getOutputStream();
        this.replyStreams_ = AS400Server.replyStreamsHashTables[service];
    }

    AS400NoThreadServer(AS400ImplRemote system, int service) throws IOException {
        this.system_ = system;
        this.service_ = service;
        this.replyStreams_ = AS400Server.replyStreamsHashTables[service];
    }

    void setSocket(SocketContainer socket) throws IOException {
        try {
            this.lock_.lock();
            if (this.socket_ != null) {
                try {
                    this.socket_.close();
                }
                catch (IOException e) {
                    Trace.log(2, "Socket close of previous socket failed.", (Throwable)e);
                }
            }
            this.socket_ = socket;
            this.connectionID_ = this.socket_.hashCode();
            this.inStream_ = socket.getInputStream();
            this.outStream_ = socket.getOutputStream();
            this.closed_ = false;
        }
        finally {
            this.lock_.unlock();
        }
    }

    @Override
    boolean isConnected() {
        return !this.closed_;
    }

    @Override
    public DataStream getExchangeAttrReply() {
        return this.exchangeAttrReply_;
    }

    @Override
    public DataStream sendExchangeAttrRequest(DataStream req) throws IOException {
        if (this.exchangeAttrReply_ == null) {
            this.exchangeAttrReply_ = this.sendAndReceive(req);
        }
        return this.exchangeAttrReply_;
    }

    @Override
    void addInstanceReplyStream(DataStream replyStream) {
        this.instanceReplyStreams_.put(replyStream, replyStream);
    }

    @Override
    void clearInstanceReplyStreams() {
        this.instanceReplyStreams_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStream sendAndReceive(DataStream requestStream) throws IOException {
        try {
            this.lock_.lock();
            if (Trace.traceOn_) {
                Trace.log(1, "send and receive(): ...");
            }
            int correlationID = this.send(requestStream);
            DataStream dataStream = this.receive(correlationID);
            return dataStream;
        }
        finally {
            this.lock_.unlock();
        }
    }

    @Override
    void sendAndDiscardReply(DataStream requestStream) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and discard(): ...");
        }
        int correlationID = this.send(requestStream);
        this.discardList_.addElement(correlationID);
    }

    @Override
    final void sendAndDiscardReply(DataStream requestStream, int correlationID) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and discard(): ...");
        }
        this.send(requestStream, correlationID);
        this.discardList_.addElement(correlationID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int send(DataStream requestStream) throws IOException {
        try {
            this.lock_.lock();
            if (Trace.traceOn_) {
                Trace.log(1, "send(): send request to job " + this.getJobString());
                requestStream.setConnectionID(this.connectionID_);
            }
            int correlationID = this.newCorrelationId();
            requestStream.setCorrelation(correlationID);
            requestStream.write(this.outStream_);
            int n = correlationID;
            return n;
        }
        finally {
            this.lock_.unlock();
        }
    }

    @Override
    int newCorrelationId() {
        return this.lastCorrelationId_.incrementAndGet();
    }

    @Override
    void send(DataStream requestStream, int correlationId) throws IOException {
        try {
            this.lock_.lock();
            if (Trace.traceOn_) {
                Trace.log(1, "send(): send request to job " + this.getJobString());
                requestStream.setConnectionID(this.connectionID_);
            }
            requestStream.setCorrelation(correlationId);
            requestStream.write(this.outStream_);
        }
        finally {
            this.lock_.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DataStream receive(int correlationId) throws IOException {
        try {
            this.lock_.lock();
            if (Trace.traceOn_) {
                Trace.log(1, "AS400Server receive from job " + this.getJobString());
            }
            DataStream reply = null;
            do {
                if (!this.replyList_.isEmpty()) {
                    for (int i = 0; i < this.replyList_.size(); ++i) {
                        DataStream nextReply = (DataStream)this.replyList_.elementAt(i);
                        if (nextReply.getCorrelation() != correlationId) continue;
                        this.replyList_.removeElementAt(i);
                        reply = nextReply;
                        break;
                    }
                }
                if (reply == null) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "run(): wait for reply...");
                    }
                    DataStream ds = null;
                    ds = this.service_ != 5 ? ClientAccessDataStream.construct(this.inStream_, this.instanceReplyStreams_, this.replyStreams_, this.system_, this.connectionID_) : DDMDataStream.construct(this.inStream_, this.replyStreams_, this.system_, this.connectionID_);
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "run(): reply received..." + ds.toString());
                    }
                    boolean keepDataStream = true;
                    int correlation = ds.getCorrelation();
                    for (int i = 0; i < this.discardList_.size(); ++i) {
                        if ((Integer)this.discardList_.elementAt(i) != correlation) continue;
                        this.discardList_.removeElementAt(i);
                        keepDataStream = false;
                        break;
                    }
                    if (!keepDataStream) continue;
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "adding reply...", correlation);
                    }
                    this.replyList_.addElement(ds);
                    continue;
                }
                if (!Trace.traceOn_) continue;
                Trace.log(1, "received(): valid reply received...", correlationId);
            } while (reply == null);
            DataStream dataStream = reply;
            return dataStream;
        }
        finally {
            this.lock_.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void forceDisconnect() {
        int count = this.removeReference();
        if (this.service_ == 8 && count > 0) {
            Trace.log(1, "Force disconnect for hostcnn service ignored, reference count: " + count);
            return;
        }
        try {
            this.lock_.lock();
            if (this.closed_) {
                return;
            }
            this.closed_ = true;
            if (this.socket_ == null) {
                return;
            }
            if (this.service_ == 4 || this.service_ == 2 || this.service_ == 6 || this.service_ == 7 || this.service_ == 8) {
                AS400EndJobDS endjob = new AS400EndJobDS(AS400Server.getServerId(this.service_));
                try {
                    endjob.write(this.outStream_);
                }
                catch (Exception e) {
                    Trace.log(2, "Send end job data stream failed.", (Throwable)e);
                }
            }
            try {
                this.socket_.close();
            }
            catch (IOException e) {
                Trace.log(2, "Socket close failed.", (Throwable)e);
            }
        }
        finally {
            this.lock_.unlock();
        }
    }

    @Override
    public void setExchangeAttrReply(DataStream xChgAttrReply) {
        this.exchangeAttrReply_ = xChgAttrReply;
    }

    void lock() {
        this.lock_.lock();
    }

    void unlock() {
        this.lock_.unlock();
    }

    void markClosed() {
        this.closed_ = true;
    }
}

