/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

public class AS400Text
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int length_;
    private int ccsid_ = 65535;
    private transient String encoding_ = null;
    private AS400 system_;
    transient ConverterImpl tableImpl_;
    private static final String defaultValue_ = "";
    private byte[] padding_ = null;

    public AS400Text(int length) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        this.length_ = length;
    }

    public AS400Text(int length, int ccsid) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (ccsid < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid (" + ccsid + ")", 2);
        }
        this.length_ = length;
        this.ccsid_ = ccsid;
    }

    public AS400Text(int length, String encoding) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (encoding == null) {
            Trace.log(2, "Parameter 'encoding' is null.");
            throw new NullPointerException("encoding");
        }
        this.length_ = length;
        this.encoding_ = encoding;
    }

    public AS400Text(int length, AS400 system) {
        this(length, 65535, system);
    }

    public AS400Text(int length, int ccsid, AS400 system) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (ccsid < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid (" + ccsid + ")", 2);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.length_ = length;
        this.ccsid_ = ccsid;
        this.system_ = system;
    }

    AS400Text(int length, int ccsid, AS400Impl system) {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 2);
        }
        if (ccsid < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid (" + ccsid + ")", 2);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.length_ = length;
        this.ccsid_ = ccsid;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected CloneNotSupportedException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }

    @Override
    public int getByteLength() {
        return this.length_;
    }

    public int getCcsid() {
        if (this.ccsid_ == 65535) {
            this.setTable();
        }
        return this.ccsid_;
    }

    ConverterImpl getConverter() {
        this.setTable();
        return this.tableImpl_;
    }

    @Override
    public Object getDefaultValue() {
        return defaultValue_;
    }

    public String getEncoding() {
        if (this.encoding_ == null) {
            this.setTable();
        }
        return this.encoding_;
    }

    @Override
    public int getInstanceType() {
        return 9;
    }

    @Override
    public Class getJavaType() {
        return String.class;
    }

    void setConverter(AS400 system) {
        this.system_ = system;
        this.setTable();
    }

    void setConverter(ConverterImpl converter) {
        this.tableImpl_ = converter;
        this.ccsid_ = this.tableImpl_.getCcsid();
    }

    private void setTable() {
        if (this.tableImpl_ == null) {
            if (Trace.traceOn_) {
                Trace.log(5, "AS400Text object initializing, encoding: " + this.encoding_ + ", CCSID: " + this.ccsid_ + ", system: " + this.system_);
            }
            if (this.encoding_ != null) {
                try {
                    Converter table = new Converter(this.encoding_);
                    this.ccsid_ = table.getCcsid();
                    this.tableImpl_ = table.impl;
                }
                catch (UnsupportedEncodingException e) {
                    throw new ExtendedIllegalArgumentException("encoding (" + this.encoding_ + ")", 2);
                }
            }
            try {
                if (this.system_ == null) {
                    Converter table;
                    if (this.ccsid_ == 65535) {
                        table = new Converter();
                        this.ccsid_ = table.getCcsid();
                    } else {
                        table = new Converter(this.ccsid_);
                    }
                    this.tableImpl_ = table.impl;
                } else {
                    if (this.ccsid_ == 65535) {
                        this.ccsid_ = this.system_.getCcsid();
                    }
                    Converter table = new Converter(this.ccsid_, this.system_);
                    this.tableImpl_ = table.impl;
                }
                this.encoding_ = this.tableImpl_.getEncoding();
            }
            catch (UnsupportedEncodingException e) {
                Trace.log(2, "Value of parameter 'ccsid' is not valid:", this.ccsid_);
                throw new ExtendedIllegalArgumentException("ccsid (" + this.ccsid_ + ")", 2);
            }
            if (Trace.traceOn_) {
                Trace.log(5, "AS400Text object initialized, encoding: " + this.encoding_ + ", CCSID: " + this.ccsid_ + ", system: " + this.system_ + ", table: " + this.tableImpl_);
            }
        }
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] serverValue = new byte[this.length_];
        this.toBytes(javaValue, serverValue, 0);
        return serverValue;
    }

    @Override
    public int toBytes(Object javaValue, byte[] serverValue) {
        return this.toBytes(javaValue, serverValue, 0);
    }

    @Override
    public int toBytes(Object javaValue, byte[] serverValue, int offset) {
        if (this.system_ != null && !this.system_.bidiAS400Text) {
            return this.toBytes(javaValue, serverValue, offset, new BidiConversionProperties(AS400BidiTransform.getStringType(this.system_.getCcsid())));
        }
        return this.toBytes(javaValue, serverValue, offset, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public int toBytes(Object javaValue, byte[] serverValue, int offset, int type) {
        return this.toBytes(javaValue, serverValue, offset, new BidiConversionProperties(type));
    }

    public int toBytes(Object javaValue, byte[] serverValue, int offset, BidiConversionProperties properties) {
        byte[] eValue;
        int i;
        if (javaValue == null) {
            Trace.log(2, "Parameter 'javaValue' is null.");
            throw new NullPointerException("javaValue");
        }
        this.setTable();
        char[] cbuf = null;
        cbuf = javaValue instanceof char[] ? (char[])javaValue : ((String)javaValue).toCharArray();
        if (AS400BidiTransform.isBidiCcsid(this.ccsid_)) {
            int realLength = cbuf.length;
            if (this.ccsid_ == 13488 || this.ccsid_ == 61952) {
                realLength *= 2;
            }
            int numPadBytes = this.length_ - realLength;
            if (this.ccsid_ == 13488 || this.ccsid_ == 61952) {
                numPadBytes /= 2;
            }
            if (numPadBytes > 0) {
                char[] paddedBuf = new char[cbuf.length + numPadBytes];
                System.arraycopy(cbuf, 0, paddedBuf, 0, cbuf.length);
                for (i = cbuf.length; i < paddedBuf.length; ++i) {
                    paddedBuf[i] = 32;
                }
                cbuf = paddedBuf;
                if (Trace.traceOn_) {
                    Trace.log(5, "Pre-padded Bidi String with " + numPadBytes + " spaces from '" + javaValue + "' to '" + String.valueOf(cbuf) + "'");
                }
            }
        }
        if ((eValue = this.tableImpl_.charArrayToByteArray(cbuf, properties)).length > this.length_) {
            Trace.log(2, "Length of parameter 'javaValue' is not valid: '" + javaValue + "'");
            throw new ExtendedIllegalArgumentException("javaValue (" + String.valueOf(cbuf) + ")", 1);
        }
        System.arraycopy(eValue, 0, serverValue, offset, eValue.length);
        int index = offset + eValue.length;
        if (index < serverValue.length && index < offset + this.length_) {
            if (this.padding_ == null) {
                this.padding_ = this.tableImpl_.stringToByteArray(" ");
                switch (this.padding_.length) {
                    case 0: {
                        this.padding_ = this.tableImpl_.stringToByteArray("\u3000");
                        break;
                    }
                    case 1: {
                        if (this.padding_[0] != 63 && this.padding_[0] != 127 && this.padding_[0] != 26) break;
                        this.padding_ = this.tableImpl_.stringToByteArray("\u3000");
                        break;
                    }
                    case 2: {
                        int s = 0xFFFF & BinaryConverter.byteArrayToShort(this.padding_, 0);
                        if (s != 65278 && s != 65533 && s != 63 && s != 127 && s != 26) break;
                        this.padding_ = this.tableImpl_.stringToByteArray("\u3000");
                        break;
                    }
                    default: {
                        if (Trace.traceOn_) {
                            Trace.log(4, "AS400Text.toBytes(): Padding character not found for 0x0020 or 0x3000 under CCSID " + this.tableImpl_.getCcsid(), this.padding_, 0, this.padding_.length);
                            Trace.log(4, "Using 0x40 as default padding character.");
                        }
                        this.padding_ = new byte[]{64};
                    }
                }
            }
            int max = offset + this.length_ < serverValue.length ? offset + this.length_ : serverValue.length;
            for (i = 0; i < max - index; ++i) {
                serverValue[i + index] = this.padding_[i % this.padding_.length];
            }
        }
        int max = offset + this.length_ < serverValue.length ? offset + this.length_ : serverValue.length;
        for (i = 0; i < max - index; ++i) {
            serverValue[i + index] = this.padding_[i % this.padding_.length];
        }
        if (Trace.traceOn_) {
            Trace.log(5, "AS400Text.toBytes(): Converted javaValue (" + cbuf.toString() + ") to:", serverValue, offset, this.length_);
        }
        return this.length_;
    }

    @Override
    public Object toObject(byte[] serverValue) {
        if (serverValue == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(serverValue, 0, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    @Override
    public Object toObject(byte[] serverValue, int offset) {
        if (serverValue == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(serverValue, offset, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public Object toObject(byte[] serverValue, int offset, int type) {
        return this.toObject(serverValue, offset, new BidiConversionProperties(type));
    }

    public Object toObject(byte[] serverValue, int offset, BidiConversionProperties properties) {
        if (serverValue == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(serverValue, offset, this.length_, properties);
    }

    private int getSystemBidiType() {
        if (this.system_ == null) {
            return 0;
        }
        return this.system_.getBidiStringType();
    }

    public Object toCharArray(byte[] serverValue) {
        if (serverValue == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        this.setTable();
        return this.tableImpl_.byteArrayToCharArray(serverValue, 0, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public Object toCharArray(byte[] serverValue, int offset) {
        if (serverValue == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        this.setTable();
        return this.tableImpl_.byteArrayToCharArray(serverValue, offset, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public Object toCharArray(byte[] serverValue, int offset, int type) {
        return this.toCharArray(serverValue, offset, new BidiConversionProperties(type));
    }

    public Object toCharArray(byte[] serverValue, int offset, BidiConversionProperties properties) {
        if (serverValue == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        this.setTable();
        return this.tableImpl_.byteArrayToCharArray(serverValue, offset, this.length_, properties);
    }
}

