/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;

public class BinaryConverter {
    private static final char[] c_ = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] b_ = new byte[]{17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 17, 17, 17, 17, 17, 17, 10, 11, 12, 13, 14, 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 10, 11, 12, 13, 14, 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};

    private BinaryConverter() {
    }

    public static void shortToByteArray(short shortValue, byte[] serverValue, int offset) {
        if (serverValue == null) {
            throw new NullPointerException("serverValue");
        }
        serverValue[offset] = (byte)(shortValue >>> 8);
        serverValue[offset + 1] = (byte)shortValue;
    }

    public static byte[] shortToByteArray(short shortValue) {
        byte[] serverValue = new byte[2];
        BinaryConverter.shortToByteArray(shortValue, serverValue, 0);
        return serverValue;
    }

    public static short byteArrayToShort(byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        return (short)(((serverValue[offset] & 0xFF) << 8) + (serverValue[offset + 1] & 0xFF));
    }

    public static void intToByteArray(int intValue, byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        serverValue[offset] = (byte)(intValue >>> 24);
        serverValue[offset + 1] = (byte)(intValue >>> 16);
        serverValue[offset + 2] = (byte)(intValue >>> 8);
        serverValue[offset + 3] = (byte)intValue;
    }

    public static byte[] intToByteArray(int intValue) {
        byte[] serverValue = new byte[4];
        BinaryConverter.intToByteArray(intValue, serverValue, 0);
        return serverValue;
    }

    public static int byteArrayToInt(byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        return ((serverValue[offset] & 0xFF) << 24) + ((serverValue[offset + 1] & 0xFF) << 16) + ((serverValue[offset + 2] & 0xFF) << 8) + (serverValue[offset + 3] & 0xFF);
    }

    public static void floatToByteArray(float floatValue, byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        int bits = Float.floatToIntBits(floatValue);
        serverValue[offset] = (byte)(bits >>> 24);
        serverValue[offset + 1] = (byte)(bits >>> 16);
        serverValue[offset + 2] = (byte)(bits >>> 8);
        serverValue[offset + 3] = (byte)bits;
    }

    public static byte[] floatToByteArray(int floatValue) {
        byte[] serverValue = new byte[4];
        BinaryConverter.floatToByteArray(floatValue, serverValue, 0);
        return serverValue;
    }

    public static byte[] floatToByteArray(float floatValue) {
        byte[] serverValue = new byte[4];
        BinaryConverter.floatToByteArray(floatValue, serverValue, 0);
        return serverValue;
    }

    public static float byteArrayToFloat(byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        int bits = ((serverValue[offset] & 0xFF) << 24) + ((serverValue[offset + 1] & 0xFF) << 16) + ((serverValue[offset + 2] & 0xFF) << 8) + (serverValue[offset + 3] & 0xFF);
        return Float.intBitsToFloat(bits);
    }

    public static void doubleToByteArray(double doubleValue, byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        long bits = Double.doubleToLongBits(doubleValue);
        int high = (int)(bits >>> 32);
        int low = (int)bits;
        serverValue[offset] = (byte)(high >>> 24);
        serverValue[offset + 1] = (byte)(high >>> 16);
        serverValue[offset + 2] = (byte)(high >>> 8);
        serverValue[offset + 3] = (byte)high;
        serverValue[offset + 4] = (byte)(low >>> 24);
        serverValue[offset + 5] = (byte)(low >>> 16);
        serverValue[offset + 6] = (byte)(low >>> 8);
        serverValue[offset + 7] = (byte)low;
    }

    public static byte[] doubleToByteArray(double doubleValue) {
        byte[] serverValue = new byte[8];
        BinaryConverter.doubleToByteArray(doubleValue, serverValue, 0);
        return serverValue;
    }

    public static double byteArrayToDouble(byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        int firstPart = ((serverValue[offset] & 0xFF) << 24) + ((serverValue[offset + 1] & 0xFF) << 16) + ((serverValue[offset + 2] & 0xFF) << 8) + (serverValue[offset + 3] & 0xFF);
        int secondPart = ((serverValue[offset + 4] & 0xFF) << 24) + ((serverValue[offset + 5] & 0xFF) << 16) + ((serverValue[offset + 6] & 0xFF) << 8) + (serverValue[offset + 7] & 0xFF);
        long bits = ((long)firstPart << 32) + ((long)secondPart & 0xFFFFFFFFL);
        return Double.longBitsToDouble(bits);
    }

    public static void unsignedShortToByteArray(int intValue, byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        serverValue[offset] = (byte)(intValue >>> 8);
        serverValue[offset + 1] = (byte)intValue;
    }

    public static byte[] unsignedShortToByteArray(int intValue) {
        byte[] serverValue = new byte[2];
        BinaryConverter.unsignedShortToByteArray(intValue, serverValue, 0);
        return serverValue;
    }

    public static int byteArrayToUnsignedShort(byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        return ((serverValue[offset] & 0xFF) << 8) + (serverValue[offset + 1] & 0xFF);
    }

    public static void unsignedIntToByteArray(long longValue, byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        int bits = (int)longValue;
        serverValue[offset] = (byte)(bits >>> 24);
        serverValue[offset + 1] = (byte)(bits >>> 16);
        serverValue[offset + 2] = (byte)(bits >>> 8);
        serverValue[offset + 3] = (byte)bits;
    }

    public static byte[] unsignedIntToByteArray(long longValue) {
        byte[] serverValue = new byte[4];
        BinaryConverter.unsignedIntToByteArray(longValue, serverValue, 0);
        return serverValue;
    }

    public static long byteArrayToUnsignedInt(byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        return (long)(((serverValue[offset] & 0xFF) << 24) + ((serverValue[offset + 1] & 0xFF) << 16) + ((serverValue[offset + 2] & 0xFF) << 8) + (serverValue[offset + 3] & 0xFF)) & 0xFFFFFFFFL;
    }

    public static void longToByteArray(long longValue, byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        int high = (int)(longValue >>> 32);
        int low = (int)longValue;
        serverValue[offset] = (byte)(high >>> 24);
        serverValue[offset + 1] = (byte)(high >>> 16);
        serverValue[offset + 2] = (byte)(high >>> 8);
        serverValue[offset + 3] = (byte)high;
        serverValue[offset + 4] = (byte)(low >>> 24);
        serverValue[offset + 5] = (byte)(low >>> 16);
        serverValue[offset + 6] = (byte)(low >>> 8);
        serverValue[offset + 7] = (byte)low;
    }

    public static byte[] longToByteArray(long longValue) {
        byte[] serverValue = new byte[8];
        BinaryConverter.longToByteArray(longValue, serverValue, 0);
        return serverValue;
    }

    public static long byteArrayToLong(byte[] serverValue, int offset) {
        BinaryConverter.checkArgs(serverValue, offset);
        int firstPart = ((serverValue[offset] & 0xFF) << 24) + ((serverValue[offset + 1] & 0xFF) << 16) + ((serverValue[offset + 2] & 0xFF) << 8) + (serverValue[offset + 3] & 0xFF);
        int secondPart = ((serverValue[offset + 4] & 0xFF) << 24) + ((serverValue[offset + 5] & 0xFF) << 16) + ((serverValue[offset + 6] & 0xFF) << 8) + (serverValue[offset + 7] & 0xFF);
        return ((long)firstPart << 32) + ((long)secondPart & 0xFFFFFFFFL);
    }

    public static byte[] charArrayToByteArray(char[] charValue) {
        if (charValue == null) {
            return null;
        }
        byte[] byteValue = new byte[charValue.length * 2];
        int inPos = 0;
        int outPos = 0;
        while (inPos < charValue.length) {
            byteValue[outPos++] = (byte)(charValue[inPos] >> 8);
            byteValue[outPos++] = (byte)charValue[inPos++];
        }
        return byteValue;
    }

    public static char[] byteArrayToCharArray(byte[] byteValue) {
        if (byteValue == null) {
            return null;
        }
        char[] charValue = new char[byteValue.length / 2];
        int inPos = 0;
        int outPos = 0;
        while (inPos < byteValue.length) {
            charValue[outPos++] = (char)(((byteValue[inPos++] & 0xFF) << 8) + (byteValue[inPos++] & 0xFF));
        }
        return charValue;
    }

    static final char hiNibbleToChar(byte b) {
        return c_[b >>> 4 & 0xF];
    }

    static final char loNibbleToChar(byte b) {
        return c_[b & 0xF];
    }

    public static final String bytesToString(byte[] b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        return BinaryConverter.bytesToHexString(b, 0, b.length);
    }

    public static final String bytesToString(byte[] b, int offset, int length) {
        return BinaryConverter.bytesToHexString(b, offset, length);
    }

    public static final String bytesToHexString(byte[] b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        return BinaryConverter.bytesToHexString(b, 0, b.length);
    }

    public static final String bytesToHexString(byte[] b, int offset, int length) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        char[] c = new char[length * 2];
        int num = BinaryConverter.bytesToHexString(b, offset, length, c, 0);
        return new String(c, 0, num);
    }

    static final int bytesToHexString(byte[] b, int offset, int length, char[] c, int coffset) {
        for (int i = 0; i < length; ++i) {
            int j = i * 2;
            byte hi = (byte)(b[i + offset] >>> 4 & 0xF);
            byte lo = (byte)(b[i + offset] & 0xF);
            c[j + coffset] = c_[hi];
            c[j + coffset + 1] = c_[lo];
        }
        return length * 2;
    }

    static final byte charsToByte(char hi, char lo) throws NumberFormatException {
        int c1 = 0xFFFF & hi;
        int c2 = 0xFFFF & lo;
        if (c1 > 255 || c2 > 255) {
            throw new NumberFormatException();
        }
        byte b1 = b_[c1];
        byte b2 = b_[c2];
        if (b1 == 17 || b2 == 17) {
            return 0;
        }
        return (byte)((byte)(b1 << 4) + b2);
    }

    static final void checkArgs(byte[] serverValue, int offset) throws NullPointerException {
        if (serverValue == null) {
            throw new NullPointerException("serverValue");
        }
        if (offset < 0 || offset > serverValue.length - 1) {
            if (Trace.traceOn_) {
                Trace.log(2, "Offset " + offset + " was specified for array of length " + serverValue.length + ".");
            }
            ArrayIndexOutOfBoundsException ex = new ArrayIndexOutOfBoundsException(String.valueOf(offset));
            if (Trace.traceOn_) {
                Trace.log(2, ex);
            }
            throw ex;
        }
    }

    public static final byte[] stringToBytes(String s) throws NumberFormatException {
        if (s == null) {
            throw new NullPointerException("s");
        }
        int stringLength = s.length();
        if (stringLength > 2) {
            if (s.charAt(0) == '0' && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                s = s.substring(2);
            } else if ((s.charAt(0) == 'x' || s.charAt(0) == 'X') && s.charAt(1) == '\'') {
                if (s.charAt(stringLength - 1) == '\'') {
                    s = s.substring(2, stringLength - 1);
                } else {
                    throw new NumberFormatException();
                }
            }
        }
        if (s.length() % 2 != 0) {
            s = "0" + s;
        }
        char[] c = s.toCharArray();
        return BinaryConverter.stringToBytes(c, 0, c.length);
    }

    static final byte[] stringToBytes(char[] hex, int offset, int length) {
        if (hex.length == 0) {
            return new byte[0];
        }
        byte[] buf = new byte[(length + 1) / 2];
        int num = BinaryConverter.stringToBytes(hex, offset, length, buf, 0);
        if (num < buf.length) {
            byte[] temp = buf;
            buf = new byte[num];
            System.arraycopy(temp, 0, buf, 0, num);
        }
        return buf;
    }

    static final int stringToBytes(char[] hex, int offset, int length, byte[] b, int boff) throws NumberFormatException {
        if (hex.length == 0) {
            return 0;
        }
        for (int i = 0; i < length / 2; ++i) {
            int j = i * 2;
            int c1 = 0xFFFF & hex[j + offset];
            int c2 = 0xFFFF & hex[j + offset + 1];
            if (c1 > 255 || c2 > 255) {
                throw new NumberFormatException();
            }
            byte b1 = b_[c1];
            byte b2 = b_[c2];
            if (b1 == 17 || b2 == 17) {
                throw new NumberFormatException();
            }
            byte hi = (byte)(b1 << 4);
            b[i + boff] = (byte)(hi + b2);
        }
        return length / 2;
    }
}

