/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataArea;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class LocalDataArea
extends DataArea
implements Serializable {
    static final long serialVersionUID = 4L;
    static final int DEFAULT_LENGTH = 1024;
    static final String DEFAULT_PATH = "/QSYS.LIB/          .LIB/*LDA.DTAARA";

    public LocalDataArea() {
        try {
            super.setPath(DEFAULT_PATH);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.length_ = 1024;
        this.dataAreaType_ = 3;
    }

    public LocalDataArea(AS400 system) {
        super(system, DEFAULT_PATH);
        this.length_ = 1024;
        this.dataAreaType_ = 3;
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.clear();
        this.fireCleared();
    }

    public String read() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String val = this.impl_.retrieve(-1, 1);
        this.fireRead();
        return val;
    }

    public String read(int type) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String val = this.impl_.retrieve(-1, 1, type);
        this.fireRead();
        return val;
    }

    public String read(int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (dataLength < 1 || dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (dataAreaOffset + dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String val = this.impl_.retrieve(dataAreaOffset, dataLength);
        this.fireRead();
        return val;
    }

    public String read(int dataAreaOffset, int dataLength, int type) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (dataLength < 1 || dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (dataAreaOffset + dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String val = this.impl_.retrieve(dataAreaOffset, dataLength, type);
        this.fireRead();
        return val;
    }

    @Override
    public int read(byte[] dataBuffer, int dataBufferOffset, int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        return super.read(dataBuffer, dataBufferOffset, dataAreaOffset, dataLength);
    }

    public void write(String data) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length() < 1 || data.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(data, 0);
        this.fireWritten();
    }

    public void write(String data, int dataAreaOffset) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length() < 1 || data.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (dataAreaOffset + data.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(data, dataAreaOffset);
        this.fireWritten();
    }

    public void write(String data, int dataAreaOffset, int type) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length() < 1 || data.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (dataAreaOffset + data.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(data, dataAreaOffset, type);
        this.fireWritten();
    }

    @Override
    public void write(byte[] dataBuffer, int dataBufferOffset, int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super.write(dataBuffer, dataBufferOffset, dataAreaOffset, dataLength);
    }
}

