/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.LicenseException;
import com.ibm.as400.access.LicenseGetInformationReply;
import com.ibm.as400.access.LicenseGetReply;
import com.ibm.as400.access.LicenseGetRequest;
import com.ibm.as400.access.LicenseReleaseReply;
import com.ibm.as400.access.LicenseReleaseRequest;
import com.ibm.as400.access.NLSExchangeAttrReply;
import com.ibm.as400.access.NLSExchangeAttrRequest;
import com.ibm.as400.access.ProductLicenseEvent;
import com.ibm.as400.access.ProductLicenseListener;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class ProductLicense
implements Serializable {
    public static final int USAGE_CONCURRENT = 1;
    public static final int USAGE_REGISTERED = 2;
    public static final int COMPLIANCE_OPERATOR_ACTION = 1;
    public static final int COMPLIANCE_WARNING = 2;
    public static final int COMPLIANCE_KEYED = 3;
    public static final int CONDITION_OK = 0;
    public static final int CONDITION_EXCEEDED_OK = 43;
    public static final int CONDITION_EXCEEDED_GRACE_PERIOD = 44;
    public static final int CONDITION_GRACE_PERIOD_EXPIRED = 46;
    private transient PropertyChangeSupport changes_;
    private transient Vector productLicenseListeners_;
    static final long serialVersionUID = 4L;
    private transient boolean released_;
    private transient int condition_;
    private transient AS400 sys_;
    private transient AS400Server server_;
    private transient AS400ImplRemote sysImpl_;
    private String productID_;
    private String featureID_;
    private String releaseLevel_;
    private transient int usageLimit_;
    private transient int usageCount_;
    private transient int usageType_;
    private transient int complianceType_;
    private transient String licenseTerm_;

    public ProductLicense() {
        this.initializeTransient();
        this.productID_ = null;
        this.featureID_ = null;
    }

    public ProductLicense(AS400 system, String productID, String featureID, String release) {
        this();
        this.sys_ = new AS400(system);
        if (this.sys_ == null) {
            throw new NullPointerException("system");
        }
        if (productID == null) {
            throw new NullPointerException("productID");
        }
        this.productID_ = productID;
        if (featureID == null) {
            throw new NullPointerException("featureID");
        }
        this.featureID_ = featureID;
        this.releaseLevel_ = release == null ? "      " : release;
    }

    public void addProductLicenseListener(ProductLicenseListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.productLicenseListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        AS400 aS400 = this.sys_;
        synchronized (aS400) {
            block7: {
                if (this.server_ != null) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Disconnecting from server");
                    }
                    try {
                        this.sysImpl_.disconnectServer(this.server_);
                        this.server_ = null;
                    }
                    catch (Exception e) {
                        if (!Trace.traceOn_) break block7;
                        Trace.log(2, "Exception encountered while disconnecting", (Throwable)e);
                    }
                }
            }
        }
    }

    protected void finalize() {
        block3: {
            if (Trace.traceOn_) {
                Trace.log(1, "finalize() - ProductLicense");
            }
            try {
                this.release();
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block3;
                Trace.log(2, "release license failed", (Throwable)e);
            }
        }
    }

    private void fireProductLicenseEvent(int status) {
        ProductLicenseEvent event = new ProductLicenseEvent(this, status);
        Vector targets = (Vector)this.productLicenseListeners_.clone();
        block4: for (int i = 0; i < targets.size(); ++i) {
            ProductLicenseListener target = (ProductLicenseListener)targets.elementAt(i);
            switch (status) {
                case 0: {
                    target.licenseReleased(event);
                    continue block4;
                }
                case 1: {
                    target.licenseRequested(event);
                    continue block4;
                }
                default: {
                    Trace.log(2, "Event status:", status);
                }
            }
        }
    }

    public int getComplianceType() {
        if (this.released_) {
            throw new ExtendedIllegalStateException(14);
        }
        return this.complianceType_;
    }

    public int getCondition() {
        if (this.released_) {
            throw new ExtendedIllegalStateException("Object= " + this.sys_.getSystemName(), 14);
        }
        return this.condition_;
    }

    public String getFeature() {
        return this.featureID_;
    }

    public String getLicenseTerm() {
        if (this.released_) {
            throw new ExtendedIllegalStateException("Object= " + this.sys_.getSystemName(), 14);
        }
        return this.licenseTerm_;
    }

    public String getProductID() {
        return this.productID_;
    }

    public String getReleaseLevel() {
        return this.releaseLevel_;
    }

    public AS400 getSystem() {
        return this.sys_;
    }

    public int getUsageCount() {
        if (this.released_) {
            throw new ExtendedIllegalStateException(14);
        }
        return this.usageCount_;
    }

    public int getUsageLimit() {
        if (this.released_) {
            throw new ExtendedIllegalStateException("Object= " + this.sys_.getSystemName(), 14);
        }
        return this.usageLimit_;
    }

    public int getUsageType() {
        if (this.released_) {
            throw new ExtendedIllegalStateException("UsageType", 14);
        }
        return this.usageType_;
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.productLicenseListeners_ = new Vector();
        this.sys_ = null;
        this.sysImpl_ = null;
        this.condition_ = 0;
        this.released_ = true;
        this.usageLimit_ = 0;
        this.usageCount_ = -1;
        this.usageType_ = -1;
        this.complianceType_ = -1;
        this.licenseTerm_ = null;
        this.releaseLevel_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws IOException, InterruptedException, LicenseException {
        if (this.sys_ == null) {
            if (Trace.traceOn_) {
                Trace.log(2, "System not set yet.");
            }
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.productID_ == null) {
            if (Trace.traceOn_) {
                Trace.log(2, "Product ID not set yet.");
            }
            throw new ExtendedIllegalStateException("productID", 4);
        }
        if (this.featureID_ == null) {
            if (Trace.traceOn_) {
                Trace.log(2, "Feature ID not set yet.");
            }
            throw new ExtendedIllegalStateException("featureID", 4);
        }
        if (this.releaseLevel_ == null) {
            if (Trace.traceOn_) {
                Trace.log(2, "Release not set yet.");
            }
            throw new ExtendedIllegalStateException("release", 4);
        }
        AS400 aS400 = this.sys_;
        synchronized (aS400) {
            if (this.released_) {
                return;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Releasing license from server");
            }
            if (this.server_ != null) {
                LicenseReleaseRequest releaseRequest = new LicenseReleaseRequest(this.sys_);
                releaseRequest.setProductID(this.productID_);
                releaseRequest.setFeature(this.featureID_);
                releaseRequest.setRelease(this.releaseLevel_);
                DataStream baseReply = this.server_.sendAndReceive(releaseRequest);
                if (baseReply instanceof LicenseReleaseReply) {
                    LicenseReleaseReply releaseReply = (LicenseReleaseReply)baseReply;
                    this.released_ = true;
                    this.disconnect();
                    if (releaseReply.getPrimaryRC() != 0) {
                        Trace.log(1, "Release license failed, primary return code = ", releaseReply.getPrimaryRC());
                        Trace.log(1, "Release license failed, secondary return code = ", releaseReply.getSecondaryRC());
                        throw new LicenseException(releaseReply.getPrimaryRC(), releaseReply.getSecondaryRC());
                    }
                    this.fireProductLicenseEvent(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int request() throws IOException, AS400SecurityException, InterruptedException, LicenseException {
        if (this.sys_ == null) {
            if (Trace.traceOn_) {
                Trace.log(2, "System not set yet.");
            }
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.productID_ == null) {
            if (Trace.traceOn_) {
                Trace.log(2, "Product ID not set yet.");
            }
            throw new ExtendedIllegalStateException("productID", 4);
        }
        if (this.featureID_ == null) {
            if (Trace.traceOn_) {
                Trace.log(2, "Feature ID not set yet.");
            }
            throw new ExtendedIllegalStateException("featureID", 4);
        }
        if (this.releaseLevel_ == null) {
            if (Trace.traceOn_) {
                Trace.log(2, "Release not set yet.");
            }
            throw new ExtendedIllegalStateException("release", 4);
        }
        AS400 aS400 = this.sys_;
        synchronized (aS400) {
            if (!this.released_) {
                throw new ExtendedIllegalStateException("Object= " + this.sys_.getSystemName(), 15);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "retrieving license from server");
            }
            this.sys_.connectService(6);
            this.sysImpl_ = (AS400ImplRemote)this.sys_.getImpl();
            this.server_ = this.sysImpl_.getConnection(6, false, false);
            NLSExchangeAttrRequest request = new NLSExchangeAttrRequest();
            try {
                this.server_.sendExchangeAttrRequest(request);
            }
            catch (IOException e) {
                Trace.log(2, "IOException After Exchange Attribute Request", (Throwable)e);
                this.disconnect();
                throw e;
            }
            DataStream baseReply = this.server_.getExchangeAttrReply();
            if (baseReply instanceof NLSExchangeAttrReply) {
                NLSExchangeAttrReply NLSReply = (NLSExchangeAttrReply)baseReply;
                if (NLSReply.primaryRC_ != 0) {
                    Trace.log(2, "Exchange attribute failed, primary return code =" + NLSReply.primaryRC_ + "secondary return code =" + NLSReply.getSecondaryRC_());
                    this.disconnect();
                    throw new IOException();
                }
            } else {
                if (Trace.traceOn_) {
                    Trace.log(2, "Unknown instance returned from Exchange Attribute Reply");
                }
                throw new InternalErrorException(2);
            }
            LicenseGetRequest getLicReq = new LicenseGetRequest(this.sys_);
            getLicReq.setProductID(this.productID_);
            getLicReq.setFeature(this.featureID_);
            getLicReq.setRelease(this.releaseLevel_);
            try {
                baseReply = this.server_.sendAndReceive(getLicReq);
            }
            catch (IOException e) {
                Trace.log(2, "IOException occured - Request license", (Throwable)e);
                this.disconnect();
                throw e;
            }
            if (baseReply instanceof LicenseGetReply) {
                LicenseGetReply getReply = (LicenseGetReply)baseReply;
                if (getReply.getPrimaryRC() == 0) {
                    this.usageLimit_ = getReply.getUsageLimit();
                    this.usageCount_ = getReply.getUsageCount();
                    ++this.usageCount_;
                    this.usageType_ = getReply.getUsageType();
                    this.complianceType_ = getReply.getComplianceType();
                    this.licenseTerm_ = getReply.getLicenseTerm();
                    this.releaseLevel_ = getReply.getReleaseLevel();
                    this.condition_ = getReply.getSecondaryRC();
                    switch (this.condition_) {
                        case 0: 
                        case 43: 
                        case 44: 
                        case 46: {
                            break;
                        }
                        default: {
                            Trace.log(2, "LicenseGetReply.getSecondaryRC():", this.condition_);
                        }
                    }
                    this.released_ = false;
                    this.fireProductLicenseEvent(1);
                    return this.condition_;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "Request license failed, primary return code =" + getReply.getPrimaryRC() + "secondary return code =" + getReply.getSecondaryRC());
                }
                throw new LicenseException(getReply.getPrimaryRC(), getReply.getSecondaryRC());
            }
            if (Trace.traceOn_) {
                Trace.log(2, "Unknown instance returned from Get License Reply");
            }
            throw new InternalErrorException(2);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeProductLicenseListener(ProductLicenseListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.productLicenseListeners_.removeElement(listener);
    }

    public void setFeature(String featureID) {
        if (featureID == null) {
            throw new NullPointerException("featureID");
        }
        if (this.sysImpl_ != null) {
            throw new ExtendedIllegalStateException("featureID", 5);
        }
        String oldFeatureID = this.featureID_;
        this.featureID_ = featureID;
        this.changes_.firePropertyChange("featureID", oldFeatureID, this.featureID_);
    }

    public void setProductID(String productID) {
        if (productID == null) {
            throw new NullPointerException("productID");
        }
        if (this.sysImpl_ != null) {
            throw new ExtendedIllegalStateException("productID", 5);
        }
        String oldProductID = this.productID_;
        this.productID_ = productID;
        this.changes_.firePropertyChange("productID", oldProductID, this.productID_);
    }

    public void setReleaseLevel(String releaseLevel) {
        if (releaseLevel == null) {
            throw new NullPointerException("releaseLevel");
        }
        if (this.sysImpl_ != null) {
            throw new ExtendedIllegalStateException("releaseLevel", 5);
        }
        String oldReleaseLevel = this.releaseLevel_;
        this.releaseLevel_ = releaseLevel;
        this.changes_.firePropertyChange("releaseLevel", oldReleaseLevel, this.releaseLevel_);
    }

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.sysImpl_ != null) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 oldSystem = this.sys_;
        this.sys_ = system;
        this.changes_.firePropertyChange("path", oldSystem, this.sys_);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    static {
        AS400Server.addReplyStream((DataStream)new NLSExchangeAttrReply(), "as-central");
        AS400Server.addReplyStream((DataStream)new LicenseGetReply(), "as-central");
        AS400Server.addReplyStream((DataStream)new LicenseReleaseReply(), "as-central");
        AS400Server.addReplyStream((DataStream)new LicenseGetInformationReply(), "as-central");
    }
}

