/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.AS400JDBCSQLXMLLocator;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLClobLocator
implements SQLLocator {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private SQLConversionSettings settings_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private String value_;
    private String savedValue_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;

    SQLClobLocator(AS400JDBCConnection connection, int id, int maxLength, SQLConversionSettings settings, ConvTable converter, int columnIndex) {
        this.connection_ = connection;
        this.id_ = id;
        this.locator_ = new JDLobLocator(connection, id, maxLength, false);
        this.maxLength_ = maxLength;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.settings_ = settings;
        this.converter_ = converter;
        this.columnIndex_ = columnIndex;
    }

    @Override
    public Object clone() {
        return new SQLClobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    @Override
    public void setHandle(int handle) {
        this.locator_.setHandle(handle);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    @Override
    public int getHandle() {
        return this.locator_.getHandle();
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable converter) throws SQLException {
        this.convertFromRawBytes(rawBytes, offset, converter, false);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int locatorHandle = BinaryConverter.byteArrayToInt(rawBytes, offset);
        this.locator_.setHandle(locatorHandle);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), rawBytes, offset);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    @Override
    public void validateRawTruncatedData(byte[] rawBytes, int offset, ConvTable ccsidConverter) {
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof String) {
            String s = (String)object;
            int length = s.length();
            if (this.maxLength_ > 0) {
                this.truncated_ = length > this.maxLength_ ? length - this.maxLength_ : 0;
            }
            this.outOfBounds_ = false;
        } else if (!(object instanceof Reader || object instanceof InputStream || object instanceof Clob || object instanceof SQLXML)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.savedObjectWrittenToServer_ = false;
        if (scale != -1) {
            this.scale_ = scale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        int length_ = this.scale_;
        if (length_ == -1) {
            try {
                length_ = (int)this.locator_.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.savedObject_;
        if (this.savedObject_ instanceof String) {
            this.value_ = (String)object;
        } else if (object instanceof Reader) {
            this.value_ = SQLDataBase.getStringFromReader((Reader)object, length_, this);
            this.savedObject_ = this.value_;
        } else if (object instanceof Clob) {
            Clob clob;
            if (object instanceof AS400JDBCClobLocator) {
                Clob clob2 = clob = (AS400JDBCClobLocator)object;
                synchronized (clob2) {
                    if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                        this.savedObjectWrittenToServer_ = false;
                        this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                        if (!(this.savedObject_ instanceof AS400JDBCClobLocator)) {
                            this.doConversion();
                            return;
                        }
                    }
                }
            }
            clob = (Clob)object;
            this.value_ = clob.getSubString(1L, (int)clob.length());
        } else if (object instanceof InputStream) {
            this.value_ = length_ > 0 ? JDUtilities.streamToString((InputStream)object, length_, "UTF-8") : JDUtilities.streamToString((InputStream)object, "UTF-8");
            this.savedObject_ = this.value_;
        } else if (object instanceof SQLXML) {
            SQLXML xml = (SQLXML)object;
            this.value_ = xml.getString();
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int valueLength = this.value_.length();
        if (valueLength > this.maxLength_) {
            this.value_ = this.value_.substring(0, this.maxLength_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToServer() throws SQLException {
        block38: {
            try {
                Object object = this.savedObject_;
                if (object instanceof String) {
                    String string = (String)object;
                    int bidiStringType = this.settings_.getBidiStringType();
                    if (bidiStringType == -1) {
                        bidiStringType = this.converter_.bidiStringType_;
                    }
                    BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
                    bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                    bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                    byte[] bytes = this.converter_.stringToByteArray(string, bidiConversionProperties);
                    this.locator_.writeData(0L, bytes, true);
                    break block38;
                }
                if (object instanceof Reader) {
                    int length = this.scale_;
                    if (length == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block38;
                    }
                    if (length > 0) {
                        int blockSize = length < 1000000 ? length : 1000000;
                        String string = JDUtilities.readerToString((Reader)this.savedObject_);
                        this.savedObject_ = string;
                        int bidiStringType = this.settings_.getBidiStringType();
                        if (bidiStringType == -1) {
                            bidiStringType = this.converter_.bidiStringType_;
                        }
                        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
                        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                        byte[] bytes = this.converter_.stringToByteArray(string, bidiConversionProperties);
                        int totalBytesWritten = 0;
                        int bytesToWrite = blockSize;
                        int totalLengthToWrite = length;
                        if (bytes.length < totalLengthToWrite) {
                            totalLengthToWrite = bytes.length;
                        }
                        while (bytesToWrite > 0 && totalBytesWritten < totalLengthToWrite) {
                            this.locator_.writeData(totalBytesWritten, bytes, totalBytesWritten, bytesToWrite, true);
                            int bytesRemaining = totalLengthToWrite - (totalBytesWritten += bytesToWrite);
                            if (bytesRemaining >= bytesToWrite) continue;
                            bytesToWrite = bytesRemaining;
                        }
                        if (totalBytesWritten < length) {
                            JDError.throwSQLException((Object)this, "07006");
                        }
                        break block38;
                    }
                    if (length == -2) {
                        String string = JDUtilities.readerToString((Reader)this.savedObject_);
                        this.savedObject_ = string;
                        int bidiStringType = this.settings_.getBidiStringType();
                        if (bidiStringType == -1) {
                            bidiStringType = this.converter_.bidiStringType_;
                        }
                        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
                        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                        byte[] bytes = this.converter_.stringToByteArray(string, bidiConversionProperties);
                        this.locator_.writeData(0L, bytes, true);
                        break block38;
                    } else {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    break block38;
                }
                if (object instanceof InputStream) {
                    int length = this.scale_;
                    if (length == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block38;
                    }
                    if (length > 0) {
                        InputStream stream = (InputStream)this.savedObject_;
                        int blockSize = length < 1000000 ? length : 1000000;
                        byte[] byteBuffer = new byte[blockSize];
                        try {
                            int totalBytesRead = 0;
                            int bytesRead = stream.read(byteBuffer, 0, blockSize);
                            while (bytesRead > -1 && totalBytesRead < length) {
                                this.locator_.writeData(totalBytesRead, byteBuffer, 0, bytesRead, true);
                                int bytesRemaining = length - (totalBytesRead += bytesRead);
                                if (bytesRemaining < blockSize) {
                                    blockSize = bytesRemaining;
                                }
                                bytesRead = stream.read(byteBuffer, 0, blockSize);
                            }
                            if (totalBytesRead < length) {
                                JDError.throwSQLException((Object)this, "07006");
                            }
                            break block38;
                        }
                        catch (IOException ie) {
                            JDError.throwSQLException((Object)this, "HY000", ie);
                        }
                        break block38;
                    }
                    if (length == -2) {
                        InputStream stream = (InputStream)this.savedObject_;
                        int blockSize = 1000000;
                        byte[] byteBuffer = new byte[blockSize];
                        try {
                            int totalBytesRead = 0;
                            int bytesRead = stream.read(byteBuffer, 0, blockSize);
                            while (bytesRead > -1) {
                                this.locator_.writeData(totalBytesRead, byteBuffer, 0, bytesRead, true);
                                totalBytesRead += bytesRead;
                                bytesRead = stream.read(byteBuffer, 0, blockSize);
                            }
                            break block38;
                        }
                        catch (IOException ie) {
                            JDError.throwSQLException((Object)this, "HY000", ie);
                            break block38;
                        }
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block38;
                }
                if (object instanceof Clob) {
                    Clob clob;
                    boolean set = false;
                    if (object instanceof AS400JDBCClobLocator) {
                        clob = (AS400JDBCClobLocator)object;
                        AS400JDBCClobLocator blockSize = clob;
                        synchronized (blockSize) {
                            if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                                this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                                this.savedObjectWrittenToServer_ = false;
                                this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                                ((AS400JDBCClobLocator)clob).savedObject_ = null;
                                this.writeToServer();
                                return;
                            }
                        }
                    }
                    if (!set) {
                        clob = (Clob)object;
                        int length = (int)clob.length();
                        String substring = clob.getSubString(1L, length);
                        this.savedObject_ = substring;
                        byte[] writeByteArray = this.converter_.stringToByteArray(substring);
                        this.locator_.writeData(0L, writeByteArray, 0, writeByteArray.length, true);
                        set = true;
                        break block38;
                    } else {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    break block38;
                }
                if (object instanceof SQLXML) {
                    SQLXML xml = (SQLXML)object;
                    String stringVal = xml.getString();
                    this.savedObject_ = stringVal;
                    byte[] outByteArray = this.converter_.stringToByteArray(stringVal);
                    this.locator_.writeData(0L, outByteArray, 0, outByteArray.length, true);
                } else {
                    JDError.throwSQLException((Object)this, "07006");
                }
            }
            finally {
                this.savedObjectWrittenToServer_ = true;
            }
        }
        this.scale_ = (int)this.locator_.getLength();
    }

    @Override
    public int getSQLType() {
        return 8;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        return this.maxLength_;
    }

    @Override
    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCClobLocator";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "CLOB";
    }

    @Override
    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 964;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 2005;
    }

    @Override
    public String getTypeName() {
        return "CLOB";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.maxLength_;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public void clearTruncated() {
        this.truncated_ = 0;
    }

    @Override
    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 819);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new HexReaderInputStream(new StringReader(this.value_));
            }
            return new HexReaderInputStream(new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            byte[] bytes = BinaryConverter.stringToBytes(this.getString());
            return new AS400JDBCBlob(bytes, bytes.length);
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.value_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.value_, this.maxLength_);
        }
        AS400JDBCClobLocator locatorReturn = new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
        if (ConvTable.isMixedCCSID(this.converter_.ccsid_)) {
            this.savedObject_ = locatorReturn.getSubString(1L, (int)locatorReturn.length());
            this.savedObjectWrittenToServer_ = false;
            return new AS400JDBCClob((String)this.savedObject_, this.maxLength_);
        }
        return locatorReturn;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    @Override
    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData data = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String value = this.converter_.byteArrayToString(data.getRawBytes(), data.getOffset(), data.getLength());
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return value;
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 13488);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException("HY000", e);
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.value_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCNClob(this.value_, this.maxLength_);
        }
        AS400JDBCNClobLocator locatorReturn = new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
        if (ConvTable.isMixedCCSID(this.converter_.ccsid_)) {
            this.savedObject_ = locatorReturn.getSubString(1L, (int)locatorReturn.length());
            this.savedObjectWrittenToServer_ = false;
            return new AS400JDBCNClob((String)this.savedObject_, this.maxLength_);
        }
        return locatorReturn;
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData data = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String value = this.converter_.byteArrayToString(data.getRawBytes(), data.getOffset(), data.getLength());
        return value;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCSQLXML(this.value_, this.maxLength_);
        }
        return new AS400JDBCSQLXMLLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_, false);
    }

    @Override
    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void updateSettings(SQLConversionSettings settings) {
        this.settings_ = settings;
    }

    @Override
    public void saveValue() throws SQLException {
        if (this.value_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }

    @Override
    public Object getSavedValue() {
        return this.savedValue_;
    }
}

