/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpaceEvent;
import com.ibm.as400.access.UserSpaceImpl;
import com.ibm.as400.access.UserSpaceListener;
import com.ibm.as400.access.UserSpaceNativeReadWriteImpl;
import com.ibm.as400.access.UserSpaceNativeReadWriteImplILE;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class UserSpace
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.UserSpace";
    static final long serialVersionUID = 4L;
    public static final int FORCE_ASYNCHRONOUS = 1;
    public static final int FORCE_NONE = 0;
    public static final int FORCE_SYNCHRONOUS = 2;
    public static final String DOMAIN_DEFAULT = "*DEFAULT";
    public static final String DOMAIN_USER = "*USER";
    public static final String DOMAIN_SYSTEM = "*SYSTEM";
    private static final int MAX_USER_SPACE_SIZE = 0xFFFE00;
    private AS400 system_ = null;
    private String path_ = "";
    private String library_ = "";
    private String name_ = "";
    private boolean mustUseProgramCall_ = false;
    private boolean mustUseSockets_ = false;
    private boolean mustUseNativeMethods_ = false;
    private transient Converter dataConverter_ = null;
    private transient UserSpaceImpl impl_ = null;
    private transient UserSpaceNativeReadWriteImpl nativeReadWriteImpl_ = null;
    private transient Vector userSpaceListeners_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public UserSpace() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserSpace object.");
        }
    }

    public UserSpace(AS400 system, String path) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserSpace object, system: " + system + " path: " + path);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(path, "USRSPC");
        this.system_ = system;
        this.path_ = path;
        this.library_ = ifs.getLibraryName();
        this.name_ = ifs.getObjectName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.propertyChangeListeners_ == null) {
                    this.propertyChangeListeners_ = new PropertyChangeSupport(this);
                }
            }
        }
        this.propertyChangeListeners_.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserSpaceListener(UserSpaceListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding user space listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.userSpaceListeners_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.userSpaceListeners_ == null) {
                    this.userSpaceListeners_ = new Vector();
                }
            }
        }
        this.userSpaceListeners_.addElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.vetoableChangeListeners_ == null) {
                    this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
                }
            }
        }
        this.vetoableChangeListeners_.addVetoableChangeListener(listener);
    }

    private synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.system_ != null) {
            this.system_.signon(false);
        }
        if (this.impl_ == null) {
            if (this.system_ == null) {
                Trace.log(2, "Cannot connect to the server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.path_.length() == 0) {
                Trace.log(2, "Cannot connect to the server before setting path.");
                throw new ExtendedIllegalStateException("path", 4);
            }
            this.impl_ = this.mustUseSockets_ ? (UserSpaceImpl)this.system_.loadImpl2("com.ibm.as400.access.UserSpaceImplRemote", "com.ibm.as400.access.UserSpaceImplProxy") : (UserSpaceImpl)this.system_.loadImpl3("com.ibm.as400.access.UserSpaceImplNative", "com.ibm.as400.access.UserSpaceImplRemote", "com.ibm.as400.access.UserSpaceImplProxy");
            this.impl_.setProperties(this.system_.getImpl(), this.path_, this.name_, this.library_, this.mustUseProgramCall_, this.mustUseSockets_);
        }
    }

    public synchronized void close() throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing user space.");
        }
        if (this.impl_ != null) {
            this.impl_.close();
        }
    }

    public void create(int length, boolean replace, String extendedAttribute, byte initialValue, String textDescription, String authority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.create(new byte[]{92, -60, -59, -58, -63, -28, -45, -29, 64, 64}, length, replace, extendedAttribute, initialValue, textDescription, authority);
    }

    public void create(String domain, int length, boolean replace, String extendedAttribute, byte initialValue, String textDescription, String authority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] domainBytes;
        if (domain == null) {
            throw new NullPointerException("domain");
        }
        if (domain.equals(DOMAIN_DEFAULT)) {
            domainBytes = new byte[]{92, -60, -59, -58, -63, -28, -45, -29, 64, 64};
        } else if (domain.equals(DOMAIN_USER)) {
            domainBytes = new byte[]{92, -28, -30, -59, -39, 64, 64, 64, 64, 64};
        } else if (domain.equals(DOMAIN_SYSTEM)) {
            domainBytes = new byte[]{92, -30, -24, -30, -29, -59, -44, 64, 64, 64};
        } else {
            throw new ExtendedIllegalArgumentException("domain (" + domain + ")", 2);
        }
        this.create(domainBytes, length, replace, extendedAttribute, initialValue, textDescription, authority);
    }

    private void create(byte[] domainBytes, int length, boolean replace, String extendedAttribute, byte initialValue, String textDescription, String authority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating user space.");
        }
        if (length < 1 || length > 0xFFFE00) {
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 4);
        }
        if (extendedAttribute == null) {
            throw new NullPointerException("extendedAttribute");
        }
        if (extendedAttribute.length() == 0) {
            extendedAttribute = " ";
        }
        if (extendedAttribute.length() > 10) {
            throw new ExtendedIllegalArgumentException("extendedAttribute (" + extendedAttribute + ")", 1);
        }
        if (textDescription == null) {
            throw new NullPointerException("textDescription");
        }
        if (textDescription.length() == 0) {
            textDescription = " ";
        }
        if (textDescription.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription (" + textDescription + ")", 1);
        }
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        if (authority.length() == 0 || authority.length() > 10) {
            throw new ExtendedIllegalArgumentException("authority (" + authority + ")", 1);
        }
        this.chooseImpl();
        this.impl_.create(domainBytes, length, replace, extendedAttribute, initialValue, textDescription, authority);
        if (this.userSpaceListeners_ != null) {
            this.fireUserSpaceEvent(0);
        }
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Deleting user space.");
        }
        this.chooseImpl();
        this.impl_.delete();
        if (this.userSpaceListeners_ != null) {
            this.fireUserSpaceEvent(1);
        }
    }

    public boolean exists() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Determining user space existence.");
        }
        try {
            this.chooseImpl();
            this.impl_.getLength();
            return true;
        }
        catch (ObjectDoesNotExistException e) {
            return false;
        }
    }

    private void fireUserSpaceEvent(int eventType) {
        Vector targets = (Vector)this.userSpaceListeners_.clone();
        UserSpaceEvent event = new UserSpaceEvent(this, eventType);
        block6: for (int i = 0; i < targets.size(); ++i) {
            UserSpaceListener target = (UserSpaceListener)targets.elementAt(i);
            switch (eventType) {
                case 0: {
                    target.created(event);
                    continue block6;
                }
                case 1: {
                    target.deleted(event);
                    continue block6;
                }
                case 2: {
                    target.read(event);
                    continue block6;
                }
                case 3: {
                    target.written(event);
                }
            }
        }
    }

    public byte getInitialValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user space initial value.");
        }
        this.chooseImpl();
        return this.impl_.getInitialValue();
    }

    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user space length.");
        }
        this.chooseImpl();
        return this.impl_.getLength();
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user space name: " + this.name_);
        }
        return this.name_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user space path: " + this.path_);
        }
        return this.path_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public boolean isAutoExtendible() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user space auto extendibility.");
        }
        this.chooseImpl();
        return this.impl_.isAutoExtendible();
    }

    public boolean isMustUseProgramCall() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if user space must use program call:", this.mustUseProgramCall_);
        }
        return this.mustUseProgramCall_;
    }

    public boolean isMustUseNativeMethods() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if user space must use native methods:", this.mustUseNativeMethods_);
        }
        return this.mustUseNativeMethods_;
    }

    public int read(byte[] dataBuffer, int userSpaceOffset) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (dataBuffer == null) {
            throw new NullPointerException("dataBuffer");
        }
        return this.read(dataBuffer, userSpaceOffset, 0, dataBuffer.length);
    }

    public int read(byte[] dataBuffer, int userSpaceOffset, int dataOffset, int length) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int bytesRead;
        if (dataBuffer == null) {
            throw new NullPointerException("dataBuffer");
        }
        if (dataBuffer.length == 0) {
            throw new ExtendedIllegalArgumentException("dataBuffer.length (" + dataBuffer.length + ")", 1);
        }
        if (userSpaceOffset < 0 || userSpaceOffset > 0xFFFE00) {
            throw new ExtendedIllegalArgumentException("userSpaceOffset (" + userSpaceOffset + ")", 4);
        }
        if (dataOffset < 0 || dataOffset >= dataBuffer.length) {
            throw new ExtendedIllegalArgumentException("dataOffset (" + dataOffset + ")", 4);
        }
        if (length < 0 || length > dataBuffer.length - dataOffset) {
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 4);
        }
        if (length == 0) {
            return 0;
        }
        if (this.nativeReadWriteImpl_ != null) {
            bytesRead = this.nativeReadWriteImpl_.read(dataBuffer, userSpaceOffset, dataOffset, length);
        } else {
            this.chooseImpl();
            bytesRead = this.impl_.read(dataBuffer, userSpaceOffset, dataOffset, length);
        }
        if (this.userSpaceListeners_ != null) {
            this.fireUserSpaceEvent(2);
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(int userSpaceOffset, int length) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (length <= 0) {
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 4);
        }
        byte[] dataBuffer = new byte[length];
        this.read(dataBuffer, userSpaceOffset, 0, length);
        if (this.dataConverter_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.dataConverter_ == null) {
                    this.dataConverter_ = new Converter(this.system_.getCcsid(), this.system_);
                }
            }
        }
        return this.dataConverter_.byteArrayToString(dataBuffer);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeUserSpaceListener(UserSpaceListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing user space listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.userSpaceListeners_ != null) {
            this.userSpaceListeners_.removeElement(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public void setAutoExtendible(boolean autoExtendibility) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.chooseImpl();
        this.impl_.setAutoExtendible(autoExtendibility);
    }

    public void setInitialValue(byte initialValue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.chooseImpl();
        this.impl_.setInitialValue(initialValue);
    }

    public void setLength(int length) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (length < 1 || length > 0xFFFE00) {
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 4);
        }
        this.chooseImpl();
        this.impl_.setLength(length);
    }

    public void setMustUseProgramCall(boolean useProgramCall) {
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'mustUseProgramCall' after connect.");
            throw new ExtendedIllegalStateException("mustUseProgramCall", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.mustUseProgramCall_ = useProgramCall;
        } else {
            Boolean oldValue = this.mustUseProgramCall_;
            Boolean newValue = useProgramCall;
            this.mustUseProgramCall_ = useProgramCall;
            this.propertyChangeListeners_.firePropertyChange("mustUseProgramCall", oldValue, newValue);
        }
    }

    public void setMustUseNativeMethods(boolean useNativeMethods) throws UnsupportedEncodingException, CharConversionException, UnsatisfiedLinkError, SecurityException {
        if (this.propertyChangeListeners_ == null) {
            this.mustUseNativeMethods_ = useNativeMethods;
        } else {
            Boolean oldValue = this.mustUseNativeMethods_;
            Boolean newValue = useNativeMethods;
            this.mustUseNativeMethods_ = useNativeMethods;
            this.propertyChangeListeners_.firePropertyChange("mustUseNativeMethods", oldValue, newValue);
        }
        if (useNativeMethods) {
            if (this.nativeReadWriteImpl_ == null) {
                this.nativeReadWriteImpl_ = new UserSpaceNativeReadWriteImplILE(this.system_);
                this.nativeReadWriteImpl_.open(this.library_, this.name_);
            }
        } else if (this.nativeReadWriteImpl_ != null) {
            this.nativeReadWriteImpl_.close();
            this.nativeReadWriteImpl_ = null;
        }
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(path, "USRSPC");
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.library_ = ifs.getLibraryName();
            this.name_ = ifs.getObjectName();
            this.path_ = path;
        } else {
            String oldValue = this.path_;
            String newValue = path;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("path", oldValue, newValue);
            }
            this.library_ = ifs.getLibraryName();
            this.name_ = ifs.getObjectName();
            this.path_ = newValue;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", oldValue, newValue);
            }
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = newValue;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    public void write(byte[] dataBuffer, int userSpaceOffset) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (dataBuffer == null) {
            throw new NullPointerException("dataBuffer");
        }
        this.write(dataBuffer, userSpaceOffset, 0, dataBuffer.length, 0);
    }

    public void write(byte[] dataBuffer, int userSpaceOffset, int dataOffset, int length) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.write(dataBuffer, userSpaceOffset, dataOffset, length, 0);
    }

    public void write(byte[] dataBuffer, int userSpaceOffset, int dataOffset, int length, int forceAuxiliary) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (dataBuffer == null) {
            throw new NullPointerException("dataBuffer");
        }
        if (dataBuffer.length == 0) {
            throw new ExtendedIllegalArgumentException("dataBuffer.length (" + dataBuffer.length + ")", 1);
        }
        if (userSpaceOffset < 0 || userSpaceOffset > 0xFFFE00) {
            throw new ExtendedIllegalArgumentException("userSpaceOffset (" + userSpaceOffset + ")", 4);
        }
        if (dataOffset < 0 || dataOffset >= dataBuffer.length) {
            throw new ExtendedIllegalArgumentException("dataOffset (" + dataOffset + ")", 4);
        }
        if (length < 0 || length > dataBuffer.length - dataOffset) {
            throw new ExtendedIllegalArgumentException("length (" + length + ")", 4);
        }
        if (userSpaceOffset + length >= 0xFFFE00) {
            Trace.log(2, "Request is not supported, causes space overflow.");
            throw new ExtendedIllegalArgumentException("userSpaceOffset + length (" + userSpaceOffset + " + " + length + ")", 2);
        }
        if (forceAuxiliary < 0 || forceAuxiliary > 2) {
            throw new ExtendedIllegalArgumentException("forceAuxiliary (" + forceAuxiliary + ")", 2);
        }
        if (this.nativeReadWriteImpl_ != null) {
            this.nativeReadWriteImpl_.write(dataBuffer, userSpaceOffset, dataOffset, length, forceAuxiliary);
        } else {
            this.chooseImpl();
            this.impl_.write(dataBuffer, userSpaceOffset, dataOffset, length, forceAuxiliary);
        }
        if (this.userSpaceListeners_ != null) {
            this.fireUserSpaceEvent(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String data, int userSpaceOffset) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length() == 0) {
            throw new ExtendedIllegalArgumentException("data (" + data + ")", 1);
        }
        this.chooseImpl();
        if (this.dataConverter_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.dataConverter_ == null) {
                    this.dataConverter_ = new Converter(this.system_.getCcsid(), this.system_);
                }
            }
        }
        this.write(this.dataConverter_.stringToByteArray(data), userSpaceOffset);
    }

    public void setMustUseSockets(boolean mustUseSockets) {
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'mustUseSockets' after connect.");
            throw new ExtendedIllegalStateException("mustUseSockets", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.mustUseSockets_ = mustUseSockets;
        } else {
            Boolean oldValue = this.mustUseSockets_;
            Boolean newValue = mustUseSockets;
            this.mustUseSockets_ = mustUseSockets;
            this.propertyChangeListeners_.firePropertyChange("mustUseSockets", oldValue, newValue);
        }
    }

    public boolean isMustUseSockets() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use sockets:", this.mustUseSockets_);
        }
        return this.mustUseSockets_;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

