/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.io.IOException;
import java.util.Date;

public class RQueuedMessage
extends Resource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
    private static final String ICON_BASE_NAME_ = "RQueuedMessage";
    private static final String PRESENTATION_KEY_ = "QUEUED_MESSAGE";
    static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "QUEUED_MESSAGE");
    public static final String ALERT_OPTION = "ALERT_OPTION";
    public static final String ALERT_OPTION_DEFER = "*DEFER";
    public static final String ALERT_OPTION_IMMEDIATE = "*IMMED";
    public static final String ALERT_OPTION_NO = "*NO";
    public static final String ALERT_OPTION_UNATTENDED = "*UNATTEND";
    public static final String DATE_SENT = "DATE_SENT";
    public static final String DEFAULT_REPLY = "DEFAULT_REPLY";
    public static final String MESSAGE_FILE = "MESSAGE_FILE";
    public static final String MESSAGE_HELP = "MESSAGE_HELP";
    public static final String MESSAGE_ID = "MESSAGE_ID";
    public static final String MESSAGE_KEY = "MESSAGE_KEY";
    public static final String MESSAGE_QUEUE = "MESSAGE_QUEUE";
    public static final String MESSAGE_SEVERITY = "MESSAGE_SEVERITY";
    public static final String MESSAGE_TEXT = "MESSAGE_TEXT";
    public static final String MESSAGE_TYPE = "MESSAGE_TYPE";
    public static final String REPLY_STATUS = "REPLY_STATUS";
    public static final String REPLY_STATUS_ACCEPTS_SENT = "A";
    public static final String REPLY_STATUS_ACCEPTS_NOT_SENT = "W";
    public static final String REPLY_STATUS_NOT_ACCEPT = "N";
    public static final String SENDER_JOB_NAME = "SENDER_JOB_NAME";
    public static final String SENDER_USER_NAME = "SENDER_USER_NAME";
    public static final String SENDER_JOB_NUMBER = "SENDER_JOB_NUMBER";
    public static final String SENDING_PROGRAM_NAME = "SENDING_PROGRAM_NAME";
    public static final String SUBSTITUTION_DATA = "SUBSTITUTION_DATA";

    public RQueuedMessage() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    static Object computeResourceKey(AS400 system, String containerName, byte[] messageKey) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(RQueuedMessage.class);
        buffer.append(':');
        buffer.append(system.getSystemName());
        buffer.append(':');
        buffer.append(system.getUserId());
        buffer.append(':');
        buffer.append(containerName);
        buffer.append(':');
        buffer.append(Presentation.bytesToHex(messageKey));
        return buffer.toString();
    }

    public void load(int helpTextFormatting) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        block6: {
            AS400 system = this.getSystem();
            String file = null;
            String library = null;
            String IFSPath = this.getAttributeValueAsString(MESSAGE_FILE);
            if (system == null || IFSPath == null) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "system or path is null in load()");
                }
                return;
            }
            try {
                QSYSObjectPathName path = new QSYSObjectPathName(IFSPath);
                library = path.getLibraryName();
                file = path.getObjectName();
                String ID = this.getAttributeValueAsString(MESSAGE_ID);
                byte[] substitutionData = (byte[])this.getAttributeValueAsObject(SUBSTITUTION_DATA);
                if (library == null || file == null || ID == null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "library, file or ID is null in load()");
                    }
                    return;
                }
                AS400Message result = null;
                MessageFile msgFile = new MessageFile(system, QSYSObjectPathName.toPath(library, file, "MSGF"));
                msgFile.setHelpTextFormatting(helpTextFormatting);
                result = msgFile.getMessage(ID, substitutionData);
                this.initializeAttributeValue(MESSAGE_HELP, result.getHelp());
            }
            catch (Exception e) {
                if (!Trace.isTraceOn()) break block6;
                Trace.log(2, "Exception getting help from message file in load()", (Throwable)e);
            }
        }
    }

    private Object getAttributeValueAsObject(Object attributeID) {
        try {
            return this.getAttributeValue(attributeID);
        }
        catch (ResourceException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error getting attribute value", (Throwable)e);
            }
            return null;
        }
    }

    private String getAttributeValueAsString(Object attributeID) {
        try {
            return (String)this.getAttributeValue(attributeID);
        }
        catch (ResourceException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error getting attribute value", (Throwable)e);
            }
            return null;
        }
    }

    static {
        attributes_.add(ALERT_OPTION, String.class, true, new String[]{ALERT_OPTION_DEFER, ALERT_OPTION_IMMEDIATE, ALERT_OPTION_NO, ALERT_OPTION_UNATTENDED, ""}, null, true);
        attributes_.add((Object)DATE_SENT, Date.class, true);
        attributes_.add((Object)DEFAULT_REPLY, String.class, true);
        attributes_.add((Object)MESSAGE_FILE, String.class, true);
        attributes_.add((Object)MESSAGE_HELP, String.class, true);
        attributes_.add((Object)MESSAGE_ID, String.class, true);
        attributes_.add((Object)MESSAGE_KEY, byte[].class, true);
        attributes_.add((Object)MESSAGE_QUEUE, String.class, true);
        attributes_.add((Object)MESSAGE_SEVERITY, Integer.class, true);
        attributes_.add((Object)MESSAGE_TEXT, String.class, true);
        attributes_.add(MESSAGE_TYPE, Integer.class, true, new Integer[]{1, 2, 4, 5, 6, 8, 10, 14, 15, 16, 17, 21, 22, 23, 24, 25}, null, true);
        attributes_.add(REPLY_STATUS, String.class, true, new String[]{REPLY_STATUS_ACCEPTS_SENT, REPLY_STATUS_ACCEPTS_NOT_SENT, REPLY_STATUS_NOT_ACCEPT}, null, true);
        attributes_.add((Object)SENDER_JOB_NAME, String.class, true);
        attributes_.add((Object)SENDER_USER_NAME, String.class, true);
        attributes_.add((Object)SENDER_JOB_NUMBER, String.class, true);
        attributes_.add((Object)SENDING_PROGRAM_NAME, String.class, true);
        attributes_.add((Object)SUBSTITUTION_DATA, byte[].class, true);
    }
}

