/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.CommTrace;
import com.ibm.as400.util.commtrace.Progress;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;

class Read
implements Runnable {
    private String rmtfile;
    private String lclfile;
    private AS400 sys;
    private CommTrace comm;
    private Progress pro;
    private Thread proThread;
    private Thread readThread_ = null;
    private int bytes = 0;
    private static final String CLASS = "Read";

    public Read(CommTrace comm, String rmtfile, String lclfile, AS400 sys) {
        this.comm = comm;
        this.rmtfile = rmtfile;
        this.lclfile = lclfile;
        this.sys = sys;
    }

    @Override
    public void run() {
        byte[] tmp = null;
        int len = 0;
        this.bytes = 0;
        Thread myThread = Thread.currentThread();
        while (this.readThread_ == myThread) {
            IFSFileInputStream file = null;
            BufferedOutputStream out = null;
            try {
                int selection;
                file = new IFSFileInputStream(this.sys, this.rmtfile);
                out = new BufferedOutputStream(new FileOutputStream(this.lclfile));
                this.pro = new Progress("Retrieving " + this.rmtfile, file.available(), " bytes");
                this.proThread = new Thread((Runnable)this.pro, "ProgDiag");
                this.proThread.start();
                int filesize = file.available();
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "Read.run() Transfer file size:" + filesize);
                }
                if ((selection = JOptionPane.showConfirmDialog(CommTrace.getMainFrame(), "Start transfer of " + this.rmtfile + "(" + filesize / 1024 + " KB)?", "Transfer", 0)) == 1) {
                    return;
                }
                if (selection == 0) {
                    byte[] data = new byte[4096];
                    while ((len = file.read(data)) != -1 && !this.pro.isCanceled() && this.readThread_ != null) {
                        tmp = new byte[len];
                        System.arraycopy(data, 0, tmp, 0, len);
                        out.write(tmp);
                        this.bytes += len;
                        this.pro.updateProgress(this.bytes);
                    }
                    if (this.pro.isCanceled() || this.readThread_ == null) {
                        file.close();
                        out.close();
                        File local = new File(this.lclfile);
                        if (local.exists()) {
                            local.delete();
                        }
                    }
                }
            }
            catch (IOException e) {
                CommTrace.error("File Error", "Error reading/writing file");
            }
            catch (AS400SecurityException e) {
                CommTrace.error("Security Error", "Security problem opening file");
            }
            if (!this.pro.isCanceled() && this.readThread_ != null) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "Read.run() Transfering completed");
                }
                JOptionPane.showMessageDialog(CommTrace.getMainFrame(), "Transfer of " + this.rmtfile + " completed", "Transfer Complete", 1);
            }
            this.readThread_ = null;
            try {
                file.close();
                out.close();
            }
            catch (IOException e) {
                CommTrace.error("File Error", "Error closing file");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getBytesRead() {
        return this.bytes;
    }

    public Thread getThread() {
        return this.readThread_;
    }

    public void setThread(Thread thread) {
        this.readThread_ = thread;
    }
}

