/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.AbstractVAction;
import com.ibm.as400.vaccess.QueuedMessageReplyAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

abstract class DialogAction
extends AbstractVAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String cancelText_ = ResourceLoader.getText("DLG_CANCEL");
    private static final String okText_ = ResourceLoader.getText("DLG_OK");
    private boolean dialogLocked_ = false;
    JDialog dialog = null;

    public DialogAction(VObject object) {
        super(object);
    }

    public abstract JComponent getInputComponent();

    @Override
    public void perform(VActionContext context) {
        String title = this.getText();
        JButton cancelButton = new JButton(cancelText_);
        JButton okButton = new JButton(okText_);
        okButton.setSelected(true);
        ActionListener_ actionListener = new ActionListener_(cancelButton, okButton);
        okButton.addActionListener(actionListener);
        cancelButton.addActionListener(actionListener);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JComponent component = null;
        try {
            component = this.getInputComponent();
        }
        catch (Exception e) {
            this.fireError(e);
            return;
        }
        this.dialog = new JDialog(context.getFrame(), title, false);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add("South", buttonPanel);
        this.dialog.getContentPane().add("Center", component);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.addWindowListener(new WindowListener_());
        this.dialog.show();
        if (this instanceof QueuedMessageReplyAction) {
            for (int i = 0; i < component.getComponentCount(); ++i) {
                if (!(component.getComponent(i) instanceof JTextField)) continue;
                component.getComponent(i).requestFocus();
                return;
            }
        }
    }

    public abstract void perform2();

    public void lockDialog() {
        this.dialogLocked_ = true;
    }

    private class WindowListener_
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent event) {
            DialogAction.this.dialog.dispose();
        }
    }

    private class ActionListener_
    implements ActionListener {
        private JButton cancelButton_;
        private JButton okButton_;

        public ActionListener_(JButton cancelButton, JButton okButton) {
            this.cancelButton_ = cancelButton;
            this.okButton_ = okButton;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this.cancelButton_) {
                DialogAction.this.dialog.dispose();
                return;
            }
            if (source == this.okButton_) {
                DialogAction.this.dialogLocked_ = false;
                try {
                    DialogAction.this.perform2();
                    DialogAction.this.fireObjectChanged();
                    if (!DialogAction.this.dialogLocked_) {
                        DialogAction.this.dialog.dispose();
                    }
                }
                catch (Exception e) {
                    DialogAction.this.fireError(e);
                }
            }
        }
    }
}

