/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.DataQueueListener;
import com.ibm.as400.access.KeyedDataQueue;
import com.ibm.as400.access.KeyedDataQueueEntry;
import com.ibm.as400.vaccess.DataQueueEventSupport;
import com.ibm.as400.vaccess.DocumentEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.UndoableEditEventSupport;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public class KeyedDataQueueDocument
implements Document,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private KeyedDataQueue dataQueue_ = null;
    private transient PlainDocument document_;
    private transient DocumentEventSupport documentEventSupport_;
    private transient DataQueueEventSupport dataQueueEventSupport_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient UndoableEditEventSupport undoableEditEventSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public KeyedDataQueueDocument() {
        this.dataQueue_ = new KeyedDataQueue();
        this.initializeTransient();
    }

    public KeyedDataQueueDocument(AS400 system, String path) {
        this.dataQueue_ = new KeyedDataQueue(system, path);
        this.initializeTransient();
    }

    public void addDataQueueListener(DataQueueListener listener) {
        this.dataQueueEventSupport_.addDataQueueListener(listener);
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.documentEventSupport_.addDocumentListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.undoableEditEventSupport_.addUndoableEditListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    @Override
    public synchronized Position createPosition(int offset) throws BadLocationException {
        return this.document_.createPosition(offset);
    }

    @Override
    public synchronized Element getDefaultRootElement() {
        return this.document_.getDefaultRootElement();
    }

    @Override
    public synchronized Position getEndPosition() {
        return this.document_.getEndPosition();
    }

    @Override
    public synchronized int getLength() {
        return this.document_.getLength();
    }

    public String getPath() {
        return this.dataQueue_.getPath();
    }

    @Override
    public synchronized Object getProperty(Object key) {
        return this.document_.getProperty(key);
    }

    @Override
    public synchronized Element[] getRootElements() {
        return this.document_.getRootElements();
    }

    @Override
    public synchronized Position getStartPosition() {
        return this.document_.getStartPosition();
    }

    public AS400 getSystem() {
        return this.dataQueue_.getSystem();
    }

    @Override
    public synchronized String getText(int offset, int length) throws BadLocationException {
        return this.document_.getText(offset, length);
    }

    @Override
    public synchronized void getText(int offset, int length, Segment text) throws BadLocationException {
        this.document_.getText(offset, length, text);
    }

    private void initializeTransient() {
        this.document_ = new PlainDocument();
        this.dataQueueEventSupport_ = new DataQueueEventSupport(this);
        this.documentEventSupport_ = new DocumentEventSupport(this);
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.undoableEditEventSupport_ = new UndoableEditEventSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.document_.addDocumentListener(this.documentEventSupport_);
        this.document_.addUndoableEditListener(this.undoableEditEventSupport_);
        this.dataQueue_.addDataQueueListener(this.dataQueueEventSupport_);
    }

    @Override
    public synchronized void insertString(int offset, String text, AttributeSet attributes) throws BadLocationException {
        this.document_.insertString(offset, text, attributes);
    }

    public void peek(String key) {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.document_.remove(0, this.document_.getLength());
            KeyedDataQueueEntry entry = this.dataQueue_.peek(key);
            String contents = entry != null ? entry.getString() : "";
            this.document_.insertString(0, contents, null);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void peek(String key, int wait, String searchType) {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.document_.remove(0, this.document_.getLength());
            KeyedDataQueueEntry entry = this.dataQueue_.peek(key, wait, searchType);
            String contents = entry != null ? entry.getString() : "";
            this.document_.insertString(0, contents, null);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    @Override
    public synchronized void putProperty(Object key, Object value) {
        this.document_.putProperty(key, value);
    }

    public void read(String key) {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.document_.remove(0, this.document_.getLength());
            KeyedDataQueueEntry entry = this.dataQueue_.read(key);
            String contents = entry != null ? entry.getString() : "";
            this.document_.insertString(0, contents, null);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void read(String key, int wait, String searchType) {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.document_.remove(0, this.document_.getLength());
            KeyedDataQueueEntry entry = this.dataQueue_.read(key, wait, searchType);
            String contents = entry != null ? entry.getString() : "";
            this.document_.insertString(0, contents, null);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public synchronized void remove(int offset, int length) throws BadLocationException {
        this.document_.remove(offset, length);
    }

    public void removeDataQueueListener(DataQueueListener listener) {
        this.dataQueueEventSupport_.removeDataQueueListener(listener);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.documentEventSupport_.removeDocumentListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoableEditEventSupport_.removeUndoableEditListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    @Override
    public void render(Runnable runnable) {
        this.document_.render(runnable);
    }

    public void setPath(String path) throws PropertyVetoException {
        String oldValue = this.dataQueue_.getPath();
        String newValue = path;
        this.vetoableChangeSupport_.fireVetoableChange("path", oldValue, newValue);
        this.dataQueue_.setPath(newValue);
        this.propertyChangeSupport_.firePropertyChange("path", oldValue, newValue);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        AS400 oldValue = this.dataQueue_.getSystem();
        AS400 newValue = system;
        this.vetoableChangeSupport_.fireVetoableChange("system", oldValue, newValue);
        this.dataQueue_.setSystem(system);
        this.propertyChangeSupport_.firePropertyChange("system", oldValue, newValue);
    }

    public void write(String key) {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.dataQueue_.write(key, this.document_.getText(0, this.document_.getLength()));
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }
}

