/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JavaApplicationCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VJavaGetResult;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VJavaApplicationCall
extends JComponent
implements KeyListener {
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    private JavaApplicationCall javaAppCall_ = null;
    private String classPath_ = "";
    private Vector inputVector_;
    private int inputIndex_ = 0;
    private String inputStr_;
    private JTextField inputText_;
    private JScrollPane scrollPane_;
    private boolean javaRunOver_ = true;
    private String[] optionArray_ = new String[]{"*NONE"};
    private JTextArea outputText_;
    private int paramNum_;
    private StringTokenizer strToken_;
    private VJavaGetResult vJavaGetResult_;
    private boolean hasNext = false;
    private boolean hasPrevious = false;
    private boolean firstDraw = true;
    private long linesWritten_ = 0L;
    private static final int ROWS = 24;
    private static final int COLUMNS = 72;

    public VJavaApplicationCall() {
        this.initialize();
    }

    public VJavaApplicationCall(JavaApplicationCall javaApplicationCall) {
        if (javaApplicationCall == null) {
            throw new NullPointerException("JavaApplicationCall");
        }
        this.javaAppCall_ = javaApplicationCall;
        this.initialize();
    }

    public void addErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.inputText_.requestFocus();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.addWorkingListener(listener);
    }

    void appendOutput(String output) {
        this.outputText_.append(output);
        ++this.linesWritten_;
        int tx = this.outputText_.getSize().width;
        int ty = this.outputText_.getSize().height;
        Rectangle rect = new Rectangle(0, ty - 2, tx - 1, ty - 1);
        if (this.linesWritten_ < 24L) {
            int visableLines;
            int pixelsPerLine = ty / 24;
            if (pixelsPerLine > 0 && this.linesWritten_ > (long)(visableLines = this.scrollPane_.getSize().height / pixelsPerLine)) {
                this.outputText_.scrollRectToVisible(rect);
            }
        } else if (ty > this.scrollPane_.getSize().height) {
            this.outputText_.scrollRectToVisible(rect);
        }
    }

    protected void finalize() throws Throwable {
        this.vJavaGetResult_ = null;
        super.finalize();
    }

    public JavaApplicationCall getJavaApplicationCall() {
        return this.javaAppCall_;
    }

    public JTextArea getOutputText() {
        return this.outputText_;
    }

    private void initialize() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.inputVector_ = new Vector();
        this.setLayout(new BorderLayout());
        JPanel part1 = new JPanel(new BorderLayout());
        JLabel outputLabel = new JLabel(ResourceLoader.getText("REMOTE_OUTPUT_LABEL"));
        JLabel inputLabel = new JLabel(ResourceLoader.getText("REMOTE_INPUT_LABEL"));
        this.outputText_ = new JTextArea();
        this.outputText_.setEditable(false);
        this.outputText_.setRows(24);
        this.outputText_.setColumns(72);
        this.scrollPane_ = new JScrollPane(this.outputText_);
        this.scrollPane_.setVerticalScrollBarPolicy(20);
        this.inputText_ = new JTextField();
        part1.add((Component)outputLabel, "North");
        part1.add((Component)this.scrollPane_, "Center");
        JPanel part2 = new JPanel(new BorderLayout());
        part2.add((Component)inputLabel, "North");
        part2.add((Component)this.inputText_, "Center");
        this.add((Component)part1, "Center");
        this.add((Component)part2, "South");
        this.inputText_.addKeyListener(this);
        this.appendOutput(ResourceLoader.getText("REMOTE_PROMPT"));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.javaAppCall_ == null) {
            throw new ExtendedIllegalStateException("JavaApplicationCall", 4);
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.processEnter();
                break;
            }
            case 34: {
                if (this.inputVector_.size() <= 0) break;
                this.inputIndex_ = this.inputVector_.size() - 1;
                this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                break;
            }
            case 33: {
                if (this.inputVector_.size() <= 0) break;
                this.inputIndex_ = 0;
                this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                break;
            }
            case 38: {
                if (this.inputVector_.size() <= 0) break;
                if (this.hasPrevious) {
                    if (this.inputIndex_ > 0) {
                        --this.inputIndex_;
                    }
                    this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                } else {
                    this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                }
                this.hasPrevious = true;
                this.hasNext = true;
                break;
            }
            case 40: {
                if (this.inputVector_.size() <= 0 || !this.hasNext) break;
                if (this.inputIndex_ < this.inputVector_.size() - 1) {
                    ++this.inputIndex_;
                }
                this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                this.hasPrevious = true;
                break;
            }
            case 27: {
                this.inputText_.setText("");
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void load() {
        if (this.vJavaGetResult_ == null) {
            this.vJavaGetResult_ = new VJavaGetResult(this);
        }
        try {
            this.javaAppCall_.getSystem().connectService(2);
        }
        catch (Exception e) {
            this.appendOutput(e.toString() + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            return;
        }
        this.appendOutput(ResourceLoader.getText("REMOTE_JAVA_START"));
        this.appendOutput(this.javaAppCall_.getJavaApplication() + "\n\n");
        this.vJavaGetResult_.play();
    }

    private void processDCommand() {
        if (this.paramNum_ > 1) {
            this.appendOutput(ResourceLoader.getText("REMOTE_COMMAND_ERROR") + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        } else {
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE1") + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE2"));
            this.appendOutput(this.javaAppCall_.getSecurityCheckLevel() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE3"));
            this.appendOutput(this.classPath_ + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE4"));
            this.appendOutput(this.javaAppCall_.getGarbageCollectionFrequency() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE5"));
            this.appendOutput(this.javaAppCall_.getGarbageCollectionInitialSize() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE6"));
            this.appendOutput(this.javaAppCall_.getGarbageCollectionMaximumSize() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE7"));
            this.appendOutput(this.javaAppCall_.getGarbageCollectionPriority() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE8"));
            this.appendOutput(this.javaAppCall_.getInterpret() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE9"));
            this.appendOutput(this.javaAppCall_.getOptimization() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE10"));
            StringBuffer optionStr = new StringBuffer();
            for (int i = 0; i < this.optionArray_.length; ++i) {
                optionStr.append(this.optionArray_[i]);
                optionStr.append(" ");
            }
            this.appendOutput(optionStr.toString() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE11"));
            this.appendOutput(this.javaAppCall_.getDefaultPort() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE12"));
            this.appendOutput(this.javaAppCall_.isFindPort() + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        }
    }

    void processEnter() {
        if (this.javaAppCall_ == null) {
            throw new ExtendedIllegalStateException("JavaApplicationCall", 4);
        }
        if (this.javaRunOver_) {
            if (this.inputText_.getText().trim().equals("")) {
                this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            } else {
                if (this.inputVector_.size() > 0) {
                    int tempIndex = this.inputIndex_;
                    int vectorSize = this.inputVector_.size();
                    String lastInput = (String)this.inputVector_.lastElement();
                    String currentInput = (String)this.inputVector_.elementAt(tempIndex);
                    if (!lastInput.equalsIgnoreCase(this.inputText_.getText())) {
                        this.inputVector_.addElement(this.inputText_.getText());
                    }
                    this.hasNext = false;
                    this.hasPrevious = false;
                    vectorSize = this.inputVector_.size();
                    this.inputIndex_ = vectorSize - 1;
                    if (tempIndex < vectorSize - 1 && this.inputText_.getText().equals(currentInput)) {
                        this.inputIndex_ = tempIndex;
                        this.hasNext = true;
                    }
                } else {
                    this.inputVector_.addElement(this.inputText_.getText());
                    this.inputIndex_ = 0;
                    this.hasNext = false;
                    this.hasPrevious = false;
                }
                this.appendOutput(this.inputText_.getText() + "\n");
                this.inputStr_ = this.inputText_.getText().trim();
                this.inputText_.setText("");
                this.strToken_ = new StringTokenizer(this.inputStr_, " ");
                this.paramNum_ = this.strToken_.countTokens();
                String commandStr = this.strToken_.nextToken().toUpperCase();
                if (commandStr.equals("JAVA")) {
                    this.processJavaCommand();
                } else if (commandStr.equals("D")) {
                    this.processDCommand();
                } else if (commandStr.equals("SET")) {
                    this.processSetCommand();
                } else if (commandStr.equals("HELP") || commandStr.equals("?") || commandStr.equals("H")) {
                    this.processHelpCommand();
                } else if (commandStr.equals("QUIT") || commandStr.equals("Q")) {
                    if (this.paramNum_ > 1) {
                        this.appendOutput(ResourceLoader.getText("REMOTE_COMMAND_ERROR") + "\n");
                        this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
                    } else {
                        System.exit(0);
                    }
                } else {
                    this.appendOutput(ResourceLoader.getText("REMOTE_COMMAND_ERROR") + "\n");
                    this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
                }
            }
        } else {
            this.appendOutput(this.inputText_.getText() + "\n");
            this.inputStr_ = this.inputText_.getText();
            this.inputText_.setText("");
            this.javaAppCall_.sendStandardInString(this.inputStr_);
        }
    }

    private void processHelpCommand() {
        if (this.paramNum_ > 1) {
            this.appendOutput(ResourceLoader.getText("REMOTE_COMMAND_ERROR") + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        } else {
            this.appendOutput(ResourceLoader.getText("REMOTE_HELP"));
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        }
    }

    private void processJavaCommand() {
        Properties prop = new Properties();
        String javaAppName = "";
        String classPath = "";
        Vector param = new Vector();
        if (this.paramNum_ == 1) {
            this.appendOutput(ResourceLoader.getText("REMOTE_JAVA_ERROR") + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        } else {
            int javaIndex;
            Vector<String> cmdVector = new Vector<String>();
            while (this.strToken_.hasMoreTokens()) {
                cmdVector.addElement(this.strToken_.nextToken());
            }
            int vectorSize = cmdVector.size();
            boolean findJavaApp = false;
            for (javaIndex = 0; javaIndex < vectorSize; ++javaIndex) {
                if (((String)cmdVector.elementAt(javaIndex)).startsWith("-")) continue;
                javaAppName = (String)cmdVector.elementAt(javaIndex);
                findJavaApp = true;
                break;
            }
            if (findJavaApp) {
                int i;
                boolean findError = false;
                boolean findClassPath = false;
                boolean findVerbose = false;
                boolean findProperty = false;
                for (i = 0; i < javaIndex; ++i) {
                    if (((String)cmdVector.elementAt(i)).toUpperCase().startsWith("-CLASSPATH")) {
                        if (!findClassPath) {
                            findClassPath = true;
                            String propertyValue = (String)cmdVector.elementAt(i);
                            int index = propertyValue.indexOf("=");
                            if (index > 0 && index + 1 < propertyValue.length()) {
                                classPath = propertyValue.substring(index + 1);
                                continue;
                            }
                            findError = true;
                            break;
                        }
                        findError = true;
                        break;
                    }
                    if (((String)cmdVector.elementAt(i)).toUpperCase().startsWith("-D")) {
                        String tempStr = (String)cmdVector.elementAt(i);
                        String propStr = tempStr.substring(2);
                        StringTokenizer propToken = new StringTokenizer(propStr, "=");
                        if (propToken.countTokens() < 2) {
                            findError = true;
                            break;
                        }
                        String propKey = propToken.nextToken();
                        String propertyValue = (String)cmdVector.elementAt(i);
                        int index = propertyValue.indexOf("=");
                        String propValue = propertyValue.substring(index + 1);
                        prop.put(propKey, propValue);
                        findProperty = true;
                        continue;
                    }
                    if (((String)cmdVector.elementAt(i)).toUpperCase().startsWith("-VERBOSE")) {
                        if (!findVerbose) {
                            findVerbose = true;
                            continue;
                        }
                        findError = true;
                        break;
                    }
                    findError = true;
                    break;
                }
                boolean findParam = false;
                for (i = javaIndex + 1; i < vectorSize && !findError; ++i) {
                    findParam = true;
                    param.addElement(cmdVector.elementAt(i));
                }
                if (!findError) {
                    try {
                        this.javaAppCall_.setJavaApplication(javaAppName);
                        if (findParam) {
                            String[] paramArray = new String[param.size()];
                            for (int j = 0; j < param.size(); ++j) {
                                paramArray[j] = (String)param.elementAt(j);
                            }
                            this.javaAppCall_.setParameters(paramArray);
                        }
                        if (findProperty) {
                            this.javaAppCall_.setProperties(prop);
                        }
                        if (findClassPath) {
                            this.javaAppCall_.setClassPath(classPath);
                        } else {
                            this.javaAppCall_.setClassPath(this.classPath_);
                        }
                        if (findVerbose) {
                            String[] tempArray = new String[]{"*VERBOSE"};
                            this.javaAppCall_.setOptions(tempArray);
                        } else {
                            this.javaAppCall_.setOptions(this.optionArray_);
                        }
                        this.load();
                    }
                    catch (Exception e) {
                        this.appendOutput(e + "\n");
                        this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
                    }
                } else {
                    this.appendOutput(ResourceLoader.getText("REMOTE_JAVA_ERROR") + "\n");
                    this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
                }
            } else {
                this.appendOutput(ResourceLoader.getText("REMOTE_JAVA_ERROR") + "\n");
                this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            }
        }
    }

    private void processSetCommand() {
        if (this.paramNum_ == 1) {
            this.processDCommand();
        } else {
            String tempStr = this.inputStr_;
            String propertyName = null;
            String propertyValue = null;
            int beginIndex = tempStr.toUpperCase().indexOf("SET");
            String setString = this.inputStr_.substring(beginIndex + 4).trim();
            StringTokenizer setStringToken = new StringTokenizer(setString, "=");
            int setNum = setStringToken.countTokens();
            if (setNum == 1) {
                this.appendOutput(ResourceLoader.getText("REMOTE_SET_ERROR") + "\n");
                this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            } else {
                propertyName = setStringToken.nextToken().toUpperCase().trim();
                propertyValue = setStringToken.nextToken().trim();
                try {
                    if (propertyName.equals("SECURITYCHECKLEVEL")) {
                        this.javaAppCall_.setSecurityCheckLevel(propertyValue);
                    } else if (propertyName.equals("CLASSPATH")) {
                        int index = setString.indexOf("=");
                        String classStr = setString.substring(index + 1).trim();
                        this.javaAppCall_.setClassPath(classStr);
                        this.classPath_ = classStr;
                    } else if (propertyName.equals("GARBAGECOLLECTIONFREQUENCY")) {
                        this.javaAppCall_.setGarbageCollectionFrequency(Integer.valueOf(propertyValue));
                    } else if (propertyName.equals("GARBAGECOLLECTIONINITIALSIZE")) {
                        this.javaAppCall_.setGarbageCollectionInitialSize(Integer.valueOf(propertyValue));
                    } else if (propertyName.equals("GARBAGECOLLECTIONMAXIMUMSIZE")) {
                        this.javaAppCall_.setGarbageCollectionMaximumSize(propertyValue);
                    } else if (propertyName.equals("GARBAGECOLLECTIONPRIORITY")) {
                        this.javaAppCall_.setGarbageCollectionPriority(Integer.valueOf(propertyValue));
                    } else if (propertyName.equals("INTERPRET")) {
                        this.javaAppCall_.setInterpret(propertyValue);
                    } else if (propertyName.equals("OPTIMIZE")) {
                        this.javaAppCall_.setOptimization(propertyValue);
                    } else if (propertyName.equals("OPTION")) {
                        StringTokenizer optionToken = new StringTokenizer(propertyValue, " ");
                        String[] tempArray = new String[optionToken.countTokens()];
                        int j = 0;
                        while (optionToken.hasMoreTokens()) {
                            tempArray[j] = optionToken.nextToken().toUpperCase();
                            ++j;
                        }
                        this.javaAppCall_.setOptions(tempArray);
                        this.optionArray_ = new String[tempArray.length];
                        System.arraycopy(tempArray, 0, this.optionArray_, 0, tempArray.length);
                    } else if (propertyName.equals("DEFAULTPORT")) {
                        this.javaAppCall_.setDefaultPort(Integer.valueOf(propertyValue));
                    } else if (propertyName.equals("FINDPORT")) {
                        if (propertyValue.toUpperCase().equals("TRUE") || propertyValue.toUpperCase().equals("FALSE")) {
                            this.javaAppCall_.setFindPort(Boolean.valueOf(propertyValue));
                        } else {
                            this.appendOutput(ResourceLoader.getText("REMOTE_PORT_VALUE_ERROR") + "\n");
                        }
                    } else {
                        this.appendOutput(ResourceLoader.getText("REMOTE_PROPERTY_ERROR_HEAD") + propertyName + ResourceLoader.getText("REMOTE_PROPERTY_ERROR_END") + "\n");
                    }
                }
                catch (Exception e1) {
                    this.appendOutput(e1.toString() + "\n");
                    Trace.log(2, e1.toString());
                }
                this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            }
        }
    }

    public void removeErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("ErrorListener");
        }
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setJavaApplicationCall(JavaApplicationCall javaApplicationCall) throws PropertyVetoException {
        if (javaApplicationCall == null) {
            throw new NullPointerException("JavaApplicationCall");
        }
        this.javaAppCall_ = javaApplicationCall;
    }

    void setJavaAppRunOver(boolean value) {
        this.javaRunOver_ = value;
    }
}

