/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.auth;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class TokenFromOAuth1Result {
    @Nonnull
    protected final String oauth2Token;

    public TokenFromOAuth1Result(@Nonnull String oauth2Token) {
        if (oauth2Token == null) {
            throw new IllegalArgumentException("Required value for 'oauth2Token' is null");
        }
        if (oauth2Token.length() < 1) {
            throw new IllegalArgumentException("String 'oauth2Token' is shorter than 1");
        }
        this.oauth2Token = oauth2Token;
    }

    @Nonnull
    public String getOauth2Token() {
        return this.oauth2Token;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.oauth2Token});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TokenFromOAuth1Result other = (TokenFromOAuth1Result)obj;
            return this.oauth2Token == other.oauth2Token || this.oauth2Token.equals(other.oauth2Token);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TokenFromOAuth1Result> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TokenFromOAuth1Result value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("oauth2_token");
            StoneSerializers.string().serialize(value.oauth2Token, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TokenFromOAuth1Result deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_oauth2Token;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_oauth2Token = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("oauth2_token".equals(field)) {
                        f_oauth2Token = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_oauth2Token == null) {
                    throw new JsonParseException(p, "Required field \"oauth2_token\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TokenFromOAuth1Result value = new TokenFromOAuth1Result(f_oauth2Token);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

