/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.dom.TypeInfoImpl;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementOverNodeInfo
extends NodeOverNodeInfo
implements Element {
    public String getTagName() {
        return this.node.getDisplayName();
    }

    public NodeList getElementsByTagName(String string) {
        return DocumentOverNodeInfo.getElementsByTagName(this.node, string);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) throws DOMException {
        return DocumentOverNodeInfo.getElementsByTagNameNS(this.node, string, string2);
    }

    public String getAttribute(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.node.iterateAxis((byte)2);
        do {
            if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
            return "";
        } while (!nodeInfo.getDisplayName().equals(string));
        String string2 = nodeInfo.getStringValue();
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public Attr getAttributeNode(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.node.iterateAxis((byte)2);
        do {
            if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
            return null;
        } while (!nodeInfo.getDisplayName().equals(string));
        return (Attr)nodeInfo;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    public void removeAttribute(String string) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    public String getAttributeNS(String string, String string2) {
        String string3 = Navigator.getAttributeValue((NodeInfo)this.node, (String)(string == null ? "" : string), (String)string2);
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        NamePool namePool = this.node.getNamePool();
        int n = namePool.getFingerprint(string == null ? "" : string, string2);
        if (n == -1) {
            return null;
        }
        NameTest nameTest = new NameTest(2, n, namePool);
        AxisIterator axisIterator = this.node.iterateAxis((byte)2, (NodeTest)nameTest);
        return (Attr)((Object)ElementOverNodeInfo.wrap((NodeInfo)axisIterator.next()));
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    public boolean hasAttribute(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.node.iterateAxis((byte)2);
        do {
            if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
            return false;
        } while (!nodeInfo.getDisplayName().equals(string));
        return true;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return Navigator.getAttributeValue((NodeInfo)this.node, (String)(string == null ? "" : string), (String)string2) != null;
    }

    public void setIdAttribute(String string, boolean bl) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public TypeInfo getSchemaTypeInfo() {
        int n = this.node.getTypeAnnotation();
        if (n == -1) {
            return null;
        }
        Configuration configuration = this.node.getConfiguration();
        return new TypeInfoImpl(configuration, configuration.getSchemaType(n));
    }
}

