/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Consumer;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethodsIf;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CountingReadableByteChannel
implements ReadableByteChannel {
    private final @UnknownKeyFor @NonNull @Initialized ReadableByteChannel delegate;
    private final @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Integer> bytesReadConsumer;

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized CountingReadableByteChannel createWithNoOpConsumer(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel delegate) {
        return new CountingReadableByteChannel(delegate, __ -> {});
    }

    public CountingReadableByteChannel(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel delegate, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Integer> bytesReadConsumer) {
        this.delegate = (ReadableByteChannel)Preconditions.checkNotNull((Object)delegate);
        this.bytesReadConsumer = (Consumer)Preconditions.checkNotNull(bytesReadConsumer);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized ByteBuffer dst) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int bytesRead = this.delegate.read(dst);
        if (bytesRead > 0) {
            this.bytesReadConsumer.accept(bytesRead);
        }
        return bytesRead;
    }

    @Override
    @EnsuresCalledMethodsIf(expression={"this"}, result=false, methods={"close"})
    public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.delegate.close();
    }
}

