/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.util.ByteBuddyUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowCoderGenerator {
    private static final @UnknownKeyFor @NonNull @Initialized ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final @UnknownKeyFor @NonNull @Initialized BitSetCoder NULL_LIST_CODER = BitSetCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized VarIntCoder VAR_INT_CODER = VarIntCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized BitSet EMPTY_BIT_SET = new BitSet(0);
    private static final @UnknownKeyFor @NonNull @Initialized String CODERS_FIELD_NAME = "FIELD_CODERS";
    private static final @UnknownKeyFor @NonNull @Initialized String POSITIONS_FIELD_NAME = "FIELD_ENCODING_POSITIONS";
    @GuardedBy(value="cacheLock")
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized WithStackTrace<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row>>> GENERATED_CODERS = Maps.newHashMap();
    @GuardedBy(value="cacheLock")
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized WithStackTrace<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer>>> ENCODING_POSITION_OVERRIDES = Maps.newHashMap();
    private static final @UnknownKeyFor @NonNull @Initialized Object cacheLock = new Object();
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(RowCoderGenerator.class);

    private static @UnknownKeyFor @NonNull @Initialized String getStackTrace() {
        return StringUtils.arrayToNewlines(Thread.currentThread().getStackTrace(), 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overrideEncodingPositions(@UnknownKeyFor @NonNull @Initialized UUID uuid, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> encodingPositions) {
        String stackTrace = RowCoderGenerator.getStackTrace();
        Object object = cacheLock;
        synchronized (object) {
            WithStackTrace<Map<String, Integer>> previousEncodingPositions = ENCODING_POSITION_OVERRIDES.put(uuid, new WithStackTrace<Map<String, Integer>>(encodingPositions, stackTrace));
            WithStackTrace<Coder<Row>> existingCoder = GENERATED_CODERS.get(uuid);
            if (previousEncodingPositions == null) {
                if (existingCoder != null) {
                    LOG.error("Received encoding positions for uuid {} too late after creating RowCoder. Created: {}\n Override: {}", new Object[]{uuid, existingCoder.getStackTrace(), stackTrace});
                } else {
                    LOG.info("Received encoding positions {} for uuid {}.", encodingPositions, (Object)uuid);
                }
            } else if (!previousEncodingPositions.getValue().equals(encodingPositions)) {
                if (existingCoder == null) {
                    LOG.error("Received differing encoding positions for uuid {} before coder creation. Was {} at {}\n Now {} at {}", new Object[]{uuid, previousEncodingPositions.getValue(), encodingPositions, previousEncodingPositions.getStackTrace(), stackTrace});
                } else {
                    LOG.error("Received differing encoding positions for uuid {} after coder creation at {}\n. Was {} at {}\n Now {} at {}\n", new Object[]{uuid, existingCoder.getStackTrace(), previousEncodingPositions.getValue(), encodingPositions, previousEncodingPositions.getStackTrace(), stackTrace});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearRowCoderCache() {
        Object object = cacheLock;
        synchronized (object) {
            GENERATED_CODERS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row> generate(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        String stackTrace = RowCoderGenerator.getStackTrace();
        UUID uuid = (UUID)Preconditions.checkNotNull((Object)schema.getUUID());
        Object object = cacheLock;
        synchronized (object) {
            Coder rowCoder;
            WithStackTrace<Coder<Row>> existingRowCoder = GENERATED_CODERS.get(uuid);
            if (existingRowCoder != null) {
                return existingRowCoder.getValue();
            }
            TypeDescription.Generic coderType = TypeDescription.Generic.Builder.parameterizedType(Coder.class, (Type[])new Type[]{Row.class}).build();
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.subclass((TypeDefinition)coderType);
            builder = RowCoderGenerator.implementMethods(schema, (DynamicType.Builder<Coder>)builder);
            int[] encodingPosToRowIndex = new int[schema.getFieldCount()];
            WithStackTrace<Map<String, Integer>> existingEncodingPositions = ENCODING_POSITION_OVERRIDES.get(uuid);
            Map<String, Integer> encodingPositions = existingEncodingPositions == null ? schema.getEncodingPositions() : existingEncodingPositions.getValue();
            int recordIndex = 0;
            while (recordIndex < schema.getFieldCount()) {
                String name = schema.getField(recordIndex).getName();
                int encodingPosition = encodingPositions.get(name);
                encodingPosToRowIndex[encodingPosition] = recordIndex++;
            }
            Preconditions.checkState(((long)schema.getFieldCount() == Arrays.stream(encodingPosToRowIndex).distinct().count() ? 1 : 0) != 0);
            Coder[] componentCoders = new Coder[schema.getFieldCount()];
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                int rowIndex = encodingPosToRowIndex[i];
                componentCoders[i] = SchemaCoder.coderForFieldType(schema.getField(rowIndex).getType().withNullable(false));
            }
            builder = builder.defineField(CODERS_FIELD_NAME, Coder[].class, new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.FINAL}).defineField(POSITIONS_FIELD_NAME, int[].class, new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.FINAL}).defineConstructor(1).withParameters(new Type[]{Coder[].class, int[].class}).intercept((Implementation)new GeneratedCoderConstructor());
            try {
                rowCoder = (Coder)builder.make().load(ReflectHelpers.findClassLoader(Coder.class.getClassLoader()), ByteBuddyUtils.getClassLoadingStrategy(Coder.class)).getLoaded().getDeclaredConstructor(Coder[].class, int[].class).newInstance(componentCoders, encodingPosToRowIndex);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to generate coder for schema " + schema, e);
            }
            GENERATED_CODERS.put(uuid, new WithStackTrace<Coder>(rowCoder, stackTrace));
            LOG.debug("Created row coder for uuid {} with encoding positions {} at {}", new Object[]{uuid, encodingPositions, stackTrace});
            return rowCoder;
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DynamicType.Builder<@UnknownKeyFor @NonNull @Initialized Coder> implementMethods(@UnknownKeyFor @NonNull @Initialized Schema schema, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DynamicType.Builder<@UnknownKeyFor @NonNull @Initialized Coder> builder) {
        boolean hasNullableFields = schema.getFields().stream().map(Schema.Field::getType).anyMatch(Schema.FieldType::getNullable);
        return builder.defineMethod("getSchema", Schema.class, new ModifierContributor.ForMethod[]{Visibility.PRIVATE, Ownership.STATIC}).intercept((Implementation)FixedValue.reference((Object)schema)).defineMethod("hasNullableFields", Boolean.TYPE, new ModifierContributor.ForMethod[]{Visibility.PRIVATE, Ownership.STATIC}).intercept((Implementation)FixedValue.reference((Object)hasNullableFields)).method((ElementMatcher)ElementMatchers.named((String)"encode")).intercept((Implementation)new EncodeInstruction()).method((ElementMatcher)ElementMatchers.named((String)"decode")).intercept((Implementation)new DecodeInstruction());
    }

    private static class DecodeInstruction
    implements Implementation {
        static final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TypeDescription.ForLoadedType LOADED_TYPE = new TypeDescription.ForLoadedType(DecodeInstruction.class);

        private DecodeInstruction() {
        }

        public @UnknownKeyFor @NonNull @Initialized ByteCodeAppender appender(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                StackManipulation.Compound manipulation = new StackManipulation.Compound(new StackManipulation[]{MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)implementationContext.getInstrumentedType().getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"getSchema"))).getOnly())), MethodVariableAccess.loadThis(), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)RowCoderGenerator.CODERS_FIELD_NAME))).getOnly())).read(), MethodVariableAccess.loadThis(), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)RowCoderGenerator.POSITIONS_FIELD_NAME))).getOnly())).read(), MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)LOADED_TYPE.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.named((String)"decodeDelegate")))).getOnly())), MethodReturn.REFERENCE});
                StackManipulation.Size size = manipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }

        public @UnknownKeyFor @NonNull @Initialized InstrumentedType prepare(@UnknownKeyFor @NonNull @Initialized InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        static @UnknownKeyFor @NonNull @Initialized Row decodeDelegate(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] encodingPosToIndex, @UnknownKeyFor @NonNull @Initialized InputStream inputStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int rowIndex;
            int encodingPos;
            int fieldCount = VAR_INT_CODER.decode(inputStream);
            BitSet nullFields = NULL_LIST_CODER.decode(inputStream);
            Object[] fieldValues = new Object[coders.length];
            for (encodingPos = 0; encodingPos < fieldCount; ++encodingPos) {
                if (encodingPos >= coders.length) continue;
                rowIndex = encodingPosToIndex[encodingPos];
                if (nullFields.get(encodingPos)) {
                    fieldValues[rowIndex] = null;
                    continue;
                }
                Object fieldValue = coders[encodingPos].decode(inputStream);
                fieldValues[rowIndex] = fieldValue;
            }
            for (encodingPos = fieldCount; encodingPos < coders.length; ++encodingPos) {
                rowIndex = encodingPosToIndex[encodingPos];
                fieldValues[rowIndex] = null;
            }
            return Row.withSchema(schema).attachValues(fieldValues);
        }
    }

    private static class EncodeInstruction
    implements Implementation {
        static final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TypeDescription.ForLoadedType LOADED_TYPE = new TypeDescription.ForLoadedType(EncodeInstruction.class);

        private EncodeInstruction() {
        }

        public @UnknownKeyFor @NonNull @Initialized ByteCodeAppender appender(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                StackManipulation.Compound manipulation = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.loadThis(), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)RowCoderGenerator.CODERS_FIELD_NAME))).getOnly())).read(), MethodVariableAccess.loadThis(), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)RowCoderGenerator.POSITIONS_FIELD_NAME))).getOnly())).read(), MethodVariableAccess.REFERENCE.loadFrom(1), MethodVariableAccess.REFERENCE.loadFrom(2), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)implementationContext.getInstrumentedType().getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"hasNullableFields"))).getOnly())), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)LOADED_TYPE.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.named((String)"encodeDelegate")))).getOnly())), MethodReturn.VOID});
                StackManipulation.Size size = manipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }

        public @UnknownKeyFor @NonNull @Initialized InstrumentedType prepare(@UnknownKeyFor @NonNull @Initialized InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        static void encodeDelegate(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] encodingPosToIndex, @UnknownKeyFor @NonNull @Initialized Row value, @UnknownKeyFor @NonNull @Initialized OutputStream outputStream, @UnknownKeyFor @NonNull @Initialized boolean hasNullableFields) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkState((value.getFieldCount() == value.getSchema().getFieldCount() ? 1 : 0) != 0);
            Preconditions.checkState((encodingPosToIndex.length == value.getFieldCount() ? 1 : 0) != 0);
            VAR_INT_CODER.encode(value.getFieldCount(), outputStream);
            if (hasNullableFields) {
                Object[] fieldValues = new Object[value.getFieldCount()];
                for (int idx = 0; idx < fieldValues.length; ++idx) {
                    fieldValues[idx] = value.getValue(idx);
                }
                NULL_LIST_CODER.encode(EncodeInstruction.scanNullFields(fieldValues, encodingPosToIndex), outputStream);
                for (int encodingPos = 0; encodingPos < fieldValues.length; ++encodingPos) {
                    Object fieldValue = fieldValues[encodingPosToIndex[encodingPos]];
                    if (fieldValue == null) continue;
                    coders[encodingPos].encode(fieldValue, outputStream);
                }
            } else {
                NULL_LIST_CODER.encode(EMPTY_BIT_SET, outputStream);
                for (int encodingPos = 0; encodingPos < value.getFieldCount(); ++encodingPos) {
                    Object fieldValue = value.getValue(encodingPosToIndex[encodingPos]);
                    if (fieldValue == null) continue;
                    coders[encodingPos].encode(fieldValue, outputStream);
                }
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized BitSet scanNullFields(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] fieldValues, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] encodingPosToIndex) {
            Preconditions.checkState((fieldValues.length == encodingPosToIndex.length ? 1 : 0) != 0);
            BitSet nullFields = new BitSet(fieldValues.length);
            for (int encodingPos = 0; encodingPos < encodingPosToIndex.length; ++encodingPos) {
                int fieldIndex = encodingPosToIndex[encodingPos];
                if (fieldValues[fieldIndex] != null) continue;
                nullFields.set(encodingPos);
            }
            return nullFields;
        }
    }

    private static class GeneratedCoderConstructor
    implements Implementation {
        private GeneratedCoderConstructor() {
        }

        public @UnknownKeyFor @NonNull @Initialized InstrumentedType prepare(@UnknownKeyFor @NonNull @Initialized InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public @UnknownKeyFor @NonNull @Initialized ByteCodeAppender appender(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.loadThis(), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Coder.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).getOnly())), Duplication.SINGLE, MethodVariableAccess.REFERENCE.loadFrom(1), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldDescription.InDefinedShape)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)RowCoderGenerator.CODERS_FIELD_NAME))).getOnly())).write(), MethodVariableAccess.REFERENCE.loadFrom(2), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldDescription.InDefinedShape)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)RowCoderGenerator.POSITIONS_FIELD_NAME))).getOnly())).write(), MethodReturn.VOID});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }

    static class WithStackTrace<@UnknownKeyFor T> {
        private final T value;
        private final @UnknownKeyFor @NonNull @Initialized String stackTrace;

        public WithStackTrace(T value, @UnknownKeyFor @NonNull @Initialized String stackTrace) {
            this.value = value;
            this.stackTrace = stackTrace;
        }

        public T getValue() {
            return this.value;
        }

        public @UnknownKeyFor @NonNull @Initialized String getStackTrace() {
            return this.stackTrace;
        }
    }
}

