/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.CancellableQueue;
import org.apache.beam.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.sdk.fn.data.DataEndpoint;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.data.TimerEndpoint;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamFnDataInboundObserver
implements CloseableFnDataReceiver<BeamFnApi.Elements> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized EndpointStatus<@UnknownKeyFor @NonNull @Initialized DataEndpoint<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> transformIdToDataEndpoint = new HashMap();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized EndpointStatus<@UnknownKeyFor @NonNull @Initialized TimerEndpoint<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>>> transformIdToTimerFamilyIdToTimerEndpoint;
    private final @UnknownKeyFor @NonNull @Initialized CancellableQueue<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> queue;
    private final @UnknownKeyFor @NonNull @Initialized int totalNumEndpoints;
    private @UnknownKeyFor @NonNull @Initialized int numEndpointsThatAreIncomplete;
    private @UnknownKeyFor @NonNull @Initialized AtomicBoolean consumingReceivedData;

    public static @UnknownKeyFor @NonNull @Initialized BeamFnDataInboundObserver forConsumers(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DataEndpoint<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dataEndpoints, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimerEndpoint<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> timerEndpoints) {
        return new BeamFnDataInboundObserver(dataEndpoints, timerEndpoints);
    }

    private BeamFnDataInboundObserver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DataEndpoint<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dataEndpoints, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimerEndpoint<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> timerEndpoints) {
        for (DataEndpoint<?> dataEndpoint : dataEndpoints) {
            this.transformIdToDataEndpoint.put(dataEndpoint.getTransformId(), new EndpointStatus(dataEndpoint));
        }
        this.transformIdToTimerFamilyIdToTimerEndpoint = new HashMap();
        for (TimerEndpoint timerEndpoint : timerEndpoints) {
            this.transformIdToTimerFamilyIdToTimerEndpoint.computeIfAbsent(timerEndpoint.getTransformId(), unused -> new HashMap()).put(timerEndpoint.getTimerFamilyId(), new EndpointStatus<TimerEndpoint>(timerEndpoint));
        }
        this.queue = new CancellableQueue(100);
        this.numEndpointsThatAreIncomplete = this.totalNumEndpoints = dataEndpoints.size() + timerEndpoints.size();
        this.consumingReceivedData = new AtomicBoolean(false);
    }

    @Override
    public void accept(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements elements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.queue.put(elements);
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.queue.cancel(CloseException.INSTANCE);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isConsumingReceivedData() {
        return this.consumingReceivedData.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void awaitCompletion() throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            while (true) {
                this.consumingReceivedData.set(false);
                BeamFnApi.Elements elements = this.queue.take();
                this.consumingReceivedData.set(true);
                if (this.multiplexElements(elements)) {
                    return;
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            this.queue.cancel(e);
            throw e;
        }
        finally {
            this.consumingReceivedData.set(false);
            this.close();
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean multiplexElements(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements elements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (BeamFnApi.Elements.Data data : elements.getDataList()) {
            EndpointStatus<DataEndpoint<?>> endpoint = this.transformIdToDataEndpoint.get(data.getTransformId());
            if (endpoint == null) {
                throw new IllegalStateException(String.format("Unable to find inbound data receiver for instruction %s and transform %s.", data.getInstructionId(), data.getTransformId()));
            }
            if (endpoint.isDone) {
                throw new IllegalStateException(String.format("Received data after inbound data receiver is done for instruction %s and transform %s.", data.getInstructionId(), data.getTransformId()));
            }
            InputStream inputStream = data.getData().newInput();
            Coder coder = ((DataEndpoint)endpoint.endpoint).getCoder();
            FnDataReceiver receiver = ((DataEndpoint)endpoint.endpoint).getReceiver();
            while (inputStream.available() > 0) {
                receiver.accept(coder.decode(inputStream));
            }
            if (!data.getIsLast()) continue;
            endpoint.isDone = true;
            --this.numEndpointsThatAreIncomplete;
        }
        for (BeamFnApi.Elements.Timers timers : elements.getTimersList()) {
            Map<String, EndpointStatus<TimerEndpoint<?>>> timerFamilyIdToEndpoints = this.transformIdToTimerFamilyIdToTimerEndpoint.get(timers.getTransformId());
            if (timerFamilyIdToEndpoints == null) {
                throw new IllegalStateException(String.format("Unable to find inbound timer receiver for instruction %s, transform %s, and timer family %s.", timers.getInstructionId(), timers.getTransformId(), timers.getTimerFamilyId()));
            }
            EndpointStatus<TimerEndpoint<?>> endpoint = timerFamilyIdToEndpoints.get(timers.getTimerFamilyId());
            if (endpoint == null) {
                throw new IllegalStateException(String.format("Unable to find inbound timer receiver for instruction %s, transform %s, and timer family %s.", timers.getInstructionId(), timers.getTransformId(), timers.getTimerFamilyId()));
            }
            if (endpoint.isDone) {
                throw new IllegalStateException(String.format("Received timer after inbound timer receiver is done for instruction %s, transform %s, and timer family %s.", timers.getInstructionId(), timers.getTransformId(), timers.getTimerFamilyId()));
            }
            InputStream inputStream = timers.getTimers().newInput();
            Coder coder = ((TimerEndpoint)endpoint.endpoint).getCoder();
            FnDataReceiver receiver = ((TimerEndpoint)endpoint.endpoint).getReceiver();
            while (inputStream.available() > 0) {
                receiver.accept(coder.decode(inputStream));
            }
            if (!timers.getIsLast()) continue;
            endpoint.isDone = true;
            --this.numEndpointsThatAreIncomplete;
        }
        return this.numEndpointsThatAreIncomplete == 0;
    }

    public void reset() {
        this.numEndpointsThatAreIncomplete = this.totalNumEndpoints;
        for (EndpointStatus<DataEndpoint<?>> endpointStatus : this.transformIdToDataEndpoint.values()) {
            endpointStatus.isDone = false;
        }
        for (Map map : this.transformIdToTimerFamilyIdToTimerEndpoint.values()) {
            for (EndpointStatus status : map.values()) {
                status.isDone = false;
            }
        }
        this.queue.reset();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getUnfinishedEndpoints() {
        ArrayList<String> unfinishedEndpoints = new ArrayList<String>();
        for (Map.Entry<String, EndpointStatus<DataEndpoint<?>>> entry : this.transformIdToDataEndpoint.entrySet()) {
            if (entry.getValue().isDone) continue;
            unfinishedEndpoints.add(String.format("%s:data", entry.getKey()));
        }
        for (Map.Entry<String, Object> entry : this.transformIdToTimerFamilyIdToTimerEndpoint.entrySet()) {
            for (Map.Entry timerFamilyStatus : ((Map)entry.getValue()).entrySet()) {
                if (((EndpointStatus)timerFamilyStatus.getValue()).isDone) continue;
                unfinishedEndpoints.add(String.format("%s:timers:%s", entry.getKey(), timerFamilyStatus.getKey()));
            }
        }
        return unfinishedEndpoints;
    }

    protected static class CloseException
    extends Exception {
        public static final @UnknownKeyFor @NonNull @Initialized CloseException INSTANCE = new CloseException();

        private CloseException() {
            super("Inbound observer closed.", null, false, false);
        }
    }

    private static class EndpointStatus<@UnknownKeyFor T> {
        final T endpoint;
        @UnknownKeyFor @NonNull @Initialized boolean isDone;

        EndpointStatus(T endpoint) {
            this.endpoint = endpoint;
        }
    }
}

