/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Filter<@UnknownKeyFor T>
extends PTransform<PCollection<T>, PCollection<T>> {
    private @UnknownKeyFor @NonNull @Initialized ProcessFunction<T, @UnknownKeyFor @NonNull @Initialized Boolean> predicate;
    private @UnknownKeyFor @NonNull @Initialized String predicateDescription;

    public static <T, PredicateT extends ProcessFunction<T, Boolean>> @UnknownKeyFor @NonNull @Initialized Filter<T> by(PredicateT predicate) {
        return new Filter<T>(predicate);
    }

    public static <T, PredicateT extends SerializableFunction<T, Boolean>> @UnknownKeyFor @NonNull @Initialized Filter<T> by(PredicateT predicate) {
        return Filter.by(predicate);
    }

    public static <T extends Comparable<T>> @UnknownKeyFor @NonNull @Initialized Filter<T> lessThan(T value) {
        return Filter.by(input -> input.compareTo(value) < 0).described(String.format("x < %s", value));
    }

    public static <T extends Comparable<T>> @UnknownKeyFor @NonNull @Initialized Filter<T> greaterThan(T value) {
        return Filter.by(input -> input.compareTo(value) > 0).described(String.format("x > %s", value));
    }

    public static <T extends Comparable<T>> @UnknownKeyFor @NonNull @Initialized Filter<T> lessThanEq(T value) {
        return Filter.by(input -> input.compareTo(value) <= 0).described(String.format("x \u2264 %s", value));
    }

    public static <T extends Comparable<T>> @UnknownKeyFor @NonNull @Initialized Filter<T> greaterThanEq(T value) {
        return Filter.by(input -> input.compareTo(value) >= 0).described(String.format("x \u2265 %s", value));
    }

    public static <T extends Comparable<T>> @UnknownKeyFor @NonNull @Initialized Filter<T> equal(T value) {
        return Filter.by(input -> input.compareTo(value) == 0).described(String.format("x == %s", value));
    }

    private Filter(@UnknownKeyFor @NonNull @Initialized ProcessFunction<T, @UnknownKeyFor @NonNull @Initialized Boolean> predicate) {
        this(predicate, "Filter.predicate");
    }

    private Filter(@UnknownKeyFor @NonNull @Initialized ProcessFunction<T, @UnknownKeyFor @NonNull @Initialized Boolean> predicate, @UnknownKeyFor @NonNull @Initialized String predicateDescription) {
        this.predicate = predicate;
        this.predicateDescription = predicateDescription;
    }

    @UnknownKeyFor @NonNull @Initialized Filter<T> described(@UnknownKeyFor @NonNull @Initialized String description) {
        return new Filter<T>(this.predicate, description);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
        return ((PCollection)input.apply(ParDo.of(new DoFn<T, T>(){

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element T element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (((Boolean)Filter.this.predicate.apply(element)).booleanValue()) {
                    r.output(element);
                }
            }
        }))).setCoder(input.getCoder());
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("predicate", this.predicateDescription).withLabel("Filter Predicate"));
    }
}

