/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.ShardedFile;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.CharStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FilePatternMatchingShardedFile
implements ShardedFile {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FilePatternMatchingShardedFile.class);
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_READ_RETRIES = 4;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_SLEEP_DURATION = Duration.standardSeconds((long)10L);
    static final @UnknownKeyFor @NonNull @Initialized FluentBackoff BACK_OFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(DEFAULT_SLEEP_DURATION).withMaxRetries(4);
    private final @UnknownKeyFor @NonNull @Initialized String filePattern;

    public FilePatternMatchingShardedFile(@UnknownKeyFor @NonNull @Initialized String filePattern) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)filePattern) ? 1 : 0) != 0, (String)"Expected valid file path, but received %s", (Object)filePattern);
        this.filePattern = filePattern;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readFilesWithRetries(@UnknownKeyFor @NonNull @Initialized Sleeper sleeper, @UnknownKeyFor @NonNull @Initialized BackOff backOff) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        IOException lastException = null;
        do {
            try {
                List<MatchResult.Metadata> files = FileSystems.match(this.filePattern).metadata();
                LOG.debug("Found file(s) {} by matching the path: {}", (Object)files.stream().map(MatchResult.Metadata::resourceId).map(ResourceId::getFilename).collect(Collectors.joining(",")), (Object)this.filePattern);
                if (!files.isEmpty()) {
                    return this.readLines(files);
                }
            }
            catch (IOException e) {
                lastException = e;
                LOG.warn("Error in file reading. Ignore and retry.");
            }
        } while (BackOffUtils.next(sleeper, backOff));
        throw new IOException(String.format("Unable to read file(s) after retrying %d times", 4), lastException);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readFilesWithRetries() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return this.readFilesWithRetries(Sleeper.DEFAULT, BACK_OFF_FACTORY.backoff());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("sharded file matching pattern: %s", this.filePattern);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> files) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList allLines = Lists.newArrayList();
        int i = 1;
        for (MatchResult.Metadata file : files) {
            try (Reader reader = Channels.newReader(FileSystems.open(file.resourceId()), StandardCharsets.UTF_8.name());){
                List lines = CharStreams.readLines((Readable)reader);
                allLines.addAll(lines);
                LOG.debug("[{} of {}] Read {} lines from file: {}", new Object[]{i, files.size(), lines.size(), file});
            }
            ++i;
        }
        return allLines;
    }
}

