/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.value.AutoValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.beam.sdk.util.AutoValue_RowJsonValueExtractors_ValidatingValueExtractor;
import org.apache.beam.sdk.util.RowJson;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;

class RowJsonValueExtractors {
    RowJsonValueExtractors() {
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized Byte> byteValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> (byte)jsonNode.intValue()).setValidator(jsonNode -> jsonNode.isIntegralNumber() && jsonNode.canConvertToInt() && jsonNode.intValue() >= -128 && jsonNode.intValue() <= 127).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized Short> shortValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> (short)jsonNode.intValue()).setValidator(jsonNode -> jsonNode.isIntegralNumber() && jsonNode.canConvertToInt() && jsonNode.intValue() >= Short.MIN_VALUE && jsonNode.intValue() <= Short.MAX_VALUE).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized Integer> intValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::intValue).setValidator(jsonNode -> jsonNode.isIntegralNumber() && jsonNode.canConvertToInt()).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized Long> longValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::longValue).setValidator(jsonNode -> jsonNode.isIntegralNumber() && jsonNode.canConvertToLong()).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized Float> floatValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::floatValue).setValidator(jsonNode -> jsonNode.isFloat() || jsonNode.isFloatingPointNumber() && jsonNode.doubleValue() == (double)((float)jsonNode.doubleValue()) || jsonNode.isIntegralNumber() && jsonNode.canConvertToInt() && jsonNode.asInt() == (int)((float)jsonNode.asInt())).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized Double> doubleValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::doubleValue).setValidator(jsonNode -> jsonNode.isDouble() || jsonNode.isIntegralNumber() && jsonNode.canConvertToLong() && jsonNode.asLong() == (long)((double)jsonNode.asInt()) || jsonNode.isFloatingPointNumber() && jsonNode.decimalValue().equals(BigDecimal.valueOf(jsonNode.doubleValue()))).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized Boolean> booleanValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::booleanValue).setValidator(JsonNode::isBoolean).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized String> stringValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::textValue).setValidator(JsonNode::isTextual).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized BigDecimal> decimalValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(JsonNode::decimalValue).setValidator(jsonNode -> jsonNode.isNumber()).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized DateTime> datetimeValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> DateTime.parse((String)jsonNode.textValue())).setValidator(JsonNode::isTextual).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized LocalDate> dateValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> LocalDate.parse(jsonNode.textValue())).setValidator(JsonNode::isTextual).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized LocalTime> timeValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> LocalTime.parse(jsonNode.textValue())).setValidator(JsonNode::isTextual).build();
    }

    static @UnknownKeyFor @NonNull @Initialized ValueExtractor<@UnknownKeyFor @NonNull @Initialized LocalDateTime> localDatetimeValueExtractor() {
        return ValidatingValueExtractor.builder().setExtractor(jsonNode -> LocalDateTime.parse(jsonNode.textValue())).setValidator(JsonNode::isTextual).build();
    }

    @AutoValue
    public static abstract class ValidatingValueExtractor<@UnknownKeyFor W>
    implements ValueExtractor<W> {
        abstract @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized JsonNode> validator();

        abstract @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized JsonNode, W> extractor();

        static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> builder() {
            return new AutoValue_RowJsonValueExtractors_ValidatingValueExtractor.Builder();
        }

        @Override
        public W extractValue(@UnknownKeyFor @NonNull @Initialized JsonNode value) {
            if (!this.validator().test(value)) {
                throw new RowJson.UnsupportedRowJsonException("Value \"" + value.asText() + "\" is out of range for the type of the field defined in the row schema.");
            }
            return this.extractor().apply(value);
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor W> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<W> setValidator(@UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized JsonNode> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<W> setExtractor(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized JsonNode, W> var1);

            abstract @UnknownKeyFor @NonNull @Initialized ValidatingValueExtractor<W> build();
        }
    }

    public static interface ValueExtractor<@UnknownKeyFor V> {
        public V extractValue(@UnknownKeyFor @NonNull @Initialized JsonNode var1);
    }
}

