/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileConstants;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.io.AvroDatumFactory;
import org.apache.beam.sdk.io.BlockBasedSource;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AvroSource<@UnknownKeyFor T>
extends BlockBasedSource<T> {
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_MIN_BUNDLE_SIZE = 128000L;
    private final @UnknownKeyFor @NonNull @Initialized Mode<T> mode;
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Schema> schemaLogicalReferenceCache = new WeakHashMap<String, Schema>();
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> schemaStringLogicalReferenceCache = new WeakHashMap<String, String>();

    public static @UnknownKeyFor @NonNull @Initialized AvroSource<@UnknownKeyFor @NonNull @Initialized GenericRecord> from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileNameOrPattern) {
        return new AvroSource<GenericRecord>(fileNameOrPattern, EmptyMatchTreatment.DISALLOW, 128000L, new Mode());
    }

    public static @UnknownKeyFor @NonNull @Initialized AvroSource<@UnknownKeyFor @NonNull @Initialized GenericRecord> from(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata) {
        return new AvroSource<GenericRecord>(metadata, 128000L, 0L, metadata.sizeBytes(), new Mode());
    }

    public static @UnknownKeyFor @NonNull @Initialized AvroSource<@UnknownKeyFor @NonNull @Initialized GenericRecord> from(@UnknownKeyFor @NonNull @Initialized String fileNameOrPattern) {
        return AvroSource.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fileNameOrPattern));
    }

    public @UnknownKeyFor @NonNull @Initialized AvroSource<T> withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment) {
        return new AvroSource<T>((ValueProvider<String>)this.getFileOrPatternSpecProvider(), emptyMatchTreatment, this.getMinBundleSize(), this.mode);
    }

    public @UnknownKeyFor @NonNull @Initialized AvroSource<@UnknownKeyFor @NonNull @Initialized GenericRecord> withSchema(@UnknownKeyFor @NonNull @Initialized String schema) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<GenericRecord>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), ((Mode)this.mode).withSchema(schema));
        }
        return new AvroSource<GenericRecord>((ValueProvider<String>)this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), ((Mode)this.mode).withSchema(schema));
    }

    public @UnknownKeyFor @NonNull @Initialized AvroSource<@UnknownKeyFor @NonNull @Initialized GenericRecord> withSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
        return this.withSchema(schema.toString());
    }

    public <X> @UnknownKeyFor @NonNull @Initialized AvroSource<X> withSchema(@UnknownKeyFor @NonNull @Initialized Class<X> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz can not be null");
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<T>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), ((Mode)this.mode).withClass(clazz));
        }
        return new AvroSource<T>((ValueProvider<String>)this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), ((Mode)this.mode).withClass(clazz));
    }

    public <X> @UnknownKeyFor @NonNull @Initialized AvroSource<X> withParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, X> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<X> coder) {
        Preconditions.checkArgument((parseFn != null ? 1 : 0) != 0, (Object)"parseFn can not be null");
        Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<T>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), ((Mode)this.mode).withParseFunction(parseFn, coder));
        }
        return new AvroSource<T>((ValueProvider<String>)this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), ((Mode)this.mode).withParseFunction(parseFn, coder));
    }

    public @UnknownKeyFor @NonNull @Initialized AvroSource<T> withMinBundleSize(@UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<T>(this.getSingleFileMetadata(), minBundleSize, this.getStartOffset(), this.getEndOffset(), this.mode);
        }
        return new AvroSource<T>((ValueProvider<String>)this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), minBundleSize, this.mode);
    }

    public @UnknownKeyFor @NonNull @Initialized AvroSource<T> withDatumReaderFactory(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DatumReaderFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> factory) {
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)"factory can not be null");
        Mode newMode = ((Mode)this.mode).withReaderFactory(factory);
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<T>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), newMode);
        }
        return new AvroSource<T>((ValueProvider<String>)this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), newMode);
    }

    public @UnknownKeyFor @NonNull @Initialized AvroSource<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
        Mode newMode = ((Mode)this.mode).withCoder(coder);
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<T>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), newMode);
        }
        return new AvroSource<T>((ValueProvider<String>)this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), newMode);
    }

    private AvroSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileNameOrPattern, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment, @UnknownKeyFor @NonNull @Initialized long minBundleSize, @UnknownKeyFor @NonNull @Initialized Mode<T> mode) {
        super(fileNameOrPattern, emptyMatchTreatment, minBundleSize);
        this.mode = mode;
    }

    private AvroSource(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long minBundleSize, @UnknownKeyFor @NonNull @Initialized long startOffset, @UnknownKeyFor @NonNull @Initialized long endOffset, @UnknownKeyFor @NonNull @Initialized Mode<T> mode) {
        super(metadata, minBundleSize, startOffset, endOffset);
        this.mode = mode;
    }

    public void validate() {
        super.validate();
        ((Mode)this.mode).validate();
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized BlockBasedSource<T> createForSubrangeOfFile(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.createForSubrangeOfFile(FileSystems.matchSingleFileSpec((String)fileName), start, end);
    }

    public @UnknownKeyFor @NonNull @Initialized BlockBasedSource<T> createForSubrangeOfFile(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata fileMetadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        return new AvroSource<T>(fileMetadata, this.getMinBundleSize(), start, end, this.mode);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BlockBasedSource.BlockBasedReader<T> createSingleFileReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new AvroReader(this);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return ((Mode)this.mode).getOutputCoder();
    }

    @VisibleForTesting
    @Nullable @UnknownKeyFor @Initialized String getReaderSchemaString() {
        return ((Mode)this.mode).readerSchemaString;
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized AvroMetadata readMetadataFromFile(@UnknownKeyFor @NonNull @Initialized ResourceId fileResource) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] syncMarker;
        String codec = null;
        String schemaString = null;
        try (InputStream stream = Channels.newInputStream(FileSystems.open((ResourceId)fileResource));){
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(stream, null);
            byte[] magic = new byte[DataFileConstants.MAGIC.length];
            decoder.readFixed(magic);
            if (!Arrays.equals(magic, DataFileConstants.MAGIC)) {
                throw new IOException("Missing Avro file signature: " + fileResource);
            }
            ByteBuffer valueBuffer = ByteBuffer.allocate(512);
            long numRecords = decoder.readMapStart();
            while (numRecords > 0L) {
                for (long recordIndex = 0L; recordIndex < numRecords; ++recordIndex) {
                    String key = decoder.readString();
                    valueBuffer = decoder.readBytes(valueBuffer);
                    byte[] bytes = new byte[valueBuffer.remaining()];
                    valueBuffer.get(bytes);
                    if (key.equals("avro.codec")) {
                        codec = new String(bytes, StandardCharsets.UTF_8);
                        continue;
                    }
                    if (!key.equals("avro.schema")) continue;
                    schemaString = new String(bytes, StandardCharsets.UTF_8);
                }
                numRecords = decoder.mapNext();
            }
            if (codec == null) {
                codec = "null";
            }
            syncMarker = new byte[16];
            decoder.readFixed(syncMarker);
        }
        Preconditions.checkState((schemaString != null ? 1 : 0) != 0, (String)"No schema present in Avro file metadata %s", (Object)fileResource);
        return new AvroMetadata(syncMarker, codec, schemaString);
    }

    private static synchronized @UnknownKeyFor @NonNull @Initialized String internSchemaString(@UnknownKeyFor @NonNull @Initialized String schema) {
        String internSchema = schemaStringLogicalReferenceCache.get(schema);
        if (internSchema != null) {
            return internSchema;
        }
        schemaStringLogicalReferenceCache.put(schema, schema);
        return schema;
    }

    static synchronized @UnknownKeyFor @NonNull @Initialized Schema internOrParseSchemaString(@UnknownKeyFor @NonNull @Initialized String schemaString) {
        Schema schema = schemaLogicalReferenceCache.get(schemaString);
        if (schema != null) {
            return schema;
        }
        Schema.Parser parser = new Schema.Parser();
        schema = parser.parse(schemaString);
        schemaLogicalReferenceCache.put(schemaString, schema);
        return schema;
    }

    private @UnknownKeyFor @NonNull @Initialized Object readResolve() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        switch (this.getMode()) {
            case SINGLE_FILE_OR_SUBRANGE: {
                return new AvroSource<T>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), this.mode);
            }
            case FILEPATTERN: {
                return new AvroSource<T>((ValueProvider<String>)this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), this.mode);
            }
        }
        throw new InvalidObjectException(String.format("Unknown mode %s for AvroSource %s", new Object[]{this.getMode(), this}));
    }

    public static class AvroReader<@UnknownKeyFor T>
    extends BlockBasedSource.BlockBasedReader<T> {
        private @Nullable @UnknownKeyFor @Initialized AvroBlock<T> currentBlock;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized DataFileReader<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataFileReader;
        private final @UnknownKeyFor @NonNull @Initialized Object progressLock = new Object();
        @GuardedBy(value="progressLock")
        private @UnknownKeyFor @NonNull @Initialized long currentBlockOffset = 0L;
        @GuardedBy(value="progressLock")
        private @UnknownKeyFor @NonNull @Initialized long currentBlockSizeBytes = 0L;

        public AvroReader(@UnknownKeyFor @NonNull @Initialized AvroSource<T> source) {
            super(source);
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized AvroSource<T> getCurrentSource() {
            return (AvroSource)super.getCurrentSource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @UnknownKeyFor @NonNull @Initialized boolean readNextBlock() {
            if (!this.dataFileReader.hasNext()) {
                return false;
            }
            long headerLength = (long)VarInt.getLength((long)this.dataFileReader.getBlockCount()) + (long)VarInt.getLength((long)this.dataFileReader.getBlockSize()) + 16L;
            this.currentBlock = new AvroBlock((Iterator<?>)this.dataFileReader, ((AvroSource)this.getCurrentSource()).mode.parseFn, this.dataFileReader.getBlockCount());
            Object object = this.progressLock;
            synchronized (object) {
                this.currentBlockOffset = this.dataFileReader.previousSync();
                this.currentBlockSizeBytes = this.dataFileReader.getBlockSize() + headerLength;
            }
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized AvroBlock<T> getCurrentBlock() {
            return this.currentBlock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @UnknownKeyFor @NonNull @Initialized long getCurrentBlockOffset() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.currentBlockOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @UnknownKeyFor @NonNull @Initialized long getCurrentBlockSize() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.currentBlockSizeBytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @UnknownKeyFor @NonNull @Initialized long getSplitPointsRemaining() {
            if (this.isDone()) {
                return 0L;
            }
            Object object = this.progressLock;
            synchronized (object) {
                if (this.currentBlockOffset + this.currentBlockSizeBytes >= this.getCurrentSource().getEndOffset()) {
                    return 1L;
                }
            }
            return super.getSplitPointsRemaining();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void startReading(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            SeekableChannelInput seekableChannelInput = new SeekableChannelInput((SeekableByteChannel)channel);
            seekableChannelInput.seek(0L);
            Schema readerSchema = null;
            String readerSchemaString = this.getCurrentSource().getReaderSchemaString();
            if (readerSchemaString != null) {
                readerSchema = AvroSource.internOrParseSchemaString(readerSchemaString);
            }
            DatumReader reader = ((DatumReaderFactory)Optional.ofNullable(((AvroSource)this.getCurrentSource()).mode.readerFactory).orElse(AvroDatumFactory.of(((AvroSource)this.getCurrentSource()).mode.type))).apply(readerSchema, readerSchema);
            this.dataFileReader = new DataFileReader((SeekableInput)seekableChannelInput, reader);
            long startOffset = this.getCurrentSource().getStartOffset();
            if (startOffset != 0L) {
                this.dataFileReader.sync(Math.max(0L, startOffset - 16L));
            }
            Object object = this.progressLock;
            synchronized (object) {
                this.currentBlockOffset = this.dataFileReader.previousSync();
                this.currentBlockSizeBytes = 0L;
            }
        }

        private static class SeekableChannelInput
        implements SeekableInput {
            private final @UnknownKeyFor @NonNull @Initialized SeekableByteChannel channel;
            private final @UnknownKeyFor @NonNull @Initialized InputStream input;

            SeekableChannelInput(@UnknownKeyFor @NonNull @Initialized SeekableByteChannel channel) {
                this.channel = channel;
                this.input = Channels.newInputStream(channel);
            }

            public void seek(@UnknownKeyFor @NonNull @Initialized long p) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.channel.position(p);
            }

            public @UnknownKeyFor @NonNull @Initialized long tell() throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.channel.position();
            }

            public @UnknownKeyFor @NonNull @Initialized long length() throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.channel.size();
            }

            public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.input.read(b, off, len);
            }

            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.channel.close();
            }
        }
    }

    static class AvroBlock<@UnknownKeyFor T>
    extends BlockBasedSource.Block<T> {
        private @Nullable T currentRecord;
        private @UnknownKeyFor @NonNull @Initialized long currentRecordIndex = 0L;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> iterator;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn;
        private final @UnknownKeyFor @NonNull @Initialized long numRecordsInBlock;

        AvroBlock(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> iter, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized long numRecordsInBlock) {
            this.iterator = iter;
            this.parseFn = parseFn;
            this.numRecordsInBlock = numRecordsInBlock;
        }

        public T getCurrentRecord() {
            return this.currentRecord;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() {
            if (this.currentRecordIndex >= this.numRecordsInBlock) {
                return false;
            }
            Object record = this.iterator.next();
            this.currentRecord = this.parseFn == null ? record : this.parseFn.apply((Object)((GenericRecord)record));
            ++this.currentRecordIndex;
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized double getFractionOfBlockConsumed() {
            return (double)this.currentRecordIndex / (double)this.numRecordsInBlock;
        }
    }

    @VisibleForTesting
    static class AvroMetadata {
        private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] syncMarker;
        private final @UnknownKeyFor @NonNull @Initialized String codec;
        private final @UnknownKeyFor @NonNull @Initialized String schemaString;

        AvroMetadata(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] syncMarker, @UnknownKeyFor @NonNull @Initialized String codec, @UnknownKeyFor @NonNull @Initialized String schemaString) {
            this.syncMarker = (byte[])Preconditions.checkNotNull((Object)syncMarker, (Object)"syncMarker");
            this.codec = (String)Preconditions.checkNotNull((Object)codec, (Object)"codec");
            this.schemaString = AvroSource.internSchemaString((String)Preconditions.checkNotNull((Object)schemaString, (Object)"schemaString"));
        }

        public @UnknownKeyFor @NonNull @Initialized String getSchemaString() {
            return this.schemaString;
        }

        public @UnknownKeyFor @NonNull @Initialized String getCodec() {
            return this.codec;
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getSyncMarker() {
            return this.syncMarker;
        }
    }

    private static class Mode<@UnknownKeyFor T>
    implements Serializable {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type;
        private @Nullable @UnknownKeyFor @Initialized String readerSchemaString;
        private final @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn;
        private final @Nullable @UnknownKeyFor @Initialized Coder<T> outputCoder;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized DatumReaderFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> readerFactory;

        private Mode() {
            this(GenericRecord.class, null, null, null, null);
        }

        private Mode(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @Nullable @UnknownKeyFor @Initialized String readerSchemaString, @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn, @Nullable @UnknownKeyFor @Initialized Coder<T> outputCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized DatumReaderFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> readerFactory) {
            this.type = type;
            this.readerSchemaString = AvroSource.internSchemaString(readerSchemaString);
            this.parseFn = parseFn;
            this.outputCoder = outputCoder;
            this.readerFactory = readerFactory;
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            is.defaultReadObject();
            this.readerSchemaString = AvroSource.internSchemaString(this.readerSchemaString);
        }

        private @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
            if (this.parseFn == null && this.outputCoder == null) {
                if (this.readerFactory != null && this.readerFactory instanceof AvroDatumFactory) {
                    return AvroCoder.of((AvroDatumFactory)this.readerFactory, AvroSource.internOrParseSchemaString(this.readerSchemaString));
                }
                return AvroCoder.of(this.type, AvroSource.internOrParseSchemaString(this.readerSchemaString));
            }
            return this.outputCoder;
        }

        private void validate() {
            if (this.parseFn == null) {
                Preconditions.checkArgument((this.readerSchemaString != null ? 1 : 0) != 0, (Object)"schema must be specified using withSchema() when not using a parse fn");
            }
        }

        private @UnknownKeyFor @NonNull @Initialized Mode<@UnknownKeyFor @NonNull @Initialized GenericRecord> withSchema(@UnknownKeyFor @NonNull @Initialized String schema) {
            return new Mode<GenericRecord>(GenericRecord.class, schema, null, this.outputCoder, this.readerFactory);
        }

        private <X> @UnknownKeyFor @NonNull @Initialized Mode<X> withClass(@UnknownKeyFor @NonNull @Initialized Class<X> clazz) {
            return new Mode<T>(clazz, ReflectData.get().getSchema(clazz).toString(), null, this.outputCoder, this.readerFactory);
        }

        private <X> @UnknownKeyFor @NonNull @Initialized Mode<X> withParseFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, X> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<X> outputCoder) {
            return new Mode<X>(GenericRecord.class, null, parseFn, outputCoder, this.readerFactory);
        }

        private @UnknownKeyFor @NonNull @Initialized Mode<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return new Mode<T>(this.type, this.readerSchemaString, this.parseFn, coder, this.readerFactory);
        }

        private @UnknownKeyFor @NonNull @Initialized Mode<T> withReaderFactory(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DatumReaderFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> factory) {
            return new Mode<T>(this.type, this.readerSchemaString, this.parseFn, this.outputCoder, factory);
        }
    }

    @FunctionalInterface
    public static interface DatumReaderFactory<@UnknownKeyFor T>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized DatumReader<T> apply(@UnknownKeyFor @NonNull @Initialized Schema var1, @UnknownKeyFor @NonNull @Initialized Schema var2);
    }
}

