/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.model.Shard;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicCheckpointGenerator
implements CheckpointGenerator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DynamicCheckpointGenerator.class);
    private final @UnknownKeyFor @NonNull @Initialized String streamName;
    private final @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint;

    public DynamicCheckpointGenerator(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint) {
        this.streamName = streamName;
        this.startingPoint = startingPoint;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint generate(@UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesis) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        List<Shard> streamShards = kinesis.listShardsAtPoint(this.streamName, this.startingPoint);
        LOG.info("Creating a checkpoint with following shards {} at {}", streamShards, (Object)this.startingPoint.getTimestamp());
        return new KinesisReaderCheckpoint(streamShards.stream().map(shard -> new ShardCheckpoint(this.streamName, shard.getShardId(), this.startingPoint)).collect(Collectors.toList()));
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("Checkpoint generator for %s: %s", this.streamName, this.startingPoint);
    }
}

