/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.shared;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hop.ui.hopgui.file.shared.IDelayListener;

public class DelayTimer
implements Runnable {
    private int delayInMiliseconds;
    private boolean stopped;
    private List<IDelayListener> delayListeners;
    private Callable<Boolean> prolonger = () -> false;
    private long start;

    public DelayTimer(int delayInMiliseconds) {
        this.delayInMiliseconds = delayInMiliseconds;
        this.delayListeners = new ArrayList<IDelayListener>();
        this.stopped = false;
    }

    public DelayTimer(int delayInMilliseconds, IDelayListener delayListener) {
        this(delayInMilliseconds);
        this.addDelayListener(delayListener);
    }

    public DelayTimer(int delayInMilliseconds, IDelayListener delayListener, Callable<Boolean> prolonger) {
        this(delayInMilliseconds, delayListener);
        this.prolonger = prolonger;
    }

    public void reset() {
        this.start = System.currentTimeMillis();
    }

    @Override
    public void run() {
        this.reset();
        while ((this.delayNotExpired() || this.needProlong()) && !this.stopped) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        for (IDelayListener delayListener : this.delayListeners) {
            delayListener.expired();
        }
    }

    private boolean delayNotExpired() {
        return System.currentTimeMillis() - this.start < (long)this.delayInMiliseconds;
    }

    private boolean needProlong() {
        try {
            return this.prolonger.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Prolonger call finished with error", e);
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public void addDelayListener(IDelayListener delayListener) {
        this.delayListeners.add(delayListener);
    }

    public int getDelayInMilliseconds() {
        return this.delayInMiliseconds;
    }

    public void setDelayInSeconds(int delayInMilliseconds) {
        this.delayInMiliseconds = delayInMilliseconds;
    }
}

