/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb.io;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private final InputStream source;
    private final long maxBytesToRead;
    private long bytesRead;

    public LimitedInputStream(InputStream source, long maxBytesToRead) {
        if (source == null) {
            throw new IllegalArgumentException("Source input stream cannot be null");
        }
        if (maxBytesToRead < 0L) {
            throw new IllegalArgumentException("maxBytesToRead must be non-negative");
        }
        this.source = source;
        this.maxBytesToRead = maxBytesToRead;
        this.bytesRead = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead >= this.maxBytesToRead) {
            return -1;
        }
        int result = this.source.read();
        if (result != -1) {
            ++this.bytesRead;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRead >= this.maxBytesToRead) {
            return -1;
        }
        long bytesRemaining = this.maxBytesToRead - this.bytesRead;
        int bytesToRead = (int)Math.min((long)len, bytesRemaining);
        int result = this.source.read(b, off, bytesToRead);
        if (result != -1) {
            this.bytesRead += (long)result;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

