/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sns;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.aws.sns.AwsSns;
import org.apache.hop.pipeline.transforms.aws.sns.SnsNotifyData;
import org.apache.hop.pipeline.transforms.aws.sns.SnsNotifyMeta;

public class SnsNotify
extends BaseTransform<SnsNotifyMeta, SnsNotifyData> {
    public SnsNotify(TransformMeta transformMeta, SnsNotifyMeta meta, SnsNotifyData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        ((SnsNotifyData)this.data).aws_sns = new AwsSns((SnsNotifyMeta)this.meta, this.getPipelineMeta(), this);
        if (!((SnsNotifyData)this.data).aws_sns.getAWSConnection()) {
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        ((SnsNotifyData)this.data).realMessageIDField = this.resolve(((SnsNotifyMeta)this.meta).getTFldMessageID());
        return super.init();
    }

    private void setFieldIndices() {
        IRowMeta inputMeta = this.getInputRowMeta();
        ((SnsNotifyData)this.data).indexOfFieldtopARN = ((SnsNotifyMeta)this.meta).getCInputtopicArn().equals("Y") ? inputMeta.indexOfValue(((SnsNotifyMeta)this.meta).getTFldtopicARN()) : -1;
        ((SnsNotifyData)this.data).indexOfFieldSubject = ((SnsNotifyMeta)this.meta).getCInputSubject().equals("Y") ? inputMeta.indexOfValue(((SnsNotifyMeta)this.meta).getTFldSubject()) : -1;
        ((SnsNotifyData)this.data).indexOfFieldMessage = ((SnsNotifyMeta)this.meta).getCInputMessage().equals("Y") ? inputMeta.indexOfValue(((SnsNotifyMeta)this.meta).getTFldMessage()) : -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.setFieldIndices();
        boolean firstrow = false;
        if (this.first) {
            firstrow = true;
            this.first = false;
            ((SnsNotifyData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((SnsNotifyMeta)this.meta).getFields(((SnsNotifyData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        if (((SnsNotifyMeta)this.meta).getNotifyPointShort().equals("each") || firstrow) {
            try {
                Object[] outputRow = this.sendSnsNotification(r);
                if (outputRow != null) {
                    this.putRow(((SnsNotifyData)this.data).outputRowMeta, outputRow);
                    this.incrementLinesOutput();
                    this.incrementLinesWritten();
                }
            }
            catch (Exception e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError("AWS SNS Error: " + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), "", "SNSNotifyError");
            }
        } else {
            this.putRow(((SnsNotifyData)this.data).outputRowMeta, r);
            this.incrementLinesWritten();
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private Object[] sendSnsNotification(Object[] row) throws Exception {
        String tARN = "";
        String subject = "";
        String message = "";
        tARN = ((SnsNotifyData)this.data).indexOfFieldtopARN >= 0 ? this.getInputRowMeta().getString(row, ((SnsNotifyData)this.data).indexOfFieldtopARN) : this.resolve(((SnsNotifyMeta)this.meta).getTValuetopicARN());
        subject = ((SnsNotifyData)this.data).indexOfFieldSubject >= 0 ? this.getInputRowMeta().getString(row, ((SnsNotifyData)this.data).indexOfFieldSubject) : this.resolve(((SnsNotifyMeta)this.meta).getTValueSubject());
        message = ((SnsNotifyData)this.data).indexOfFieldMessage >= 0 ? this.getInputRowMeta().getString(row, ((SnsNotifyData)this.data).indexOfFieldMessage) : this.resolve(((SnsNotifyMeta)this.meta).getTValueMessage());
        Object[] outputRowData = row;
        String messageID = ((SnsNotifyData)this.data).aws_sns.publishToSNS(tARN, subject, message);
        if (messageID != null) {
            outputRowData = RowDataUtil.resizeArray((Object[])outputRowData, (int)((SnsNotifyData)this.data).outputRowMeta.size());
            int indexOfMessID = ((SnsNotifyData)this.data).outputRowMeta.indexOfValue(((SnsNotifyData)this.data).realMessageIDField);
            if (indexOfMessID >= 0) {
                outputRowData[indexOfMessID] = messageID;
            }
        }
        return outputRowData;
    }

    public void dispose() {
        ((SnsNotifyData)this.data).aws_sns.disconnectAWSConnection();
        super.dispose();
    }
}

