/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookup;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookupData;
import org.apache.hop.pipeline.transforms.databaselookup.KeyField;
import org.apache.hop.pipeline.transforms.databaselookup.Lookup;
import org.apache.hop.pipeline.transforms.databaselookup.ReturnValue;

@Transform(id="DBLookup", image="dblookup.svg", name="i18n::DatabaseLookup.Name", description="i18n::DatabaseLookup.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::DatabaseLookupMeta.keyword"}, documentationUrl="/pipeline/transforms/databaselookup.html", actionTransformTypes={ActionTransformType.LOOKUP, ActionTransformType.RDBMS})
public class DatabaseLookupMeta
extends BaseTransformMeta<DatabaseLookup, DatabaseLookupData> {
    private static final Class<?> PKG = DatabaseLookupMeta.class;
    protected static final String[] conditionStrings = new String[]{"=", "<>", "<", "<=", ">", ">=", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL"};
    public static final int CONDITION_EQ = 0;
    public static final int CONDITION_NE = 1;
    public static final int CONDITION_LT = 2;
    public static final int CONDITION_LE = 3;
    public static final int CONDITION_GT = 4;
    public static final int CONDITION_GE = 5;
    public static final int CONDITION_LIKE = 6;
    public static final int CONDITION_BETWEEN = 7;
    public static final int CONDITION_IS_NULL = 8;
    public static final int CONDITION_IS_NOT_NULL = 9;
    @HopMetadataProperty(injectionKeyDescription="DatabaseLookupMeta.Injection.Connection", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection;
    @HopMetadataProperty(key="cache", injectionKeyDescription="DatabaseLookupMeta.Injection.Cache")
    private boolean cached;
    @HopMetadataProperty(key="cache_size", injectionKeyDescription="DatabaseLookupMeta.Injection.CacheSize")
    private int cacheSize;
    @HopMetadataProperty(key="cache_load_all", injectionKeyDescription="DatabaseLookupMeta.Injection.CacheLoadAll")
    private boolean loadingAllDataInCache;
    @HopMetadataProperty(key="lookup")
    private Lookup lookup;

    public DatabaseLookupMeta() {
        this.lookup = new Lookup();
    }

    public DatabaseLookupMeta(DatabaseLookupMeta m) {
        this.connection = m.connection;
        this.cached = m.cached;
        this.cacheSize = m.cacheSize;
        this.loadingAllDataInCache = m.loadingAllDataInCache;
        this.lookup = new Lookup(m.lookup);
    }

    public DatabaseLookupMeta clone() {
        return new DatabaseLookupMeta(this);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] infoRowMeta, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            if (Utils.isEmpty((Object[])infoRowMeta) || infoRowMeta[0] == null) {
                for (ReturnValue returnValue : this.lookup.getReturnValues()) {
                    IValueMeta v = ValueMetaFactory.createValueMeta((String)(!Utils.isEmpty((CharSequence)returnValue.getNewName()) ? returnValue.getNewName() : returnValue.getTableField()), (int)ValueMetaFactory.getIdForValueMeta((String)returnValue.getDefaultType()));
                    v.setOrigin(name);
                    row.addValueMeta(v);
                }
                return;
            }
            for (ReturnValue returnValue : this.lookup.getReturnValues()) {
                IValueMeta v = infoRowMeta[0].searchValueMeta(returnValue.getTableField());
                if (v == null) continue;
                IValueMeta copy = v.clone();
                copy.setName(!Utils.isEmpty((CharSequence)returnValue.getNewName()) ? returnValue.getNewName() : returnValue.getTableField());
                copy.setOrigin(name);
                row.addValueMeta(copy);
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Error getting fields metadata", (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        StringBuilder errorMessage = new StringBuilder();
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (databaseMeta == null) {
                errorMessage = new StringBuilder(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingConnectionError", (String[])new String[0]));
                CheckResult cr2 = new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr2);
                return;
            }
            try (Database db = new Database(loggingObject, variables, databaseMeta);){
                boolean errorFound;
                boolean first;
                this.databases = new Database[]{db};
                db.connect();
                List<KeyField> keyFields = this.lookup.getKeyFields();
                if (!Utils.isEmpty((CharSequence)this.lookup.getTableName())) {
                    first = true;
                    errorFound = false;
                    errorMessage = new StringBuilder();
                    String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.lookup.getSchemaName(), this.lookup.getTableName());
                    IRowMeta r = db.getTableFields(schemaTable);
                    if (r != null) {
                        for (KeyField keyField : keyFields) {
                            String luField = keyField.getTableField();
                            IValueMeta v = r.searchValueMeta(luField);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage.append(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingCompareFieldsInLookupTable", (String[])new String[0])).append(Const.CR);
                            }
                            errorFound = true;
                            errorMessage.append("\t\t").append(luField).append(Const.CR);
                        }
                        cr = errorFound ? new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.AllLookupFieldsFoundInTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        List<ReturnValue> returnValues = this.lookup.getReturnValues();
                        for (ReturnValue returnValue : returnValues) {
                            String luField = returnValue.getTableField();
                            IValueMeta v = r.searchValueMeta(luField);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage.append(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingReturnFieldsInLookupTable", (String[])new String[0])).append(Const.CR);
                            }
                            errorFound = true;
                            errorMessage.append("\t\t").append(luField).append(Const.CR);
                        }
                        cr = errorFound ? new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.AllReturnFieldsFoundInTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = new StringBuilder(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.CouldNotReadTableInfo", (String[])new String[0]));
                        cr = new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && !prev.isEmpty()) {
                    first = true;
                    errorMessage = new StringBuilder();
                    errorFound = false;
                    for (KeyField keyField : keyFields) {
                        IValueMeta v = prev.searchValueMeta(keyField.getStreamField1());
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage.append(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingFieldsNotFoundInInput", (String[])new String[0])).append(Const.CR);
                        }
                        errorFound = true;
                        errorMessage.append("\t\t").append(keyField.getStreamField1()).append(Const.CR);
                    }
                    cr = errorFound ? new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = new StringBuilder(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.CouldNotReadFromPreviousTransforms", (String[])new String[0]) + Const.CR);
                    cr = new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
        }
        catch (HopException dbe) {
            errorMessage = new StringBuilder(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.DatabaseErrorWhileChecking", (String[])new String[0]) + dbe.getMessage());
            cr = new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.TransformIsReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public IRowMeta getTableFields(IVariables variables) {
        IRowMeta fields = null;
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta != null) {
            try (Database db = new Database(loggingObject, variables, databaseMeta);){
                this.databases = new Database[]{db};
                db.connect();
                String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.lookup.getSchemaName(), this.lookup.getTableName());
                fields = db.getTableFields(schemaTable);
            }
            catch (HopDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.ERROR0004.ErrorGettingTableFields", (String[])new String[0]) + dbe.getMessage());
            }
        }
        return fields;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        DatabaseMeta databaseMeta = null;
        try {
            DatabaseImpact ii;
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            List<KeyField> keyFields = this.lookup.getKeyFields();
            for (KeyField keyField : keyFields) {
                IValueMeta v = prev.searchValueMeta(keyField.getStreamField1());
                ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.lookup.getTableName(), keyField.getTableField(), keyField.getStreamField1(), v != null ? v.getOrigin() : "?", "", BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Impact.Key", (String[])new String[0]));
                impact.add(ii);
            }
            List<ReturnValue> returnValues = this.lookup.getReturnValues();
            for (ReturnValue returnValue : returnValues) {
                ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.lookup.getTableName(), returnValue.getTableField(), "", "", "", BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Impact.ReturnValue", (String[])new String[0]));
                impact.add(ii);
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection));
        }
    }

    public String getTableName() {
        return this.lookup.getTableName();
    }

    public String getSchemaName() {
        return this.lookup.getSchemaName();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static final List<String> getConditionStrings() {
        return Arrays.asList(conditionStrings);
    }

    @Generated
    public void setConnection(String connection) {
        this.connection = connection;
    }

    @Generated
    public void setCached(boolean cached) {
        this.cached = cached;
    }

    @Generated
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Generated
    public void setLoadingAllDataInCache(boolean loadingAllDataInCache) {
        this.loadingAllDataInCache = loadingAllDataInCache;
    }

    @Generated
    public void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }

    @Generated
    public String getConnection() {
        return this.connection;
    }

    @Generated
    public boolean isCached() {
        return this.cached;
    }

    @Generated
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Generated
    public boolean isLoadingAllDataInCache() {
        return this.loadingAllDataInCache;
    }

    @Generated
    public Lookup getLookup() {
        return this.lookup;
    }
}

