/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.util;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.IndexCursor;
import io.github.spannm.jackcess.Row;
import io.github.spannm.jackcess.impl.IndexCursorImpl;
import io.github.spannm.jackcess.util.ColumnMatcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class EntryIterableBuilder
implements Iterable<Row> {
    private final IndexCursor _cursor;
    private Collection<String> _columnNames;
    private Object[] _entryValues;
    private ColumnMatcher _columnMatcher;

    public EntryIterableBuilder(IndexCursor cursor, Object ... entryValues) {
        this._cursor = cursor;
        this._entryValues = entryValues;
    }

    public Collection<String> getColumnNames() {
        return this._columnNames;
    }

    public ColumnMatcher getColumnMatcher() {
        return this._columnMatcher;
    }

    public Object[] getEntryValues() {
        return this._entryValues;
    }

    public EntryIterableBuilder withColumnNames(Collection<String> columnNames) {
        this._columnNames = columnNames;
        return this;
    }

    public EntryIterableBuilder addColumnNames(Iterable<String> columnNames) {
        if (columnNames != null) {
            for (String name : columnNames) {
                this.addColumnName(name);
            }
        }
        return this;
    }

    public EntryIterableBuilder addColumns(Iterable<? extends Column> cols) {
        if (cols != null) {
            for (Column column : cols) {
                this.addColumnName(column.getName());
            }
        }
        return this;
    }

    public EntryIterableBuilder addColumnNames(String ... columnNames) {
        if (columnNames != null) {
            for (String name : columnNames) {
                this.addColumnName(name);
            }
        }
        return this;
    }

    private void addColumnName(String columnName) {
        if (this._columnNames == null) {
            this._columnNames = new HashSet<String>();
        }
        this._columnNames.add(columnName);
    }

    public EntryIterableBuilder withEntryValues(Object ... entryValues) {
        this._entryValues = entryValues;
        return this;
    }

    public EntryIterableBuilder withColumnMatcher(ColumnMatcher columnMatcher) {
        this._columnMatcher = columnMatcher;
        return this;
    }

    @Override
    public Iterator<Row> iterator() {
        return ((IndexCursorImpl)this._cursor).entryIterator(this);
    }

    public Stream<Row> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

