/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.AuthorizedView;
import com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.CopyBackupMetadata;
import com.google.bigtable.admin.v2.CopyBackupRequest;
import com.google.bigtable.admin.v2.CreateAuthorizedViewMetadata;
import com.google.bigtable.admin.v2.CreateAuthorizedViewRequest;
import com.google.bigtable.admin.v2.CreateBackupMetadata;
import com.google.bigtable.admin.v2.CreateBackupRequest;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotMetadata;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteAuthorizedViewRequest;
import com.google.bigtable.admin.v2.DeleteBackupRequest;
import com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.GetAuthorizedViewRequest;
import com.google.bigtable.admin.v2.GetBackupRequest;
import com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.ListAuthorizedViewsRequest;
import com.google.bigtable.admin.v2.ListAuthorizedViewsResponse;
import com.google.bigtable.admin.v2.ListBackupsRequest;
import com.google.bigtable.admin.v2.ListBackupsResponse;
import com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.RestoreTableMetadata;
import com.google.bigtable.admin.v2.RestoreTableRequest;
import com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.admin.v2.SnapshotTableMetadata;
import com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.UndeleteTableMetadata;
import com.google.bigtable.admin.v2.UndeleteTableRequest;
import com.google.bigtable.admin.v2.UpdateAuthorizedViewMetadata;
import com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest;
import com.google.bigtable.admin.v2.UpdateBackupRequest;
import com.google.bigtable.admin.v2.UpdateTableMetadata;
import com.google.bigtable.admin.v2.UpdateTableRequest;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStub;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.cloud.bigtable.admin.v2.stub.GrpcBigtableTableAdminCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@InternalApi
public class GrpcBigtableTableAdminStub
extends BigtableTableAdminStub {
    private static final MethodDescriptor<CreateTableRequest, Table> createTableMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/CreateTable").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTableRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Table.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/CreateTableFromSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTableFromSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTablesRequest, ListTablesResponse> listTablesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/ListTables").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTablesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTablesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTableRequest, Table> getTableMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/GetTable").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTableRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Table.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTableRequest, Operation> updateTableMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/UpdateTable").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTableRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTableRequest, Empty> deleteTableMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/DeleteTable").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTableRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<UndeleteTableRequest, Operation> undeleteTableMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/UndeleteTable").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeleteTableRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateAuthorizedViewRequest, Operation> createAuthorizedViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/CreateAuthorizedView").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateAuthorizedViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse> listAuthorizedViewsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/ListAuthorizedViews").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAuthorizedViewsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAuthorizedViewsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAuthorizedViewRequest, AuthorizedView> getAuthorizedViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/GetAuthorizedView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAuthorizedViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AuthorizedView.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateAuthorizedViewRequest, Operation> updateAuthorizedViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/UpdateAuthorizedView").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAuthorizedViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteAuthorizedViewRequest, Empty> deleteAuthorizedViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/DeleteAuthorizedView").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAuthorizedViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/ModifyColumnFamilies").setRequestMarshaller(ProtoUtils.marshaller((Message)ModifyColumnFamiliesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Table.getDefaultInstance())).build();
    private static final MethodDescriptor<DropRowRangeRequest, Empty> dropRowRangeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/DropRowRange").setRequestMarshaller(ProtoUtils.marshaller((Message)DropRowRangeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/GenerateConsistencyToken").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateConsistencyTokenRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateConsistencyTokenResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/CheckConsistency").setRequestMarshaller(ProtoUtils.marshaller((Message)CheckConsistencyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CheckConsistencyResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SnapshotTableRequest, Operation> snapshotTableMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/SnapshotTable").setRequestMarshaller(ProtoUtils.marshaller((Message)SnapshotTableRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSnapshotRequest, Snapshot> getSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/GetSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Snapshot.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/ListSnapshots").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSnapshotsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSnapshotsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSnapshotRequest, Empty> deleteSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/DeleteSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateBackupRequest, Operation> createBackupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/CreateBackup").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateBackupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetBackupRequest, Backup> getBackupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/GetBackup").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBackupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Backup.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateBackupRequest, Backup> updateBackupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/UpdateBackup").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateBackupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Backup.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteBackupRequest, Empty> deleteBackupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/DeleteBackup").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteBackupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListBackupsRequest, ListBackupsResponse> listBackupsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/ListBackups").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBackupsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBackupsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RestoreTableRequest, Operation> restoreTableMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/RestoreTable").setRequestMarshaller(ProtoUtils.marshaller((Message)RestoreTableRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CopyBackupRequest, Operation> copyBackupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/CopyBackup").setRequestMarshaller(ProtoUtils.marshaller((Message)CopyBackupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateTableRequest, Table> createTableCallable;
    private final UnaryCallable<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotCallable;
    private final OperationCallable<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationCallable;
    private final UnaryCallable<ListTablesRequest, ListTablesResponse> listTablesCallable;
    private final UnaryCallable<ListTablesRequest, BaseBigtableTableAdminClient.ListTablesPagedResponse> listTablesPagedCallable;
    private final UnaryCallable<GetTableRequest, Table> getTableCallable;
    private final UnaryCallable<UpdateTableRequest, Operation> updateTableCallable;
    private final OperationCallable<UpdateTableRequest, Table, UpdateTableMetadata> updateTableOperationCallable;
    private final UnaryCallable<DeleteTableRequest, Empty> deleteTableCallable;
    private final UnaryCallable<UndeleteTableRequest, Operation> undeleteTableCallable;
    private final OperationCallable<UndeleteTableRequest, Table, UndeleteTableMetadata> undeleteTableOperationCallable;
    private final UnaryCallable<CreateAuthorizedViewRequest, Operation> createAuthorizedViewCallable;
    private final OperationCallable<CreateAuthorizedViewRequest, AuthorizedView, CreateAuthorizedViewMetadata> createAuthorizedViewOperationCallable;
    private final UnaryCallable<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse> listAuthorizedViewsCallable;
    private final UnaryCallable<ListAuthorizedViewsRequest, BaseBigtableTableAdminClient.ListAuthorizedViewsPagedResponse> listAuthorizedViewsPagedCallable;
    private final UnaryCallable<GetAuthorizedViewRequest, AuthorizedView> getAuthorizedViewCallable;
    private final UnaryCallable<UpdateAuthorizedViewRequest, Operation> updateAuthorizedViewCallable;
    private final OperationCallable<UpdateAuthorizedViewRequest, AuthorizedView, UpdateAuthorizedViewMetadata> updateAuthorizedViewOperationCallable;
    private final UnaryCallable<DeleteAuthorizedViewRequest, Empty> deleteAuthorizedViewCallable;
    private final UnaryCallable<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesCallable;
    private final UnaryCallable<DropRowRangeRequest, Empty> dropRowRangeCallable;
    private final UnaryCallable<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenCallable;
    private final UnaryCallable<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencyCallable;
    private final UnaryCallable<SnapshotTableRequest, Operation> snapshotTableCallable;
    private final OperationCallable<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationCallable;
    private final UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable;
    private final UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable;
    private final UnaryCallable<ListSnapshotsRequest, BaseBigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable;
    private final UnaryCallable<DeleteSnapshotRequest, Empty> deleteSnapshotCallable;
    private final UnaryCallable<CreateBackupRequest, Operation> createBackupCallable;
    private final OperationCallable<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationCallable;
    private final UnaryCallable<GetBackupRequest, Backup> getBackupCallable;
    private final UnaryCallable<UpdateBackupRequest, Backup> updateBackupCallable;
    private final UnaryCallable<DeleteBackupRequest, Empty> deleteBackupCallable;
    private final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable;
    private final UnaryCallable<ListBackupsRequest, BaseBigtableTableAdminClient.ListBackupsPagedResponse> listBackupsPagedCallable;
    private final UnaryCallable<RestoreTableRequest, Operation> restoreTableCallable;
    private final OperationCallable<RestoreTableRequest, Table, RestoreTableMetadata> restoreTableOperationCallable;
    private final UnaryCallable<CopyBackupRequest, Operation> copyBackupCallable;
    private final OperationCallable<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBigtableTableAdminStub create(BigtableTableAdminStubSettings settings) throws IOException {
        return new GrpcBigtableTableAdminStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBigtableTableAdminStub create(ClientContext clientContext) throws IOException {
        return new GrpcBigtableTableAdminStub(BigtableTableAdminStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBigtableTableAdminStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBigtableTableAdminStub(BigtableTableAdminStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBigtableTableAdminStub(BigtableTableAdminStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBigtableTableAdminCallableFactory());
    }

    protected GrpcBigtableTableAdminStub(BigtableTableAdminStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createTableTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTableMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createTableFromSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTableFromSnapshotMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listTablesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTablesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getTableTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTableMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateTableTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTableMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("table.name", String.valueOf(request.getTable().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteTableTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTableMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings undeleteTableTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeleteTableMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createAuthorizedViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createAuthorizedViewMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listAuthorizedViewsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAuthorizedViewsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getAuthorizedViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAuthorizedViewMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateAuthorizedViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAuthorizedViewMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("authorized_view.name", String.valueOf(request.getAuthorizedView().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteAuthorizedViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAuthorizedViewMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings modifyColumnFamiliesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(modifyColumnFamiliesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings dropRowRangeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(dropRowRangeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings generateConsistencyTokenTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateConsistencyTokenMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings checkConsistencyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(checkConsistencyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings snapshotTableTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(snapshotTableMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSnapshotMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSnapshotsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSnapshotsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSnapshotMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createBackupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createBackupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getBackupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBackupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateBackupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateBackupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("backup.name", String.valueOf(request.getBackup().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteBackupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteBackupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listBackupsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBackupsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings restoreTableTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(restoreTableMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings copyBackupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(copyBackupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createTableCallable = callableFactory.createUnaryCallable(createTableTransportSettings, settings.createTableSettings(), clientContext);
        this.createTableFromSnapshotCallable = callableFactory.createUnaryCallable(createTableFromSnapshotTransportSettings, settings.createTableFromSnapshotSettings(), clientContext);
        this.createTableFromSnapshotOperationCallable = callableFactory.createOperationCallable(createTableFromSnapshotTransportSettings, settings.createTableFromSnapshotOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listTablesCallable = callableFactory.createUnaryCallable(listTablesTransportSettings, settings.listTablesSettings(), clientContext);
        this.listTablesPagedCallable = callableFactory.createPagedCallable(listTablesTransportSettings, settings.listTablesSettings(), clientContext);
        this.getTableCallable = callableFactory.createUnaryCallable(getTableTransportSettings, settings.getTableSettings(), clientContext);
        this.updateTableCallable = callableFactory.createUnaryCallable(updateTableTransportSettings, settings.updateTableSettings(), clientContext);
        this.updateTableOperationCallable = callableFactory.createOperationCallable(updateTableTransportSettings, settings.updateTableOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteTableCallable = callableFactory.createUnaryCallable(deleteTableTransportSettings, settings.deleteTableSettings(), clientContext);
        this.undeleteTableCallable = callableFactory.createUnaryCallable(undeleteTableTransportSettings, settings.undeleteTableSettings(), clientContext);
        this.undeleteTableOperationCallable = callableFactory.createOperationCallable(undeleteTableTransportSettings, settings.undeleteTableOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createAuthorizedViewCallable = callableFactory.createUnaryCallable(createAuthorizedViewTransportSettings, settings.createAuthorizedViewSettings(), clientContext);
        this.createAuthorizedViewOperationCallable = callableFactory.createOperationCallable(createAuthorizedViewTransportSettings, settings.createAuthorizedViewOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listAuthorizedViewsCallable = callableFactory.createUnaryCallable(listAuthorizedViewsTransportSettings, settings.listAuthorizedViewsSettings(), clientContext);
        this.listAuthorizedViewsPagedCallable = callableFactory.createPagedCallable(listAuthorizedViewsTransportSettings, settings.listAuthorizedViewsSettings(), clientContext);
        this.getAuthorizedViewCallable = callableFactory.createUnaryCallable(getAuthorizedViewTransportSettings, settings.getAuthorizedViewSettings(), clientContext);
        this.updateAuthorizedViewCallable = callableFactory.createUnaryCallable(updateAuthorizedViewTransportSettings, settings.updateAuthorizedViewSettings(), clientContext);
        this.updateAuthorizedViewOperationCallable = callableFactory.createOperationCallable(updateAuthorizedViewTransportSettings, settings.updateAuthorizedViewOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteAuthorizedViewCallable = callableFactory.createUnaryCallable(deleteAuthorizedViewTransportSettings, settings.deleteAuthorizedViewSettings(), clientContext);
        this.modifyColumnFamiliesCallable = callableFactory.createUnaryCallable(modifyColumnFamiliesTransportSettings, settings.modifyColumnFamiliesSettings(), clientContext);
        this.dropRowRangeCallable = callableFactory.createUnaryCallable(dropRowRangeTransportSettings, settings.dropRowRangeSettings(), clientContext);
        this.generateConsistencyTokenCallable = callableFactory.createUnaryCallable(generateConsistencyTokenTransportSettings, settings.generateConsistencyTokenSettings(), clientContext);
        this.checkConsistencyCallable = callableFactory.createUnaryCallable(checkConsistencyTransportSettings, settings.checkConsistencySettings(), clientContext);
        this.snapshotTableCallable = callableFactory.createUnaryCallable(snapshotTableTransportSettings, settings.snapshotTableSettings(), clientContext);
        this.snapshotTableOperationCallable = callableFactory.createOperationCallable(snapshotTableTransportSettings, settings.snapshotTableOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getSnapshotCallable = callableFactory.createUnaryCallable(getSnapshotTransportSettings, settings.getSnapshotSettings(), clientContext);
        this.listSnapshotsCallable = callableFactory.createUnaryCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.listSnapshotsPagedCallable = callableFactory.createPagedCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.deleteSnapshotCallable = callableFactory.createUnaryCallable(deleteSnapshotTransportSettings, settings.deleteSnapshotSettings(), clientContext);
        this.createBackupCallable = callableFactory.createUnaryCallable(createBackupTransportSettings, settings.createBackupSettings(), clientContext);
        this.createBackupOperationCallable = callableFactory.createOperationCallable(createBackupTransportSettings, settings.createBackupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getBackupCallable = callableFactory.createUnaryCallable(getBackupTransportSettings, settings.getBackupSettings(), clientContext);
        this.updateBackupCallable = callableFactory.createUnaryCallable(updateBackupTransportSettings, settings.updateBackupSettings(), clientContext);
        this.deleteBackupCallable = callableFactory.createUnaryCallable(deleteBackupTransportSettings, settings.deleteBackupSettings(), clientContext);
        this.listBackupsCallable = callableFactory.createUnaryCallable(listBackupsTransportSettings, settings.listBackupsSettings(), clientContext);
        this.listBackupsPagedCallable = callableFactory.createPagedCallable(listBackupsTransportSettings, settings.listBackupsSettings(), clientContext);
        this.restoreTableCallable = callableFactory.createUnaryCallable(restoreTableTransportSettings, settings.restoreTableSettings(), clientContext);
        this.restoreTableOperationCallable = callableFactory.createOperationCallable(restoreTableTransportSettings, settings.restoreTableOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.copyBackupCallable = callableFactory.createUnaryCallable(copyBackupTransportSettings, settings.copyBackupSettings(), clientContext);
        this.copyBackupOperationCallable = callableFactory.createOperationCallable(copyBackupTransportSettings, settings.copyBackupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateTableRequest, Table> createTableCallable() {
        return this.createTableCallable;
    }

    @Override
    public UnaryCallable<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotCallable() {
        return this.createTableFromSnapshotCallable;
    }

    @Override
    public OperationCallable<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationCallable() {
        return this.createTableFromSnapshotOperationCallable;
    }

    @Override
    public UnaryCallable<ListTablesRequest, ListTablesResponse> listTablesCallable() {
        return this.listTablesCallable;
    }

    @Override
    public UnaryCallable<ListTablesRequest, BaseBigtableTableAdminClient.ListTablesPagedResponse> listTablesPagedCallable() {
        return this.listTablesPagedCallable;
    }

    @Override
    public UnaryCallable<GetTableRequest, Table> getTableCallable() {
        return this.getTableCallable;
    }

    @Override
    public UnaryCallable<UpdateTableRequest, Operation> updateTableCallable() {
        return this.updateTableCallable;
    }

    @Override
    public OperationCallable<UpdateTableRequest, Table, UpdateTableMetadata> updateTableOperationCallable() {
        return this.updateTableOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTableRequest, Empty> deleteTableCallable() {
        return this.deleteTableCallable;
    }

    @Override
    public UnaryCallable<UndeleteTableRequest, Operation> undeleteTableCallable() {
        return this.undeleteTableCallable;
    }

    @Override
    public OperationCallable<UndeleteTableRequest, Table, UndeleteTableMetadata> undeleteTableOperationCallable() {
        return this.undeleteTableOperationCallable;
    }

    @Override
    public UnaryCallable<CreateAuthorizedViewRequest, Operation> createAuthorizedViewCallable() {
        return this.createAuthorizedViewCallable;
    }

    @Override
    public OperationCallable<CreateAuthorizedViewRequest, AuthorizedView, CreateAuthorizedViewMetadata> createAuthorizedViewOperationCallable() {
        return this.createAuthorizedViewOperationCallable;
    }

    @Override
    public UnaryCallable<ListAuthorizedViewsRequest, ListAuthorizedViewsResponse> listAuthorizedViewsCallable() {
        return this.listAuthorizedViewsCallable;
    }

    @Override
    public UnaryCallable<ListAuthorizedViewsRequest, BaseBigtableTableAdminClient.ListAuthorizedViewsPagedResponse> listAuthorizedViewsPagedCallable() {
        return this.listAuthorizedViewsPagedCallable;
    }

    @Override
    public UnaryCallable<GetAuthorizedViewRequest, AuthorizedView> getAuthorizedViewCallable() {
        return this.getAuthorizedViewCallable;
    }

    @Override
    public UnaryCallable<UpdateAuthorizedViewRequest, Operation> updateAuthorizedViewCallable() {
        return this.updateAuthorizedViewCallable;
    }

    @Override
    public OperationCallable<UpdateAuthorizedViewRequest, AuthorizedView, UpdateAuthorizedViewMetadata> updateAuthorizedViewOperationCallable() {
        return this.updateAuthorizedViewOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteAuthorizedViewRequest, Empty> deleteAuthorizedViewCallable() {
        return this.deleteAuthorizedViewCallable;
    }

    @Override
    public UnaryCallable<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesCallable() {
        return this.modifyColumnFamiliesCallable;
    }

    @Override
    public UnaryCallable<DropRowRangeRequest, Empty> dropRowRangeCallable() {
        return this.dropRowRangeCallable;
    }

    @Override
    public UnaryCallable<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenCallable() {
        return this.generateConsistencyTokenCallable;
    }

    @Override
    public UnaryCallable<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencyCallable() {
        return this.checkConsistencyCallable;
    }

    @Override
    public UnaryCallable<SnapshotTableRequest, Operation> snapshotTableCallable() {
        return this.snapshotTableCallable;
    }

    @Override
    public OperationCallable<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationCallable() {
        return this.snapshotTableOperationCallable;
    }

    @Override
    public UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable() {
        return this.getSnapshotCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable() {
        return this.listSnapshotsCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotsRequest, BaseBigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.listSnapshotsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSnapshotRequest, Empty> deleteSnapshotCallable() {
        return this.deleteSnapshotCallable;
    }

    @Override
    public UnaryCallable<CreateBackupRequest, Operation> createBackupCallable() {
        return this.createBackupCallable;
    }

    @Override
    public OperationCallable<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationCallable() {
        return this.createBackupOperationCallable;
    }

    @Override
    public UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.getBackupCallable;
    }

    @Override
    public UnaryCallable<UpdateBackupRequest, Backup> updateBackupCallable() {
        return this.updateBackupCallable;
    }

    @Override
    public UnaryCallable<DeleteBackupRequest, Empty> deleteBackupCallable() {
        return this.deleteBackupCallable;
    }

    @Override
    public UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.listBackupsCallable;
    }

    @Override
    public UnaryCallable<ListBackupsRequest, BaseBigtableTableAdminClient.ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.listBackupsPagedCallable;
    }

    @Override
    public UnaryCallable<RestoreTableRequest, Operation> restoreTableCallable() {
        return this.restoreTableCallable;
    }

    @Override
    public OperationCallable<RestoreTableRequest, Table, RestoreTableMetadata> restoreTableOperationCallable() {
        return this.restoreTableOperationCallable;
    }

    @Override
    public UnaryCallable<CopyBackupRequest, Operation> copyBackupCallable() {
        return this.copyBackupCallable;
    }

    @Override
    public OperationCallable<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationCallable() {
        return this.copyBackupOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

