/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models.sql;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.Type;
import com.google.cloud.Date;
import com.google.cloud.bigtable.common.Type;
import com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.List;
import org.threeten.bp.Instant;

@BetaApi
public interface SqlType<T>
extends Serializable {
    public Code getCode();

    public static SqlType<ByteString> bytes() {
        return Type.Bytes.create();
    }

    public static SqlType<String> string() {
        return Type.String.create();
    }

    public static SqlType<Long> int64() {
        return Type.Int64.create();
    }

    public static SqlType<Double> float64() {
        return Type.Float64.create();
    }

    public static SqlType<Float> float32() {
        return Type.Float32.create();
    }

    public static SqlType<Boolean> bool() {
        return Type.Bool.create();
    }

    public static SqlType<Instant> timestamp() {
        return Type.Timestamp.create();
    }

    public static SqlType<Date> date() {
        return Type.Date.create();
    }

    public static Struct struct() {
        return Type.SchemalessStruct.create();
    }

    public static <Elem> Array<Elem> arrayOf(SqlType<Elem> elemType) {
        return Type.Array.create(elemType);
    }

    public static <K, V> Map<K, V> mapOf(SqlType<K> keyType, SqlType<V> valType) {
        return Type.Map.create(keyType, valType);
    }

    public static Map<ByteString, List<com.google.cloud.bigtable.data.v2.models.sql.Struct>> historicalMap() {
        return SqlType.mapOf(SqlType.bytes(), SqlType.arrayOf(SqlType.struct()));
    }

    @InternalApi
    public static SqlType<?> fromProto(Type proto) {
        switch (proto.getKindCase()) {
            case BYTES_TYPE: {
                return SqlType.bytes();
            }
            case STRING_TYPE: {
                return SqlType.string();
            }
            case INT64_TYPE: {
                return SqlType.int64();
            }
            case FLOAT64_TYPE: {
                return SqlType.float64();
            }
            case FLOAT32_TYPE: {
                return SqlType.float32();
            }
            case BOOL_TYPE: {
                return SqlType.bool();
            }
            case TIMESTAMP_TYPE: {
                return SqlType.timestamp();
            }
            case DATE_TYPE: {
                return SqlType.date();
            }
            case STRUCT_TYPE: {
                return Type.StructWithSchema.fromProto(proto.getStructType());
            }
            case ARRAY_TYPE: {
                return SqlType.arrayOf(SqlType.fromProto(proto.getArrayType().getElementType()));
            }
            case MAP_TYPE: {
                Type.Map mapType = proto.getMapType();
                return SqlType.mapOf(SqlType.fromProto(mapType.getKeyType()), SqlType.fromProto(mapType.getValueType()));
            }
            case KIND_NOT_SET: {
                throw new IllegalStateException("Unrecognized Type. You may need to update your client.");
            }
        }
        throw new IllegalStateException("Unexpected Type: " + proto.getKindCase().name());
    }

    @InternalApi
    public static boolean typesMatch(SqlType<?> left, SqlType<?> right) {
        switch (left.getCode()) {
            case BYTES: 
            case STRING: 
            case INT64: 
            case FLOAT64: 
            case FLOAT32: 
            case BOOL: 
            case TIMESTAMP: 
            case DATE: {
                return left.equals(right);
            }
            case STRUCT: {
                return left.getCode().equals((Object)right.getCode());
            }
            case ARRAY: {
                if (!left.getCode().equals((Object)right.getCode())) {
                    return false;
                }
                Array leftArray = (Array)left;
                Array rightArray = (Array)right;
                return SqlType.typesMatch(leftArray.getElementType(), rightArray.getElementType());
            }
            case MAP: {
                if (!left.getCode().equals((Object)right.getCode())) {
                    return false;
                }
                Map leftMap = (Map)left;
                Map rightMap = (Map)right;
                boolean keysMatch = SqlType.typesMatch(leftMap.getKeyType(), rightMap.getKeyType());
                boolean valuesMatch = SqlType.typesMatch(leftMap.getValueType(), rightMap.getValueType());
                return keysMatch && valuesMatch;
            }
        }
        throw new IllegalStateException("Unexpected type: " + left);
    }

    public static interface Struct
    extends SqlType<com.google.cloud.bigtable.data.v2.models.sql.Struct> {
        public List<? extends Field> getFields();

        public SqlType<?> getType(int var1);

        public SqlType<?> getType(String var1);

        public int getColumnIndex(String var1);

        public static interface Field
        extends ColumnMetadata {
            @Override
            public String name();

            @Override
            public SqlType<?> type();
        }
    }

    public static interface Array<Elem>
    extends SqlType<List<Elem>> {
        public SqlType<Elem> getElementType();
    }

    public static interface Map<K, V>
    extends SqlType<java.util.Map<K, V>> {
        public SqlType<K> getKeyType();

        public SqlType<V> getValueType();
    }

    public static enum Code {
        BYTES,
        STRING,
        INT64,
        FLOAT64,
        FLOAT32,
        BOOL,
        TIMESTAMP,
        DATE,
        STRUCT,
        ARRAY,
        MAP;

    }
}

