/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;

class FrequencyAggregatorFactory
implements ThreadDumpAggregator,
ThreadDumpAggregatorFactory {
    long total;
    long minTs = Long.MAX_VALUE;
    long maxTs = Long.MIN_VALUE;

    FrequencyAggregatorFactory() {
    }

    @Override
    public ThreadDumpAggregator newInstance() {
        return new FrequencyAggregatorFactory();
    }

    @Override
    public void aggregate(ThreadSnapshot threadInfo) {
        ++this.total;
        this.minTs = Math.min(this.minTs, threadInfo.timestamp());
        this.maxTs = Math.max(this.maxTs, threadInfo.timestamp());
    }

    @Override
    public Object info() {
        if (this.total < 2L) {
            return Double.NaN;
        }
        return 1000.0 * (double)this.total / (double)(this.maxTs - this.minTs);
    }
}

