/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.InMemoryTimerInternals;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.fnexecution.control.BundleProgressHandler;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.JobBundleFactory;
import org.apache.beam.runners.fnexecution.control.OutputReceiverFactory;
import org.apache.beam.runners.fnexecution.control.ProcessBundleDescriptors;
import org.apache.beam.runners.fnexecution.control.RemoteBundle;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.control.TimerReceiverFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.state.InMemoryBagUserStateFactory;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.runners.fnexecution.state.StateRequestHandlers;
import org.apache.beam.runners.fnexecution.translation.BatchSideInputHandlerFactory;
import org.apache.beam.runners.fnexecution.translation.PipelineTranslatorUtils;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.translation.SparkExecutableStageContextFactory;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.graph.ExecutableStage;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.Tuple2;

class SparkExecutableStageFunction<@UnknownKeyFor InputT, @UnknownKeyFor SideInputT>
implements FlatMapFunction<Iterator<WindowedValue<InputT>>, RawUnionValue> {
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload stagePayload;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> outputMap;
    private final @UnknownKeyFor @NonNull @Initialized SparkExecutableStageContextFactory contextFactory;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<SideInputT>>> sideInputs;
    private final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator metricsAccumulator;
    private final @UnknownKeyFor @NonNull @Initialized Coder windowCoder;
    private final @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
    private transient @UnknownKeyFor @NonNull @Initialized InMemoryBagUserStateFactory bagUserStateHandlerFactory;
    private transient @UnknownKeyFor @NonNull @Initialized Object currentTimerKey;

    SparkExecutableStageFunction(@UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload stagePayload, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> outputMap, @UnknownKeyFor @NonNull @Initialized SparkExecutableStageContextFactory contextFactory, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<SideInputT>>> sideInputs, @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator metricsAccumulator, @UnknownKeyFor @NonNull @Initialized Coder windowCoder) {
        this.pipelineOptions = pipelineOptions;
        this.stagePayload = stagePayload;
        this.jobInfo = jobInfo;
        this.outputMap = outputMap;
        this.contextFactory = contextFactory;
        this.sideInputs = sideInputs;
        this.metricsAccumulator = metricsAccumulator;
        this.windowCoder = windowCoder;
    }

    @UnknownKeyFor @NonNull @Initialized FlatMapFunction<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>>>, @UnknownKeyFor @NonNull @Initialized RawUnionValue> forPair() {
        return (FlatMapFunction & Serializable)input -> this.call(((Iterable)input._2).iterator());
    }

    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized RawUnionValue> call(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> inputs) throws @UnknownKeyFor @NonNull @Initialized Exception {
        SparkPipelineOptions options = (SparkPipelineOptions)this.pipelineOptions.get().as(SparkPipelineOptions.class);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        if (!inputs.hasNext()) {
            return Collections.emptyIterator();
        }
        try (ExecutableStageContext stageContext = this.contextFactory.get(this.jobInfo);){
            Iterator<RawUnionValue> iterator;
            block23: {
                StateRequestHandler stateRequestHandler;
                ConcurrentLinkedQueue<RawUnionValue> collector;
                StageBundleFactory stageBundleFactory;
                block21: {
                    Iterator<RawUnionValue> iterator2;
                    block22: {
                        ExecutableStage executableStage = ExecutableStage.fromPayload((RunnerApi.ExecutableStagePayload)this.stagePayload);
                        stageBundleFactory = stageContext.getStageBundleFactory(executableStage);
                        collector = new ConcurrentLinkedQueue<RawUnionValue>();
                        stateRequestHandler = this.getStateRequestHandler(executableStage, stageBundleFactory.getProcessBundleDescriptor());
                        if (executableStage.getTimers().size() != 0) break block21;
                        ReceiverFactory receiverFactory = new ReceiverFactory(collector, this.outputMap);
                        this.processElements(stateRequestHandler, receiverFactory, null, stageBundleFactory, inputs);
                        iterator2 = collector.iterator();
                        if (stageBundleFactory == null) break block22;
                        stageBundleFactory.close();
                    }
                    return iterator2;
                }
                try {
                    InMemoryTimerInternals timerInternals = new InMemoryTimerInternals();
                    timerInternals.advanceProcessingTime(Instant.now());
                    timerInternals.advanceSynchronizedProcessingTime(Instant.now());
                    ReceiverFactory receiverFactory = new ReceiverFactory(collector, this.outputMap);
                    TimerReceiverFactory timerReceiverFactory = new TimerReceiverFactory(stageBundleFactory, (timer, timerData) -> {
                        this.currentTimerKey = timer.getUserKey();
                        if (timer.getClearBit()) {
                            timerInternals.deleteTimer(timerData);
                        } else {
                            timerInternals.setTimer(timerData);
                        }
                    }, this.windowCoder);
                    this.processElements(stateRequestHandler, receiverFactory, timerReceiverFactory, stageBundleFactory, inputs);
                    timerInternals.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
                    timerInternals.advanceProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
                    timerInternals.advanceSynchronizedProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
                    while (timerInternals.hasPendingTimers()) {
                        RemoteBundle bundle = stageBundleFactory.getBundle((OutputReceiverFactory)receiverFactory, timerReceiverFactory, stateRequestHandler, this.getBundleProgressHandler());
                        try {
                            PipelineTranslatorUtils.fireEligibleTimers((InMemoryTimerInternals)timerInternals, (Map)bundle.getTimerReceivers(), (Object)this.currentTimerKey);
                        }
                        finally {
                            if (bundle == null) continue;
                            bundle.close();
                        }
                    }
                    iterator = collector.iterator();
                    if (stageBundleFactory == null) break block23;
                }
                catch (Throwable throwable) {
                    if (stageBundleFactory != null) {
                        try {
                            stageBundleFactory.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stageBundleFactory.close();
            }
            return iterator;
        }
    }

    private void processElements(@UnknownKeyFor @NonNull @Initialized StateRequestHandler stateRequestHandler, @UnknownKeyFor @NonNull @Initialized ReceiverFactory receiverFactory, @UnknownKeyFor @NonNull @Initialized TimerReceiverFactory timerReceiverFactory, @UnknownKeyFor @NonNull @Initialized StageBundleFactory stageBundleFactory, @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> inputs) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try (RemoteBundle bundle = stageBundleFactory.getBundle((OutputReceiverFactory)receiverFactory, timerReceiverFactory, stateRequestHandler, this.getBundleProgressHandler());){
            FnDataReceiver mainReceiver = (FnDataReceiver)Iterables.getOnlyElement(bundle.getInputReceivers().values());
            while (inputs.hasNext()) {
                WindowedValue<InputT> input = inputs.next();
                mainReceiver.accept(input);
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized BundleProgressHandler getBundleProgressHandler() {
        String stageName = this.stagePayload.getInput();
        final MetricsContainerImpl container = this.metricsAccumulator.value().getContainer(stageName);
        return new BundleProgressHandler(){

            public void onProgress(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleProgressResponse progress) {
                container.update((Iterable)progress.getMonitoringInfosList());
            }

            public void onCompleted(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleResponse response) {
                container.update((Iterable)response.getMonitoringInfosList());
            }
        };
    }

    private @UnknownKeyFor @NonNull @Initialized StateRequestHandler getStateRequestHandler(@UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.ExecutableProcessBundleDescriptor processBundleDescriptor) {
        StateRequestHandler userStateHandler;
        StateRequestHandler sideInputHandler;
        EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler> handlerMap = new EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler>(BeamFnApi.StateKey.TypeCase.class);
        BatchSideInputHandlerFactory sideInputHandlerFactory = BatchSideInputHandlerFactory.forStage((ExecutableStage)executableStage, (BatchSideInputHandlerFactory.SideInputGetter)new BatchSideInputHandlerFactory.SideInputGetter(){

            public <T> @UnknownKeyFor @NonNull @Initialized List<T> getSideInput(@UnknownKeyFor @NonNull @Initialized String pCollectionId) {
                Tuple2 tuple2 = (Tuple2)SparkExecutableStageFunction.this.sideInputs.get(pCollectionId);
                Broadcast broadcast = (Broadcast)tuple2._1;
                WindowedValue.WindowedValueCoder coder = (WindowedValue.WindowedValueCoder)tuple2._2;
                return ((List)broadcast.value()).stream().map(bytes -> (WindowedValue)CoderHelpers.fromByteArray(bytes, coder)).collect(Collectors.toList());
            }
        });
        try {
            sideInputHandler = StateRequestHandlers.forSideInputHandlerFactory((Map)ProcessBundleDescriptors.getSideInputs((ExecutableStage)executableStage), (StateRequestHandlers.SideInputHandlerFactory)sideInputHandlerFactory);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to setup state handler", e);
        }
        if (this.bagUserStateHandlerFactory == null) {
            this.bagUserStateHandlerFactory = new InMemoryBagUserStateFactory();
        }
        if (executableStage.getUserStates().size() > 0) {
            this.bagUserStateHandlerFactory.resetForNewKey();
            userStateHandler = StateRequestHandlers.forBagUserStateHandlerFactory((ProcessBundleDescriptors.ExecutableProcessBundleDescriptor)processBundleDescriptor, (StateRequestHandlers.BagUserStateHandlerFactory)this.bagUserStateHandlerFactory);
        } else {
            userStateHandler = StateRequestHandler.unsupported();
        }
        handlerMap.put(BeamFnApi.StateKey.TypeCase.ITERABLE_SIDE_INPUT, sideInputHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_SIDE_INPUT, sideInputHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_KEYS_SIDE_INPUT, sideInputHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.BAG_USER_STATE, userStateHandler);
        return StateRequestHandlers.delegateBasedUponType(handlerMap);
    }

    private static class ReceiverFactory
    implements OutputReceiverFactory {
        private final @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@UnknownKeyFor @NonNull @Initialized RawUnionValue> collector;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> outputMap;

        ReceiverFactory(@UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@UnknownKeyFor @NonNull @Initialized RawUnionValue> collector, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> outputMap) {
            this.collector = collector;
            this.outputMap = outputMap;
        }

        public <OutputT> @UnknownKeyFor @NonNull @Initialized FnDataReceiver<OutputT> create(@UnknownKeyFor @NonNull @Initialized String pCollectionId) {
            Integer unionTag = this.outputMap.get(pCollectionId);
            if (unionTag != null) {
                int tagInt = unionTag;
                return receivedElement -> this.collector.add(new RawUnionValue(tagInt, receivedElement));
            }
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Unknown PCollectionId %s", pCollectionId));
        }
    }

    static interface JobBundleFactoryCreator
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized JobBundleFactory create();
    }
}

