/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import java.util.Objects;
import org.apache.beam.runners.core.StateMerging;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.transforms.Sum;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class AfterPaneStateMachine
extends TriggerStateMachine {
    private static final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long>> ELEMENTS_IN_PANE_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("count", VarLongCoder.of(), Sum.ofLongs()));
    private final @UnknownKeyFor @NonNull @Initialized int countElems;

    private AfterPaneStateMachine(@UnknownKeyFor @NonNull @Initialized int countElems) {
        super(null);
        this.countElems = countElems;
    }

    public @UnknownKeyFor @NonNull @Initialized int getElementCount() {
        return this.countElems;
    }

    public static @UnknownKeyFor @NonNull @Initialized AfterPaneStateMachine elementCountAtLeast(@UnknownKeyFor @NonNull @Initialized int countElems) {
        return new AfterPaneStateMachine(countElems);
    }

    @Override
    public void prefetchOnElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        c.state().access(ELEMENTS_IN_PANE_TAG).readLater();
    }

    @Override
    public void onElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnElementContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        c.state().access(ELEMENTS_IN_PANE_TAG).add(1L);
    }

    @Override
    public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.MergingPrefetchContext context) {
        StateMerging.prefetchCombiningValues(context.state(), ELEMENTS_IN_PANE_TAG);
    }

    @Override
    public void onMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnMergeContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (context.trigger().finishedInAnyMergingWindow()) {
            context.trigger().setFinished(true);
            StateMerging.clear(context.state(), ELEMENTS_IN_PANE_TAG);
            return;
        }
        StateMerging.mergeCombiningValues(context.state(), ELEMENTS_IN_PANE_TAG);
    }

    @Override
    public void prefetchShouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext context) {
        context.state().access(ELEMENTS_IN_PANE_TAG).readLater();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean shouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long count = context.state().access(ELEMENTS_IN_PANE_TAG).read();
        return count >= (long)this.countElems;
    }

    @Override
    public void clear(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        c.state().access(ELEMENTS_IN_PANE_TAG).clear();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine other) {
        return this.equals(other);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "AfterPane.elementCountAtLeast(" + this.countElems + ")";
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterPaneStateMachine)) {
            return false;
        }
        AfterPaneStateMachine that = (AfterPaneStateMachine)obj;
        return this.countElems == that.countElems;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.countElems);
    }

    @Override
    public void onFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.clear(context);
        context.trigger().setFinished(true);
    }
}

