/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.xerial.snappy.Snappy;

public class SnappyCoder<@UnknownKeyFor T>
extends StructuredCoder<T> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> innerCoder;

    public static <T> @UnknownKeyFor @NonNull @Initialized SnappyCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> innerCoder) {
        return new SnappyCoder<T>(innerCoder);
    }

    private SnappyCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> innerCoder) {
        this.innerCoder = innerCoder;
    }

    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ByteArrayCoder.of().encode(Snappy.compress((byte[])CoderUtils.encodeToByteArray(this.innerCoder, value)), os);
    }

    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return CoderUtils.decodeFromByteArray(this.innerCoder, Snappy.uncompress((byte[])ByteArrayCoder.of().decode(is)));
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return ImmutableList.of(this.innerCoder);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.innerCoder.verifyDeterministic();
    }
}

